/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginLoadProgressManager;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LoadDescriptorsContext
implements AutoCloseable {
    @NotNull
    private final ExecutorService myExecutorService;
    private final PluginLoadProgressManager myPluginLoadProgressManager;
    private final Collection<Interner<String>> myInterners;
    private final ThreadLocal<SafeJdomFactory> myThreadLocalXmlFactory;

    LoadDescriptorsContext(@Nullable PluginLoadProgressManager pluginLoadProgressManager, boolean isParallel) {
        int maxThreads;
        this.myPluginLoadProgressManager = pluginLoadProgressManager;
        int n = maxThreads = isParallel ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (maxThreads > 1) {
            this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PluginManager Loader", (int)maxThreads);
            this.myInterners = Collections.newSetFromMap(ContainerUtil.newConcurrentMap((int)maxThreads));
        } else {
            this.myExecutorService = new SameThreadExecutorService();
            this.myInterners = new SmartList();
        }
        this.myThreadLocalXmlFactory = ThreadLocal.withInitial(() -> {
            PluginXmlFactory factory = new PluginXmlFactory();
            this.myInterners.add((Interner<String>)factory.stringInterner);
            return factory;
        });
    }

    @NotNull
    ExecutorService getExecutorService() {
        return this.myExecutorService;
    }

    @Nullable
    PluginLoadProgressManager getPluginLoadProgressManager() {
        return this.myPluginLoadProgressManager;
    }

    @Nullable
    public SafeJdomFactory getXmlFactory() {
        return this.myThreadLocalXmlFactory.get();
    }

    @Override
    public void close() {
        if (this.myExecutorService instanceof SameThreadExecutorService) {
            this.myThreadLocalXmlFactory.remove();
            return;
        }
        this.myExecutorService.submit(() -> {
            for (Interner<String> interner : this.myInterners) {
                interner.clear();
            }
        });
        this.myExecutorService.shutdown();
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private volatile boolean isTerminated;

        private SameThreadExecutorService() {
        }

        @Override
        public void shutdown() {
            this.isTerminated = true;
        }

        @Override
        public boolean isShutdown() {
            return this.isTerminated;
        }

        @Override
        public boolean isTerminated() {
            return this.isTerminated;
        }

        @Override
        public boolean awaitTermination(long theTimeout, @NotNull TimeUnit theUnit) {
            this.shutdown();
            return true;
        }

        @Override
        @NotNull
        @Contract(pure=true)
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public void execute(@NotNull Runnable command) {
            command.run();
        }
    }

    private static final class PluginXmlFactory
    extends SafeJdomFactory.BaseSafeJdomFactory {
        private static final Set<String> CLASS_NAMES = ContainerUtil.newIdentityTroveSet(Arrays.asList("implementation-class", "implementation", "serviceImplementation", "class", "className", "beanClass", "serviceInterface", "interface", "interfaceClass", "instance", "qualifiedName"));
        private final Interner<String> stringInterner = new Interner<String>(CLASS_NAMES){

            @NotNull
            public String intern(@NotNull String name) {
                return name.length() < 64 ? (String)super.intern((Object)name) : name;
            }
        };

        private PluginXmlFactory() {
        }

        @NotNull
        public Element element(@NotNull String name, @Nullable Namespace namespace) {
            return super.element((String)this.stringInterner.intern((Object)name), namespace);
        }

        @NotNull
        public Attribute attribute(@NotNull String name, @NotNull String value, @Nullable AttributeType type, @Nullable Namespace namespace) {
            String internedName = (String)this.stringInterner.intern((Object)name);
            if (CLASS_NAMES.contains(internedName)) {
                return super.attribute(internedName, value, type, namespace);
            }
            return super.attribute(internedName, (String)this.stringInterner.intern((Object)value), type, namespace);
        }

        @NotNull
        public Text text(@NotNull String text, @NotNull Element parentElement) {
            if (CLASS_NAMES.contains(parentElement.getName())) {
                return super.text(text, parentElement);
            }
            return super.text((String)this.stringInterner.intern((Object)text), parentElement);
        }
    }
}

