/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

final class PluginLoadProgressManager {
    private final StartupProgress progress;
    private final int pluginsCount;
    private int loadedCount;

    PluginLoadProgressManager(@NotNull StartupProgress progress, int urlCountFromClassPath) {
        this.progress = progress;
        this.pluginsCount = PluginLoadProgressManager.countPlugins(PathManager.getPluginsPath()) + PluginLoadProgressManager.countPlugins(PathManager.getPreInstalledPluginsPath()) + urlCountFromClassPath;
    }

    void showProgress(@NotNull IdeaPluginDescriptor descriptor) {
        ++this.loadedCount;
        if (this.loadedCount % 20 == 0) {
            this.progress.showProgress(descriptor.getName(), 0.3f * ((float)this.loadedCount / (float)this.pluginsCount));
        }
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list2 = new File(pluginsPath).list();
        return list2 == null ? 0 : list2.length;
    }
}

