/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonToken;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.BackButton;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.DetailsPagePluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.PluginSiteUtils;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGridLayout;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsListLayout;
import com.intellij.ide.plugins.newui.ScrollEventHandler;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupController;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.TabHeaderComponent;
import com.intellij.ide.plugins.newui.TagBuilder;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class PluginManagerConfigurableNew
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    public static final String ID = "preferences.pluginManager";
    private static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    private static final int TRENDING_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    private static final int UPDATES_TAB = 2;
    private static final int TRENDING_SEARCH_TAB = 3;
    private static final int INSTALLED_SEARCH_TAB = 4;
    private static final int UPDATES_SEARCH_TAB = 5;
    private static final int ITEMS_PER_GROUP = 9;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");
    public static final Color MAIN_BG_COLOR = JBColor.namedColor((String)"Plugins.background", (Color)new JBColor(UIUtil.getListBackground(), new Color(0x313335)));
    private static final Color SEARCH_BG_COLOR = JBColor.namedColor((String)"Plugins.SearchField.background", (Color)MAIN_BG_COLOR);
    private static final Color SEARCH_FIELD_BORDER_COLOR = JBColor.namedColor((String)"Plugins.SearchField.borderColor", (Color)new JBColor(0xC5C5C5, 0x515151));
    private static final SimpleTextAttributes GRAY_ATTRIBUTES = new SimpleTextAttributes(0, ListPluginComponent.DisabledColor);
    private final TagBuilder myTagBuilder;
    private LinkListener<IdeaPluginDescriptor> myNameListener;
    private LinkListener<String> mySearchListener;
    private CardLayoutPanel<Object, Object, JComponent> myCardPanel;
    private TabHeaderComponent myTabHeaderComponent;
    private CountTabName myUpdatesTabName;
    private Configurable.TopComponentController myTopController;
    private final PluginSearchTextField mySearchTextField;
    private final Alarm mySearchUpdateAlarm = new Alarm();
    private PluginsGroupComponentWithProgress myTrendingPanel;
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroupComponentWithProgress myUpdatesPanel;
    private Runnable myTrendingRunnable;
    private Runnable myUpdatesRunnable;
    private SearchResultPanel myTrendingSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private SearchResultPanel myUpdatesSearchPanel;
    private SearchResultPanel myCurrentSearchPanel;
    private final MyPluginModel myPluginsModel = new MyPluginModel(){

        @Override
        public List<IdeaPluginDescriptor> getAllRepoPlugins() {
            return PluginManagerConfigurableNew.this.getPluginRepositories();
        }
    };
    private Runnable myShutdownCallback;
    private PluginUpdatesService myPluginUpdatesService;
    private List<IdeaPluginDescriptor> myAllRepositoriesList;
    private Map<String, IdeaPluginDescriptor> myAllRepositoriesMap;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoriesMap;
    private final Object myRepositoriesLock = new Object();
    private List<String> myAllTagSorted;
    private Map<String, List<IdeaPluginDescriptor>> mySuggestCache;
    private boolean myIgnoreFocusFromBackButton;

    public PluginManagerConfigurableNew() {
        this.myTagBuilder = new TagBuilder(){

            @Override
            @NotNull
            public TagComponent createTagComponent(@NotNull String tag) {
                return PluginManagerConfigurableNew.installTiny(new TagComponent(tag));
            }
        };
        this.mySearchTextField = new PluginSearchTextField(){

            protected boolean preprocessEventForTextField(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int id = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    String text;
                    if (!(id != 401 || ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleEnter(event) || (text = PluginManagerConfigurableNew.this.mySearchTextField.getText()).isEmpty())) {
                        if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                            ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                        }
                        PluginManagerConfigurableNew.this.showSearchPanel(text);
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id == 401 && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleUpDown(event)) {
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            protected boolean toClearTextOnEscape() {
                new AnAction(){
                    {
                        this.setEnabledInModalContext(true);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        e.getPresentation().setEnabled(!this.getText().isEmpty());
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.isPopupShow()) {
                            ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                        } else {
                            this.setText("");
                        }
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
                return false;
            }

            protected void onFieldCleared() {
                PluginManagerConfigurableNew.this.hideSearchPanel();
            }

            @Override
            protected void showCompletionPopup() {
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null && !((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.isPopupShow()) {
                    PluginManagerConfigurableNew.this.showSearchPopup();
                }
            }
        };
        this.mySearchTextField.setBorder(JBUI.Borders.customLine((Color)SEARCH_FIELD_BORDER_COLOR));
        JBTextField editor = this.mySearchTextField.getTextEditor();
        editor.putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUI.scale((int)6));
        editor.putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUI.scale((int)-1));
        editor.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        editor.setBorder((Border)JBUI.Borders.empty((int)0, (int)6));
        editor.setOpaque(true);
        editor.setBackground(SEARCH_BG_COLOR);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField.getTextEditor();
    }

    @Nullable
    public JComponent createComponent() {
        final JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                EventHandler.addGlobalAction((JComponent)((Object)PluginManagerConfigurableNew.this.mySearchTextField), new CustomShortcutSet(KeyStroke.getKeyStroke("meta alt F")), () -> {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)PluginManagerConfigurableNew.this.mySearchTextField), true));
                    if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                        PluginManagerConfigurableNew.this.showSearchPopup();
                    }
                });
            }
        };
        panel2.setMinimumSize((Dimension)new JBDimension(580, 380));
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new DumbAwareAction("Manage Plugin Repositories..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel2, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                }
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (HttpConfigurable.editConfigurable((JComponent)panel2)) {
                    PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                }
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new DumbAwareAction("Install Plugin from Disk..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InstalledPluginsManagerMain.chooseAndInstall(PluginManagerConfigurableNew.this.myPluginsModel, (Consumer<? super Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> {
                    boolean select;
                    PluginManagerConfigurableNew.this.myPluginsModel.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second);
                    boolean bl = select = PluginManagerConfigurableNew.this.myInstalledPanel == null;
                    if (PluginManagerConfigurableNew.this.myTabHeaderComponent.getSelectionTab() != 1) {
                        PluginManagerConfigurableNew.this.myTabHeaderComponent.setSelectionWithEvents(1);
                    }
                    PluginManagerConfigurableNew.this.hideSearchPanel();
                    PluginManagerConfigurableNew.this.mySearchTextField.setTextIgnoreEvents("");
                    if (select) {
                        for (UIPluginGroup group : PluginManagerConfigurableNew.this.myInstalledPanel.getGroups()) {
                            CellPluginComponent component = group.findComponent((IdeaPluginDescriptor)pair.second);
                            if (component == null) continue;
                            PluginManagerConfigurableNew.this.myInstalledPanel.setSelection(component);
                            break;
                        }
                    }
                }), panel2);
            }
        });
        panel2.add((Component)((Object)this.mySearchTextField), "North");
        this.myNameListener = (label2, descriptor) -> {
            int detailBackTabIndex = -1;
            if (label2 == null) {
                if (this.myPluginsModel.detailPanel != null) {
                    detailBackTabIndex = this.myPluginsModel.detailPanel.backTabIndex;
                }
                this.removeDetailsPanel();
            }
            assert (this.myPluginsModel.detailPanel == null);
            int currentTab = detailBackTabIndex == -1 ? this.myTabHeaderComponent.getSelectionTab() : detailBackTabIndex;
            final BackButton backButton = new BackButton();
            backButton.addActionListener(event -> {
                this.removeDetailsPanel();
                this.myIgnoreFocusFromBackButton = true;
                this.myCardPanel.select(this.myCurrentSearchPanel.isEmpty() ? currentTab : this.myCurrentSearchPanel.tabIndex, true);
                PluginManagerConfigurableNew.storeSelectionTab(currentTab);
                this.myTabHeaderComponent.setSelection(currentTab);
            });
            this.myCardPanel.select(Pair.create((Object)descriptor, (Object)(label2 != null && currentTab == 2 ? 1 : 0)), true);
            this.myPluginsModel.detailPanel.backTabIndex = currentTab;
            NonOpaquePanel buttonPanel = new NonOpaquePanel(backButton){

                public int getBaseline(int width, int height) {
                    return backButton.getBaseline(width, height);
                }
            };
            buttonPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
            this.myTopController.setLeftComponent((Component)buttonPanel);
            this.myTabHeaderComponent.clearSelection();
        };
        this.mySearchListener = (_0, query) -> {
            this.removeDetailsPanel();
            this.mySearchTextField.setTextIgnoreEvents((String)query);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.mySearchTextField), true));
            this.myCurrentSearchPanel.setEmpty();
            this.showSearchPanel((String)query);
        };
        this.mySearchTextField.getTextEditor().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PluginManagerConfigurableNew.this.myIgnoreFocusFromBackButton) {
                    PluginManagerConfigurableNew.this.myIgnoreFocusFromBackButton = false;
                    return;
                }
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                    PluginManagerConfigurableNew.this.showSearchPopup();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller != null) {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.hidePopup();
                }
            }
        });
        this.mySearchTextField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (!PluginManagerConfigurableNew.this.mySearchTextField.isSkipDocumentEvents()) {
                    PluginManagerConfigurableNew.this.mySearchUpdateAlarm.cancelAllRequests();
                    PluginManagerConfigurableNew.this.mySearchUpdateAlarm.addRequest(this::searchOnTheFly, 100, ModalityState.stateForComponent((Component)((Object)PluginManagerConfigurableNew.this.mySearchTextField)));
                }
            }

            private void searchOnTheFly() {
                String text = PluginManagerConfigurableNew.this.mySearchTextField.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    PluginManagerConfigurableNew.this.hideSearchPanel();
                } else if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller == null) {
                    PluginManagerConfigurableNew.this.showSearchPanel(text);
                } else {
                    ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myCurrentSearchPanel.controller.handleShowPopup();
                }
            }
        });
        this.myCardPanel = new CardLayoutPanel<Object, Object, JComponent>(){

            @Override
            public ActionCallback select(Object key, boolean now) {
                ActionCallback callback2 = super.select(key, now);
                callback2.doWhenDone(() -> {
                    for (Component component : this.getComponents()) {
                        Component view;
                        if (!component.isVisible() || !(component instanceof JScrollPane) || !((view = ((JScrollPane)component).getViewport().getView()) instanceof PluginsGroupComponentWithProgress)) continue;
                        view.setVisible(true);
                    }
                    panel2.doLayout();
                    panel2.revalidate();
                    panel2.repaint();
                });
                return callback2;
            }

            @Override
            protected Object prepare(Object key) {
                return key;
            }

            @Override
            protected JComponent create(Object key) {
                if (key instanceof Integer) {
                    Integer index = (Integer)key;
                    if (index == 0) {
                        return PluginManagerConfigurableNew.this.createTrendingPanel();
                    }
                    if (index == 1) {
                        return PluginManagerConfigurableNew.this.createInstalledPanel();
                    }
                    if (index == 2) {
                        return PluginManagerConfigurableNew.this.createUpdatesPanel();
                    }
                    if (index == 3) {
                        return PluginManagerConfigurableNew.this.myTrendingSearchPanel.createScrollPane();
                    }
                    if (index == 4) {
                        return PluginManagerConfigurableNew.this.myInstalledSearchPanel.createScrollPane();
                    }
                    if (index == 5) {
                        return PluginManagerConfigurableNew.this.myUpdatesSearchPanel.createScrollPane();
                    }
                    throw new RuntimeException("Create card unknown KEY index: " + key);
                }
                return PluginManagerConfigurableNew.this.createDetailsPanel((Pair<IdeaPluginDescriptor, Boolean>)((Pair)key));
            }
        };
        panel2.add(this.myCardPanel);
        this.myTabHeaderComponent = new TabHeaderComponent(actions, index -> {
            this.removeDetailsPanel();
            this.myIgnoreFocusFromBackButton = false;
            this.myCardPanel.select(index, true);
            PluginManagerConfigurableNew.storeSelectionTab(index);
            this.updateSearchForSelectedTab(index);
            if (!this.myCurrentSearchPanel.isEmpty()) {
                this.myCardPanel.select(this.myCurrentSearchPanel.tabIndex, true);
            }
        });
        this.myTabHeaderComponent.addTab("Marketplace");
        this.myTabHeaderComponent.addTab("Installed");
        this.myUpdatesTabName = new CountTabName(this.myTabHeaderComponent, "Updates");
        this.myTabHeaderComponent.addTab(this.myUpdatesTabName);
        this.myPluginUpdatesService = PluginUpdatesService.connectConfigurable(countValue -> this.myUpdatesTabName.setCount(countValue == null ? 0 : countValue));
        this.myPluginsModel.setPluginUpdatesService(this.myPluginUpdatesService);
        this.createSearchPanels();
        int selectionTab = PluginManagerConfigurableNew.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        this.updateSearchForSelectedTab(selectionTab);
        panel2.addComponentListener(new ComponentAdapter(){
            boolean myStoreHosts;
            List<String> myHosts;

            @Override
            public void componentShown(ComponentEvent e) {
                this.myStoreHosts = true;
                if (this.myHosts != null) {
                    List<String> oldHosts = this.myHosts;
                    List<String> newHosts = UpdateSettings.getInstance().getPluginHosts();
                    this.myHosts = null;
                    if (oldHosts.size() != newHosts.size()) {
                        PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                        return;
                    }
                    for (String host : oldHosts) {
                        if (newHosts.contains(host)) continue;
                        PluginManagerConfigurableNew.this.resetTrendingAndUpdatesPanels();
                        return;
                    }
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (this.myStoreHosts) {
                    this.myHosts = UpdateSettings.getInstance().getPluginHosts();
                }
            }
        });
        return panel2;
    }

    private void showSearchPopup() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySearchTextField.getText())) {
            this.myCurrentSearchPanel.controller.showAttributesPopup(null, 0);
        } else {
            this.myCurrentSearchPanel.controller.handleShowPopup();
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        if (StringUtil.isEmpty((String)option2) && this.myCurrentSearchPanel.isEmpty()) {
            return null;
        }
        return () -> {
            if (this.myTabHeaderComponent.getSelectionTab() != 1) {
                this.myTabHeaderComponent.setSelectionWithEvents(1);
            }
            this.hideSearchPanel();
            this.mySearchTextField.setTextIgnoreEvents(option2);
            if (!StringUtil.isEmpty((String)option2)) {
                this.showSearchPanel(option2);
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.myIgnoreFocusFromBackButton = true;
        if (this.myTabHeaderComponent.getSelectionTab() != 1) {
            this.myTabHeaderComponent.setSelectionWithEvents(1);
        }
        if (descriptors.length == 0) {
            return;
        }
        ArrayList<CellPluginComponent> components = new ArrayList<CellPluginComponent>();
        block0: for (IdeaPluginDescriptor descriptor : descriptors) {
            for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                CellPluginComponent component = group.findComponent(descriptor);
                if (component == null) continue;
                components.add(component);
                continue block0;
            }
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @NotNull
    public MyPluginModel getPluginsModel() {
        return this.myPluginsModel;
    }

    private void updateSearchForSelectedTab(int index) {
        String historyPropertyName;
        SearchResultPanel searchPanel;
        String text;
        if (index == 0) {
            text = "Search plugins in marketplace";
            if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                text = text + " and custom repositories";
            }
            searchPanel = this.myTrendingSearchPanel;
            historyPropertyName = "TrendingPluginsSearchHistory";
        } else if (index == 1) {
            text = "Search installed plugins";
            searchPanel = this.myInstalledSearchPanel;
            historyPropertyName = "InstalledPluginsSearchHistory";
        } else {
            text = "Search available updates";
            searchPanel = this.myUpdatesSearchPanel;
            historyPropertyName = "UpdatePluginsSearchHistory";
        }
        StatusText emptyText = this.mySearchTextField.getTextEditor().getEmptyText();
        emptyText.clear();
        emptyText.appendText(text, new SimpleTextAttributes(0, CellPluginComponent.GRAY_COLOR));
        this.myCurrentSearchPanel = searchPanel;
        this.mySearchTextField.addCurrentTextToHistory();
        this.mySearchTextField.setHistoryPropertyName(historyPropertyName);
        this.mySearchTextField.setTextIgnoreEvents(searchPanel.getQuery());
    }

    private void showSearchPanel(@NotNull String query) {
        if (this.myCurrentSearchPanel.isEmpty()) {
            this.myCardPanel.select(this.myCurrentSearchPanel.tabIndex, true);
        }
        this.myCurrentSearchPanel.setQuery(query);
    }

    private void hideSearchPanel() {
        if (!this.myCurrentSearchPanel.isEmpty()) {
            this.myCardPanel.select(this.myCurrentSearchPanel.backTabIndex, true);
            this.myCurrentSearchPanel.setQuery("");
        }
        if (this.myCurrentSearchPanel.controller != null) {
            this.myCurrentSearchPanel.controller.hidePopup();
        }
    }

    private void removeDetailsPanel() {
        if (this.myPluginsModel.detailPanel != null) {
            this.mySearchTextField.setVisible(true);
            this.myPluginsModel.detailPanel.close();
            this.myPluginsModel.detailPanel = null;
            this.myTopController.setLeftComponent(null);
            this.myCardPanel.remove(this.myCardPanel.getComponentCount() - 1);
        }
    }

    private static int getStoredSelectionTab() {
        int value = PropertiesComponent.getInstance().getInt(SELECTION_TAB_KEY, 0);
        return value >= 0 && value <= 2 ? value : 0;
    }

    private static void storeSelectionTab(int value) {
        if (value >= 0 && value <= 2) {
            PropertiesComponent.getInstance().setValue(SELECTION_TAB_KEY, value, 0);
        }
    }

    public void disposeUIResources() {
        this.myPluginsModel.toBackground();
        Disposer.dispose((Disposable)this.mySearchUpdateAlarm);
        this.myTrendingSearchPanel.dispose();
        this.myPluginUpdatesService.dispose();
        if (this.myTrendingPanel != null) {
            this.myTrendingPanel.dispose();
        }
        if (this.myUpdatesPanel != null) {
            this.myUpdatesPanel.dispose();
        }
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public void apply() throws ConfigurationException {
        Map<PluginId, Boolean> enabledMap = this.myPluginsModel.getEnabledMap();
        ArrayList<String> dependencies = new ArrayList<String>();
        block2: for (Map.Entry<PluginId, Set<PluginId>> entry : this.myPluginsModel.getDependentToRequiredListMap().entrySet()) {
            PluginId id = entry.getKey();
            if (enabledMap.get(id) == null) continue;
            for (PluginId dependId : entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependId)) continue;
                IdeaPluginDescriptor descriptor = PluginManager.getPlugin(id);
                if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted()) continue block2;
                dependencies.add("\"" + (descriptor == null ? id.getIdString() : descriptor.getName()) + "\"");
                continue block2;
            }
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException("<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependencies.size() == 1 ? " " : "s ") + StringUtil.join(dependencies, (String)", ") + " won't be able to load.</body></html>");
        }
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor = this.myPluginsModel.getObjectAt(i);
            descriptor.setEnabled(this.myPluginsModel.isEnabled(descriptor.getPluginId()));
        }
        ArrayList<String> disableIds = new ArrayList<String>();
        for (Map.Entry entry : enabledMap.entrySet()) {
            Boolean enabled = (Boolean)entry.getValue();
            if (enabled == null || enabled.booleanValue()) continue;
            disableIds.add(((PluginId)entry.getKey()).getIdString());
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disableIds, false);
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (this.myShutdownCallback == null && this.myPluginsModel.createShutdownCallback) {
            this.myShutdownCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0])));
        }
    }

    public boolean isModified() {
        if (this.myPluginsModel.needRestart) {
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor = this.myPluginsModel.getObjectAt(i);
            boolean enabledInTable = this.myPluginsModel.isEnabled(descriptor);
            if (descriptor.isEnabled() == enabledInTable || enabledInTable && !disabledPlugins.contains(descriptor.getPluginId().getIdString())) continue;
            return true;
        }
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginsModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(entry.getKey().getIdString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        this.myTopController = controller;
        this.myPluginsModel.setTopController(controller);
        return this.myTabHeaderComponent;
    }

    @NotNull
    private JComponent createTrendingPanel() {
        this.myTrendingPanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsGridLayout()), new ScrollEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new GridCellPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, this.myTagBuilder)));
        Runnable runnable2 = () -> {
            ArrayList<PluginsGroup> groups = new ArrayList<PluginsGroup>();
            try {
                Pair<Map<String, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> pair = this.loadPluginRepositories();
                Map allRepositoriesMap = (Map)pair.first;
                Map customRepositoriesMap = (Map)pair.second;
                try {
                    this.addGroup(groups, allRepositoriesMap, "Featured", "is_featured_search=true", "sortBy:featured");
                    this.addGroup(groups, allRepositoriesMap, "New and Updated", "orderBy=update+date", "sortBy:updated");
                    this.addGroup(groups, allRepositoriesMap, "Top Downloads", "orderBy=downloads", "sortBy:downloads");
                    this.addGroup(groups, allRepositoriesMap, "Top Rated", "orderBy=rating", "sortBy:rating");
                }
                catch (IOException e) {
                    PluginManagerMain.LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                }
                for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                    List allDescriptors = (List)customRepositoriesMap.get(host);
                    if (allDescriptors == null) continue;
                    this.addGroup(groups, "Repository: " + host, "repository:\"" + host + "\"", (ThrowableNotNullFunction<List<IdeaPluginDescriptor>, Boolean, IOException>)((ThrowableNotNullFunction)descriptors -> {
                        int allSize = allDescriptors.size();
                        descriptors.addAll(ContainerUtil.getFirstItems((List)allDescriptors, (int)9));
                        PluginsGroup.sortByName(descriptors);
                        return allSize > 9;
                    }));
                }
            }
            catch (IOException e) {
                PluginManagerMain.LOG.info((Throwable)e);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myTrendingPanel.stopLoading();
                    PluginLogo.startBatchMode();
                    for (PluginsGroup group : groups) {
                        this.myTrendingPanel.addGroup(group);
                    }
                    PluginLogo.endBatchMode();
                    this.myTrendingPanel.doLayout();
                    this.myTrendingPanel.initialSelection();
                }, ModalityState.any());
            }
        };
        this.myTrendingRunnable = () -> {
            this.myTrendingPanel.clear();
            this.myTrendingPanel.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        };
        this.myTrendingPanel.getEmptyText().setText("Marketplace plugins are not loaded.").appendSecondaryText("Check the internet connection and ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText("refresh", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myTrendingRunnable.run());
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        return PluginManagerConfigurableNew.createScrollPane(this.myTrendingPanel, false);
    }

    @NotNull
    private JComponent createInstalledPanel() {
        PluginsGroupComponent panel2 = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, false)));
        PluginManagerConfigurableNew.registerCopyProvider(panel2);
        PluginLogo.startBatchMode();
        PluginsGroup installing = new PluginsGroup("Installing");
        installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
        if (!installing.descriptors.isEmpty()) {
            installing.sortByName();
            installing.titleWithCount();
            panel2.addGroup(installing);
        }
        PluginsGroup downloaded = new PluginsGroup("Downloaded");
        PluginsGroup bundled = new PluginsGroup("Bundled");
        downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        int bundledEnabled = 0;
        int downloadedEnabled = 0;
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (appInfo.isEssentialPlugin(descriptor2.getPluginId().getIdString())) continue;
            if (descriptor2.isBundled()) {
                bundled.descriptors.add(descriptor2);
                if (!descriptor2.isEnabled()) continue;
                ++bundledEnabled;
                continue;
            }
            downloaded.descriptors.add(descriptor2);
            if (!descriptor2.isEnabled()) continue;
            ++downloadedEnabled;
        }
        if (!downloaded.descriptors.isEmpty()) {
            downloaded.sortByName();
            downloaded.titleWithCount(downloadedEnabled);
            panel2.addGroup(downloaded);
            this.myPluginsModel.addEnabledGroup(downloaded);
        }
        this.myPluginsModel.setDownloadedGroup(panel2, downloaded, installing);
        bundled.sortByName();
        bundled.titleWithCount(bundledEnabled);
        panel2.addGroup(bundled);
        this.myPluginsModel.addEnabledGroup(bundled);
        this.myInstalledPanel = panel2;
        this.myPluginUpdatesService.connectInstalled(updates -> {
            if (ContainerUtil.isEmpty((Collection)updates)) {
                for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                    for (CellPluginComponent plugin : group.plugins) {
                        ((ListPluginComponent)plugin).setUpdateDescriptor(null);
                    }
                }
            } else {
                block2: for (PluginDownloader downloader : updates) {
                    IdeaPluginDescriptor descriptor = downloader.getDescriptor();
                    for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                        CellPluginComponent component = group.findComponent(descriptor);
                        if (component == null) continue;
                        ((ListPluginComponent)component).setUpdateDescriptor(descriptor);
                        continue block2;
                    }
                }
            }
        });
        PluginLogo.endBatchMode();
        return PluginManagerConfigurableNew.createScrollPane(panel2, true);
    }

    @NotNull
    private JComponent createUpdatesPanel() {
        this.myUpdatesPanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, true)));
        PluginManagerConfigurableNew.registerCopyProvider(this.myUpdatesPanel);
        this.myUpdatesRunnable = () -> {
            this.myUpdatesPanel.clear();
            this.myUpdatesPanel.startLoading();
            this.myPluginUpdatesService.calculateUpdates(updates -> {
                this.myUpdatesPanel.stopLoading();
                if (!ContainerUtil.isEmpty((Collection)updates)) {
                    final PluginsGroup group = new PluginsGroup("Available Updates"){

                        @Override
                        public void titleWithCount() {
                            int count = 0;
                            for (CellPluginComponent component : this.ui.plugins) {
                                if (((ListPluginComponent)component).myUpdateButton == null) continue;
                                ++count;
                            }
                            this.title = this.myTitlePrefix + " (" + count + ")";
                            this.updateTitle();
                            this.rightAction.setVisible(count > 0);
                        }
                    };
                    group.rightAction = new LinkLabel("Update All", null);
                    group.rightAction.setListener((LinkListener)new LinkListener<Object>(){

                        public void linkSelected(LinkLabel aSource, Object aLinkData) {
                            for (CellPluginComponent component : group.ui.plugins) {
                                ((ListPluginComponent)component).updatePlugin();
                            }
                        }
                    }, null);
                    for (PluginDownloader toUpdateDownloader : updates) {
                        group.descriptors.add(toUpdateDownloader.getDescriptor());
                    }
                    PluginLogo.startBatchMode();
                    group.sortByName();
                    this.myUpdatesPanel.addGroup(group);
                    group.titleWithCount();
                    PluginLogo.endBatchMode();
                    this.myPluginsModel.setUpdateGroup(group);
                }
                this.myUpdatesPanel.doLayout();
                this.myUpdatesPanel.initialSelection();
            });
        };
        this.myUpdatesPanel.getEmptyText().setText("No updates available.").appendSecondaryText("Check new updates", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myUpdatesRunnable.run());
        this.myUpdatesRunnable.run();
        return PluginManagerConfigurableNew.createScrollPane(this.myUpdatesPanel, false);
    }

    private void createSearchPanels() {
        SearchPopupController trendingController = new SearchPopupController(this.mySearchTextField){

            @Override
            @NotNull
            protected List<String> getAttributes() {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("tag:");
                if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                    attributes.add("repository:");
                }
                attributes.add("sortBy:");
                return attributes;
            }

            @Override
            @Nullable
            protected List<String> getValues(@NotNull String attribute) {
                switch (attribute) {
                    case "tag:": {
                        if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurableNew.this.myAllTagSorted)) {
                            HashSet<String> allTags = new HashSet<String>();
                            for (IdeaPluginDescriptor descriptor : PluginManagerConfigurableNew.this.getPluginRepositories()) {
                                List<String> tags;
                                if (!(descriptor instanceof PluginNode) || ContainerUtil.isEmpty(tags = ((PluginNode)descriptor).getTags())) continue;
                                allTags.addAll(tags);
                            }
                            PluginManagerConfigurableNew.this.myAllTagSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                        }
                        return PluginManagerConfigurableNew.this.myAllTagSorted;
                    }
                    case "repository:": {
                        return UpdateSettings.getInstance().getPluginHosts();
                    }
                    case "sortBy:": {
                        return ContainerUtil.list((Object[])new String[]{"downloads", "name", "rating", "featured", "updated"});
                    }
                }
                return null;
            }

            @Override
            protected void showPopupForQuery() {
                boolean update;
                String query = PluginManagerConfigurableNew.this.mySearchTextField.getText().trim();
                if (PluginManagerConfigurableNew.this.mySearchTextField.getTextEditor().getCaretPosition() < query.length()) {
                    this.hidePopup();
                    return;
                }
                List<IdeaPluginDescriptor> result2 = this.getSuggestPlugins(query);
                if (result2.isEmpty()) {
                    this.hidePopup();
                    return;
                }
                boolean async = this.myPopup != null;
                boolean bl = update = this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery && this.myPopup.isValid();
                if (update) {
                    this.myPopup.model.replaceAll(result2);
                } else {
                    this.createPopup(SearchPopup.Type.SearchQuery, (CollectionListModel<Object>)new CollectionListModel(result2), 0);
                }
                this.myPopup.data = query;
                if (update) {
                    this.myPopup.update();
                    return;
                }
                Consumer callback2 = descriptor -> {
                    this.hidePopup();
                    PluginManagerConfigurableNew.this.myNameListener.linkSelected(null, descriptor);
                };
                ColoredListCellRenderer renderer2 = new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)value;
                        String splitter = myPopup == null ? null : (String)(this).myPopup.data;
                        for (String partName : SearchQueryParser.split(descriptor.getName(), splitter)) {
                            this.append(partName, partName.equalsIgnoreCase(splitter) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        if (PluginManagerConfigurableNew.isJBPlugin(descriptor)) {
                            this.append(" by JetBrains", GRAY_ATTRIBUTES);
                        } else {
                            String vendor = descriptor.getVendor();
                            if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                                this.append(" by " + StringUtil.shortenPathWithEllipsis((String)vendor, (int)50), GRAY_ATTRIBUTES);
                            }
                        }
                    }
                };
                this.myPopup.createAndShow(callback2, renderer2, async);
            }

            @NotNull
            private List<IdeaPluginDescriptor> getSuggestPlugins(@NotNull String query) {
                List<IdeaPluginDescriptor> result2;
                if (PluginManagerConfigurableNew.this.mySuggestCache == null) {
                    PluginManagerConfigurableNew.this.mySuggestCache = new HashMap();
                }
                if ((result2 = (List<IdeaPluginDescriptor>)PluginManagerConfigurableNew.this.mySuggestCache.get(query)) == null) {
                    result2 = this.loadSuggestPlugins(query);
                    if (!query.isEmpty() && !result2.isEmpty()) {
                        PluginManagerConfigurableNew.this.mySuggestCache.put(query, result2);
                    }
                }
                return result2;
            }

            @NotNull
            private List<IdeaPluginDescriptor> loadSuggestPlugins(@NotNull String query) {
                LinkedHashSet result2 = new LinkedHashSet();
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            Pair p = PluginManagerConfigurableNew.this.loadPluginRepositories();
                            Map allRepositoriesMap = (Map)p.first;
                            Map customRepositoriesMap = (Map)p.second;
                            if (query.length() > 1) {
                                try {
                                    for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(PluginManagerConfigurableNew.createSearchSuggestUrl(query), PluginManagerConfigurableNew.forceHttps())) {
                                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                                        if (descriptor == null) continue;
                                        result2.add(descriptor);
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            for (List descriptors : customRepositoriesMap.values()) {
                                for (IdeaPluginDescriptor descriptor : descriptors) {
                                    if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)query)) continue;
                                    result2.add(descriptor);
                                }
                            }
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.info((Throwable)e);
                        }
                    }).get(300L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ContainerUtil.newArrayList(result2);
            }

            @Override
            protected void handleEnter() {
                if (!PluginManagerConfigurableNew.this.mySearchTextField.getText().isEmpty()) {
                    this.handleTrigger("marketplace.suggest.popup.enter");
                }
            }

            @Override
            protected void handlePopupListFirstSelection() {
                this.handleTrigger("marketplace.suggest.popup.select");
            }

            private void handleTrigger(@NonNls String key) {
                if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                }
            }
        };
        this.myTrendingSearchPanel = new SearchResultPanel(trendingController, this.createSearchPanelComponentWithProgress(), 3, 0){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                try {
                    Pair p = PluginManagerConfigurableNew.this.loadPluginRepositories();
                    Map allRepositoriesMap = (Map)p.first;
                    Map customRepositoriesMap = (Map)p.second;
                    SearchQueryParser.Trending parser = new SearchQueryParser.Trending(query);
                    if (!parser.repositories.isEmpty()) {
                        for (String repository : parser.repositories) {
                            List descriptors = (List)customRepositoriesMap.get(repository);
                            if (descriptors == null) continue;
                            if (parser.searchQuery == null) {
                                result2.descriptors.addAll(descriptors);
                                continue;
                            }
                            for (IdeaPluginDescriptor descriptor : descriptors) {
                                if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)parser.searchQuery)) continue;
                                result2.descriptors.add(descriptor);
                            }
                        }
                        result2.sortByName();
                        return;
                    }
                    for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(PluginManagerConfigurableNew.createSearchUrl(parser.getUrlQuery(), 10000), PluginManagerConfigurableNew.forceHttps())) {
                        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                        if (descriptor == null) continue;
                        result2.descriptors.add(descriptor);
                    }
                    if (parser.searchQuery != null) {
                        String builtinUrl = ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl();
                        ArrayList builtinList = new ArrayList();
                        for (Map.Entry entry : customRepositoriesMap.entrySet()) {
                            List<Object> descriptors = ((String)entry.getKey()).equals(builtinUrl) ? builtinList : result2.descriptors;
                            for (IdeaPluginDescriptor descriptor : (List)entry.getValue()) {
                                if (!StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)parser.searchQuery)) continue;
                                descriptors.add(descriptor);
                            }
                        }
                        result2.descriptors.addAll(0, builtinList);
                    }
                }
                catch (IOException e) {
                    PluginManagerMain.LOG.info((Throwable)e);
                    ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText("Search result are not loaded.").appendSecondaryText("Check the internet connection.", StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                }
            }
        };
        SearchPopupController installedController = new SearchPopupController(this.mySearchTextField){

            @Override
            @NotNull
            protected List<String> getAttributes() {
                return ContainerUtil.list((Object[])new String[]{"#disabled", "#enabled", "#bundled", "#custom", "#inactive", "#invalid", "#outdated", "#uninstalled"});
            }

            @Override
            @Nullable
            protected List<String> getValues(@NotNull String attribute) {
                return null;
            }

            @Override
            protected void handleAppendToQuery() {
                this.showPopupForQuery();
            }

            @Override
            protected void handleAppendAttributeValue() {
                this.showPopupForQuery();
            }

            @Override
            protected void showPopupForQuery() {
                PluginManagerConfigurableNew.this.showSearchPanel(PluginManagerConfigurableNew.this.mySearchTextField.getText());
            }
        };
        this.myInstalledSearchPanel = new SearchResultPanel(installedController, this.createLocalSearchPanelComponent(false), 4, 1){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                InstalledPluginsState state = InstalledPluginsState.getInstance();
                SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query);
                for (UIPluginGroup uiGroup : PluginManagerConfigurableNew.this.myInstalledPanel.getGroups()) {
                    for (CellPluginComponent plugin : uiGroup.plugins) {
                        if (parser.attributes) {
                            if (parser.enabled != null && parser.enabled.booleanValue() != PluginManagerConfigurableNew.this.myPluginsModel.isEnabled(plugin.myPlugin) || parser.bundled != null && parser.bundled.booleanValue() != plugin.myPlugin.isBundled() || parser.invalid != null && parser.invalid.booleanValue() != PluginManagerConfigurableNew.this.myPluginsModel.hasErrors(plugin.myPlugin) || parser.deleted != null && (plugin.myPlugin instanceof IdeaPluginDescriptorImpl ? parser.deleted.booleanValue() != ((IdeaPluginDescriptorImpl)plugin.myPlugin).isDeleted() : parser.deleted != false)) continue;
                            PluginId pluginId = plugin.myPlugin.getPluginId();
                            if (parser.needUpdate != null && parser.needUpdate.booleanValue() != state.hasNewerVersion(pluginId) || parser.needRestart != null && parser.needRestart != (state.wasInstalled(pluginId) || state.wasUpdated(pluginId))) continue;
                        }
                        if (parser.searchQuery != null && !StringUtil.containsIgnoreCase((String)plugin.myPlugin.getName(), (String)parser.searchQuery)) continue;
                        result2.descriptors.add(plugin.myPlugin);
                    }
                }
            }
        };
        this.myUpdatesSearchPanel = new SearchResultPanel(null, this.createLocalSearchPanelComponent(true), 5, 2){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                for (UIPluginGroup uiGroup : PluginManagerConfigurableNew.this.myUpdatesPanel.getGroups()) {
                    for (CellPluginComponent plugin : uiGroup.plugins) {
                        if (!StringUtil.containsIgnoreCase((String)plugin.myPlugin.getName(), (String)query)) continue;
                        result2.descriptors.add(plugin.myPlugin);
                    }
                }
            }
        };
    }

    @NotNull
    private JComponent createDetailsPanel(@NotNull Pair<IdeaPluginDescriptor, Boolean> data) {
        this.myPluginsModel.detailPanel = new DetailsPagePluginComponent(this.myPluginsModel, this.myTagBuilder, this.mySearchListener, (IdeaPluginDescriptor)data.first, (Boolean)data.second);
        this.mySearchTextField.setVisible(false);
        return this.myPluginsModel.detailPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTrendingAndUpdatesPanels() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myAllRepositoriesList = null;
            this.myAllRepositoriesMap = null;
            this.myCustomRepositoriesMap = null;
        }
        this.mySuggestCache = null;
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myTrendingPanel == null && this.myUpdatesPanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            if (this.myUpdatesPanel != null) {
                this.myUpdatesPanel.setVisibleRunnable(this.myUpdatesRunnable);
            }
            this.myTrendingRunnable.run();
        } else if (selectionTab == 2) {
            if (this.myTrendingPanel != null) {
                this.myTrendingPanel.setVisibleRunnable(this.myTrendingRunnable);
            }
            this.myUpdatesRunnable.run();
        } else {
            if (this.myTrendingPanel != null) {
                this.myTrendingPanel.setVisibleRunnable(this.myTrendingRunnable);
            }
            if (this.myUpdatesPanel != null) {
                this.myUpdatesPanel.setVisibleRunnable(this.myUpdatesRunnable);
            }
        }
    }

    @NotNull
    private static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        JBScrollPane pane = new JBScrollPane((Component)((Object)panel2));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        return pane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Pair<Map<String, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> loadPluginRepositories() throws IOException {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myAllRepositoriesMap != null) {
                return Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
            }
        }
        ArrayList<IdeaPluginDescriptor> list2 = new ArrayList<IdeaPluginDescriptor>();
        HashMap<String, IdeaPluginDescriptor> map2 = new HashMap<String, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> custom = new HashMap<String, List<IdeaPluginDescriptor>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null);
                if (host != null) {
                    custom.put(host, descriptors);
                }
                for (IdeaPluginDescriptor plugin : descriptors) {
                    String id = plugin.getPluginId().getIdString();
                    if (map2.containsKey(id)) continue;
                    list2.add(plugin);
                    map2.put(id, plugin);
                }
            }
            catch (IOException e) {
                if (host == null) {
                    PluginManagerMain.LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                    continue;
                }
                PluginManagerMain.LOG.info(host, (Throwable)e);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            InstalledPluginsState state = InstalledPluginsState.getInstance();
            for (IdeaPluginDescriptor descriptor : list2) {
                state.onDescriptorDownload(descriptor);
            }
        });
        Object object2 = this.myRepositoriesLock;
        synchronized (object2) {
            if (this.myAllRepositoriesList == null) {
                this.myAllRepositoriesList = list2;
                this.myAllRepositoriesMap = map2;
                this.myCustomRepositoriesMap = custom;
            }
            return Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
        }
    }

    private void addGroup(@NotNull List<PluginsGroup> groups, @NotNull String name, @NotNull String showAllQuery, @NotNull ThrowableNotNullFunction<List<IdeaPluginDescriptor>, Boolean, IOException> function) throws IOException {
        PluginsGroup group = new PluginsGroup(name);
        if (Boolean.TRUE.equals(function.fun(group.descriptors))) {
            group.rightAction = new LinkLabel("Show All", null, this.mySearchListener, (Object)showAllQuery);
        }
        if (!group.descriptors.isEmpty()) {
            groups.add(group);
        }
    }

    private void addGroup(@NotNull List<PluginsGroup> groups, @NotNull Map<String, IdeaPluginDescriptor> allRepositoriesMap, @NotNull String name, @NotNull String query, @NotNull String showAllQuery) throws IOException {
        this.addGroup(groups, name, showAllQuery, (ThrowableNotNullFunction<List<IdeaPluginDescriptor>, Boolean, IOException>)((ThrowableNotNullFunction)descriptors -> PluginManagerConfigurableNew.loadPlugins(descriptors, allRepositoriesMap, query)));
    }

    private static boolean loadPlugins(@NotNull List<? super IdeaPluginDescriptor> descriptors, @NotNull Map<String, IdeaPluginDescriptor> allDescriptors, @NotNull String query) throws IOException {
        Url baseUrl;
        boolean forceHttps = PluginManagerConfigurableNew.forceHttps();
        Url offsetUrl = baseUrl = PluginManagerConfigurableNew.createSearchUrl(query, 9);
        HashMap<String, String> offsetParameters = new HashMap<String, String>();
        int offset = 0;
        List<String> pluginIds;
        while (!(pluginIds = PluginManagerConfigurableNew.requestToPluginRepository(offsetUrl, forceHttps)).isEmpty()) {
            for (String pluginId : pluginIds) {
                IdeaPluginDescriptor descriptor = allDescriptors.get(pluginId);
                if (descriptor == null) continue;
                descriptors.add((IdeaPluginDescriptor)descriptor);
                if (descriptors.size() != 9) continue;
                return true;
            }
            offsetParameters.put("offset", Integer.toString(offset += pluginIds.size()));
            offsetUrl = baseUrl.addParameters(offsetParameters);
        }
        return false;
    }

    @NotNull
    private static List<String> requestToPluginRepository(@NotNull Url url, boolean forceHttps) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        HttpRequests.request((Url)url).forceHttps(forceHttps).throwStatusCodeException(false).productNameAsUserAgent().connect(request -> {
            URLConnection connection = request.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose((Reader)request.getReader()));){
                if (json.peek() == JsonToken.BEGIN_OBJECT) {
                    json.beginObject();
                    json.nextName();
                    json.nextString();
                    json.nextName();
                }
                json.beginArray();
                while (json.hasNext()) {
                    ids.add(json.nextString());
                }
            }
            return null;
        });
        return ids;
    }

    @NotNull
    private static Url createSearchUrl(@NotNull String query, int count) {
        ApplicationInfoEx instance = ApplicationInfoImpl.getShadowInstance();
        return Urls.newFromEncoded(instance.getPluginManagerUrl() + "/api/search?" + query + "&build=" + URLUtil.encodeURIComponent((String)instance.getApiVersion()) + "&max=" + count);
    }

    @NotNull
    private static Url createSearchSuggestUrl(@NotNull String query) {
        ApplicationInfoEx instance = ApplicationInfoImpl.getShadowInstance();
        return Urls.newFromEncoded(instance.getPluginManagerUrl() + "/api/searchSuggest?term=" + URLUtil.encodeURIComponent((String)query) + "&productCode=" + URLUtil.encodeURIComponent((String)instance.getBuild().getProductCode()));
    }

    public static boolean forceHttps() {
        return IdeaApplication.isLoaded() && !ApplicationManager.getApplication().isDisposed() && UpdateSettings.getInstance().canUseSecureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<IdeaPluginDescriptor> getPluginRepositories() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myAllRepositoriesList != null) {
                return this.myAllRepositoriesList;
            }
        }
        try {
            List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadCachedPlugins();
            if (list2 != null) {
                return list2;
            }
        }
        catch (IOException e) {
            PluginManagerMain.LOG.info((Throwable)e);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String getErrorMessage(@NotNull InstalledPluginsTableModel pluginsModel, @NotNull PluginDescriptor pluginDescriptor, @NotNull Ref<? super Boolean> enableAction) {
        String message;
        Set<PluginId> requiredPlugins = pluginsModel.getRequiredPlugins(pluginDescriptor.getPluginId());
        if (ContainerUtil.isEmpty(requiredPlugins)) {
            message = "Incompatible with the current " + ApplicationNamesInfo.getInstance().getFullProductName() + " version.";
        } else if (requiredPlugins.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
            message = "The plugin requires IntelliJ IDEA Ultimate.";
        } else {
            String deps = StringUtil.join(requiredPlugins, id -> {
                IdeaPluginDescriptor plugin = PluginManager.getPlugin(id);
                if (plugin == null && PluginManagerCore.isModuleDependency(id)) {
                    for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                        if (!(descriptor instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor).getModules().contains(id.getIdString())) continue;
                        plugin = descriptor;
                        break;
                    }
                }
                return plugin != null ? plugin.getName() : id.getIdString();
            }, (String)", ");
            message = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{requiredPlugins.size(), deps});
            enableAction.set((Object)Boolean.TRUE);
        }
        return message;
    }

    @NotNull
    public static List<String> getTags(@NotNull IdeaPluginDescriptor plugin) {
        List<String> tags = null;
        if (plugin instanceof PluginNode) {
            tags = ((PluginNode)plugin).getTags();
        }
        if (ContainerUtil.isEmpty(tags)) {
            return Collections.emptyList();
        }
        int eap = tags.indexOf("EAP");
        if (eap > 0) {
            tags = new ArrayList<String>(tags);
            tags.remove(eap);
            tags.add(0, "EAP");
        }
        return tags;
    }

    @Nullable
    public static synchronized String getDownloads(@NotNull IdeaPluginDescriptor plugin) {
        String downloads = ((PluginNode)plugin).getDownloads();
        if (!StringUtil.isEmptyOrSpaces((String)downloads)) {
            try {
                Long value = Long.valueOf(downloads);
                if (value > 1000L) {
                    return value < 1000000L ? K_FORMAT.format((double)value.longValue() / 1000.0) : M_FORMAT.format((double)value.longValue() / 1000000.0);
                }
                return value.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static synchronized String getLastUpdatedDate(@NotNull IdeaPluginDescriptor plugin) {
        long date = ((PluginNode)plugin).getDate();
        return date > 0L && date != Long.MAX_VALUE ? DATE_FORMAT.format(new Date(date)) : null;
    }

    @Nullable
    public static String getRating(@NotNull IdeaPluginDescriptor plugin) {
        String rating = ((PluginNode)plugin).getRating();
        if (rating != null) {
            try {
                if (Double.valueOf(rating) > 0.0) {
                    return StringUtil.trimEnd((String)rating, (String)".0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void registerCopyProvider(final @NotNull PluginsGroupComponent component) {
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                StringBuilder result2 = new StringBuilder();
                for (CellPluginComponent pluginComponent : component.getSelection()) {
                    result2.append(pluginComponent.myPlugin.getName()).append(" (").append(pluginComponent.myPlugin.getVersion()).append(")\n");
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(result2.substring(0, result2.length() - 1)));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                return !component.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                return true;
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    public static int getParentWidth(@NotNull Container parent) {
        int width = parent.getWidth();
        if (width > 0) {
            Container container = parent.getParent();
            int parentWidth = container.getWidth();
            if (container instanceof JViewport && parentWidth < width) {
                width = parentWidth;
            }
        }
        return width;
    }

    @NotNull
    public static <T extends Component> T installTiny(@NotNull T component) {
        return (T)(SystemInfo.isMac ? RelativeFont.TINY.install(component) : component);
    }

    public static int offset5() {
        return JBUI.scale((int)5);
    }

    public static boolean isJBPlugin(@NotNull IdeaPluginDescriptor plugin) {
        return plugin.isBundled() || PluginManagerMain.isDevelopedByJetBrains(plugin);
    }

    @Nullable
    public static String getShortDescription(@NotNull IdeaPluginDescriptor plugin, boolean shortSize) {
        return PluginSiteUtils.preparePluginDescription(plugin.getDescription(), shortSize);
    }

    @NotNull
    private PluginsGroupComponent createLocalSearchPanelComponent(boolean pluginForUpdate) {
        PluginsGroupComponent component = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, pluginForUpdate)));
        PluginManagerConfigurableNew.registerCopyProvider(component);
        return component;
    }

    @NotNull
    private PluginsGroupComponent createSearchPanelComponentWithProgress() {
        return new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsGridLayout()), new ScrollEventHandler(), this.myNameListener, this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor -> new GridCellPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor, this.myTagBuilder)));
    }

    private static class CountTabName
    implements Computable<String> {
        private final TabHeaderComponent myTabComponent;
        private final String myBaseName;
        private int myCount = -1;

        CountTabName(@NotNull TabHeaderComponent component, @NotNull String baseName) {
            this.myTabComponent = component;
            this.myBaseName = baseName;
        }

        public void setCount(int count) {
            if (this.myCount != count) {
                this.myCount = count;
                this.myTabComponent.update();
            }
        }

        public String compute() {
            return this.myCount == -1 ? this.myBaseName : this.myBaseName + " (" + this.myCount + ")";
        }
    }
}

