/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurableProxy
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    private final SearchableConfigurable myConfigurable = Registry.is((String)"show.new.plugin.page", (boolean)false) ? new PluginManagerConfigurableNew() : new PluginManagerConfigurable(PluginManagerUISettings.getInstance());

    @NotNull
    public String getId() {
        return this.myConfigurable.getId();
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.myConfigurable.enableSearch(option2);
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return this.myConfigurable.getDisplayName();
    }

    @Nullable
    public String getHelpTopic() {
        return this.myConfigurable.getHelpTopic();
    }

    public boolean isModified(@NotNull JTextField textField2, @NotNull String value) {
        return this.myConfigurable.isModified(textField2, value);
    }

    public boolean isModified(@NotNull JTextField textField2, int value, @NotNull UINumericRange range2) {
        return this.myConfigurable.isModified(textField2, value, range2);
    }

    public boolean isModified(@NotNull JToggleButton toggleButton, boolean value) {
        return this.myConfigurable.isModified(toggleButton, value);
    }

    public <T> boolean isModified(@NotNull ComboBox<T> comboBox2, T value) {
        return this.myConfigurable.isModified(comboBox2, value);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myConfigurable.getPreferredFocusedComponent();
    }

    public boolean isAvailable() {
        return this.myConfigurable instanceof Configurable.TopComponentProvider;
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        return ((Configurable.TopComponentProvider)this.myConfigurable).getCenterComponent(controller);
    }

    @Nullable
    public JComponent createComponent() {
        JComponent component = this.myConfigurable.createComponent();
        if (component != null && this.myConfigurable instanceof PluginManagerConfigurable) {
            if (!component.getClass().equals(JPanel.class)) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add("Center", component);
                component = panel2;
            }
            component.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
        }
        return component;
    }

    public boolean isModified() {
        return this.myConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        if (this.myConfigurable instanceof PluginManagerConfigurableNew) {
            ((PluginManagerConfigurableNew)this.myConfigurable).select(descriptors);
        } else {
            ((PluginManagerConfigurable)this.myConfigurable).select(descriptors);
        }
    }

    public void enable(IdeaPluginDescriptor ... descriptors) {
        if (this.myConfigurable instanceof PluginManagerConfigurableNew) {
            ((PluginManagerConfigurableNew)this.myConfigurable).getPluginsModel().changeEnableDisable(descriptors, true);
        } else {
            ((InstalledPluginsTableModel)((PluginManagerConfigurable)this.myConfigurable).getOrCreatePanel().getPluginsModel()).enableRows(descriptors, Boolean.TRUE);
        }
    }

    public static void showPluginConfigurableAndEnable(@Nullable Project project, IdeaPluginDescriptor ... descriptors) {
        PluginManagerConfigurableProxy configurable = new PluginManagerConfigurableProxy();
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            configurable.enable(descriptors);
            configurable.select(descriptors);
        });
    }

    public static void showPluginConfigurable(@Nullable Component parent, @Nullable Project project, IdeaPluginDescriptor ... descriptors) {
        PluginManagerConfigurableProxy configurable = new PluginManagerConfigurableProxy();
        Runnable init = () -> configurable.select(descriptors);
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        if (parent != null) {
            util.editConfigurable(parent, (Configurable)configurable, init);
        } else {
            util.editConfigurable(project, (Configurable)configurable, init);
        }
    }
}

