/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurableTreeRenderer
extends AncestorListenerAdapter
implements ConfigurableTreeRenderer,
Consumer<Integer> {
    private final CountComponent myCountLabel = new CountComponent();
    private PluginUpdatesService myService;
    private SimpleTree myTree;
    private String myCountValue;

    @Nullable
    public Pair<Component, ConfigurableTreeRenderer.Layout> getDecorator(@NotNull SimpleTree tree, @Nullable UnnamedConfigurable configurable, boolean selected) {
        if (!Registry.is((String)"show.new.plugin.page", (boolean)false)) {
            return null;
        }
        if (this.myTree == null) {
            this.myService = PluginUpdatesService.connectTreeRenderer(this);
            tree.addAncestorListener((AncestorListener)((Object)this));
            this.myTree = tree;
        }
        if (this.myCountValue != null) {
            this.myCountLabel.setText(this.myCountValue);
            this.myCountLabel.setSelected(selected);
            return Pair.create((Object)this.myCountLabel, (renderer2, bounds2, text, right, textBaseline) -> {
                Dimension size = renderer2.getPreferredSize();
                int x = right.x - JBUI.scale((int)2) + (right.width - size.width) / 2;
                int y = bounds2.y + textBaseline - renderer2.getBaseline(size.width, size.height);
                renderer2.setBounds(x, y, size.width, size.height);
            });
        }
        return null;
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.myService.dispose();
    }

    @Override
    public void accept(Integer countValue) {
        String oldCountValue = this.myCountValue;
        String string = this.myCountValue = countValue == null || countValue <= 0 ? null : countValue.toString();
        if (this.myTree != null && !StringUtil.equals((CharSequence)oldCountValue, (CharSequence)this.myCountValue)) {
            this.myTree.repaint();
        }
    }

    private static class CountComponent
    extends JLabel {
        private final Color myOvalColor = JBColor.namedColor((String)"Counter.background", (Color)new Color(-862279760, true));

        private CountComponent() {
            this.setBorder(null);
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)(SystemInfo.isMac || SystemInfo.isLinux && (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) ? UIUtil.FontSize.SMALL : UIUtil.FontSize.NORMAL)));
            this.setForeground((Color)JBColor.namedColor((String)"Counter.foreground", (Color)new JBColor(0xFFFFFF, 4080461)));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
        }

        public void setSelected(boolean selected) {
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)true) : UIUtil.SIDE_PANEL_BACKGROUND);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(size.width, this.getTextOffset() + this.getOvalWidth()), Math.max(size.height, CountComponent.getOvalHeight()));
        }

        @Override
        protected void paintComponent(Graphics g) {
            int corner = JBUI.scale((int)14);
            int ovalWidth = this.getOvalWidth();
            int ovalHeight = CountComponent.getOvalHeight();
            int width = this.getWidth();
            int height = this.getHeight();
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            g.setColor(this.myOvalColor);
            g.fillRoundRect(this.getTextOffset() + (width - ovalWidth) / 2, (height - ovalHeight) / 2, ovalWidth, ovalHeight, corner, corner);
            config2.restore();
            super.paintComponent(g);
        }

        private int getOvalWidth() {
            return JBUI.scale((int)(this.getText().length() == 1 ? 16 : 20));
        }

        private int getTextOffset() {
            String text = this.getText();
            return text.equals("1") || text.equals("3") || text.equals("4") ? 1 : 0;
        }

        private static int getOvalHeight() {
            return JBUI.scale((int)14);
        }
    }
}

