/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.util.ThreeState;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.JDOMXIncluder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PluginXmlPathResolver
implements JDOMXIncluder.PathResolver {
    private final File[] myPluginJarFiles;

    PluginXmlPathResolver(@NotNull File[] jarFiles) {
        this.myPluginJarFiles = jarFiles;
    }

    @NotNull
    public URL resolvePath(@NotNull String relativePath, @Nullable URL base) throws MalformedURLException {
        URL url = JDOMXIncluder.DEFAULT_PATH_RESOLVER.resolvePath(relativePath, base);
        if (URLUtil.resourceExists((URL)url) == ThreeState.NO) {
            for (File jarFile : this.myPluginJarFiles) {
                try {
                    URL entryURL = URLUtil.getJarEntryURL((File)jarFile, (String)relativePath);
                    if (URLUtil.resourceExists((URL)entryURL) == ThreeState.YES) {
                        return entryURL;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return url;
    }
}

