/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String TAG_EXT = ".etag";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList hosts = ContainerUtil.newArrayList(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        return hosts;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) throws IOException {
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        HashSet<String> addedPluginIds = new HashSet<String>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, indicator);
            for (IdeaPluginDescriptor plugin : plugins2) {
                if (!addedPluginIds.add(plugin.getPluginId().getIdString())) continue;
                result2.add(plugin);
            }
        }
        return result2;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(repositoryUrl, null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, @Nullable ProgressIndicator indicator) throws IOException {
        boolean hostEligibleForHttpsForcing = repositoryUrl == null || repositoryUrl.equals(ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        boolean forceHttps = hostEligibleForHttpsForcing && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        return RepositoryHelper.loadPlugins(repositoryUrl, buildnumber, forceHttps, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, boolean forceHttps, @Nullable ProgressIndicator indicator) throws IOException {
        String eTag;
        File pluginListFile;
        Url url;
        if (repositoryUrl == null) {
            url = Urls.newFromEncoded(ApplicationInfoImpl.getShadowInstance().getPluginsListUrl());
            url = url.addParameters(Collections.singletonMap("uuid", PermanentInstallationID.get()));
            pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
            eTag = RepositoryHelper.loadPluginListETag(pluginListFile);
        } else {
            url = Urls.newFromEncoded(repositoryUrl);
            pluginListFile = null;
            eTag = "";
        }
        if (!"file".equals(url.getScheme())) {
            url = url.addParameters(Collections.singletonMap("build", build2 != null ? build2.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion()));
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{url.getAuthority()}));
        }
        Url finalUrl = url;
        List descriptors = (List)HttpRequests.request((Url)url).forceHttps(forceHttps).tuner(connection -> connection.setRequestProperty("If-None-Match", eTag)).productNameAsUserAgent().connect(request -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            URLConnection connection = request.getConnection();
            if (pluginListFile != null && pluginListFile.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                LOG.info("using cached plugin list (updated at " + DateFormatUtil.formatDateTime((long)pluginListFile.lastModified()) + ")");
                return RepositoryHelper.loadPluginList(pluginListFile);
            }
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{finalUrl.getAuthority()}));
            }
            if (pluginListFile != null) {
                String string = PLUGIN_LIST_FILE;
                synchronized (PLUGIN_LIST_FILE) {
                    FileUtil.ensureExists((File)pluginListFile.getParentFile());
                    request.saveToFile(pluginListFile, indicator);
                    RepositoryHelper.savePluginListETag(pluginListFile, connection.getHeaderField("ETag"));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
            }
            try (BufferedReader reader = request.getReader();){
                List<IdeaPluginDescriptor> list2 = RepositoryHelper.parsePluginList(reader);
                return list2;
            }
        });
        return RepositoryHelper.process(repositoryUrl, descriptors);
    }

    private static String loadPluginListETag(File pluginListFile) {
        File file2 = RepositoryHelper.getPluginListETagFile(pluginListFile);
        if (file2.length() > 0L) {
            try {
                List lines2 = FileUtil.loadLines((File)file2);
                if (lines2.size() == 1) {
                    return (String)lines2.get(0);
                }
                LOG.warn("Can't load plugin list ETag from '" + file2.getAbsolutePath() + "'. Unexpected number of lines: " + lines2.size());
                FileUtil.delete((File)file2);
            }
            catch (IOException e) {
                LOG.warn("Can't load plugin list ETag from '" + file2.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        return "";
    }

    private static void savePluginListETag(File pluginListFile, String eTag) {
        if (eTag != null) {
            File file2 = RepositoryHelper.getPluginListETagFile(pluginListFile);
            try {
                FileUtil.writeToFile((File)file2, (String)eTag);
            }
            catch (IOException e) {
                LOG.warn("Can't save plugin list ETag to '" + file2.getAbsolutePath() + "'", (Throwable)e);
            }
        }
    }

    private static File getPluginListETagFile(File pluginListFile) {
        return new File(pluginListFile.getParentFile(), pluginListFile.getName() + TAG_EXT);
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() > 0L ? RepositoryHelper.loadPluginList(file2) : null;
    }

    private static List<IdeaPluginDescriptor> loadPluginList(File file2) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file2)), CharsetToolkit.UTF8_CHARSET);){
            List<IdeaPluginDescriptor> list2 = RepositoryHelper.parsePluginList(reader);
            return list2;
        }
    }

    private static List<IdeaPluginDescriptor> parsePluginList(Reader reader) throws IOException {
        List<IdeaPluginDescriptor> rawList;
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler2 = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler2);
            rawList = handler2.getPluginsList();
        }
        catch (RuntimeException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        return RepositoryHelper.getLatestCompatibleForEveryPlugin(rawList);
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getLatestCompatibleForEveryPlugin(@NotNull List<IdeaPluginDescriptor> rawList) {
        LinkedHashMap<PluginId, IdeaPluginDescriptor> filteredPlugins = new LinkedHashMap<PluginId, IdeaPluginDescriptor>(rawList.size());
        for (IdeaPluginDescriptor descriptor : rawList) {
            if (PluginManagerCore.isIncompatible(descriptor)) continue;
            PluginId pluginId = descriptor.getPluginId();
            IdeaPluginDescriptor filteredPluginDescriptor = (IdeaPluginDescriptor)filteredPlugins.get(pluginId);
            if (filteredPluginDescriptor == null) {
                filteredPlugins.put(pluginId, descriptor);
                continue;
            }
            if (VersionComparatorUtil.compare((String)descriptor.getVersion(), (String)filteredPluginDescriptor.getVersion()) <= 0) continue;
            filteredPlugins.put(pluginId, descriptor);
        }
        return new ArrayList<IdeaPluginDescriptor>(filteredPlugins.values());
    }

    private static List<IdeaPluginDescriptor> process(String repositoryUrl, List<IdeaPluginDescriptor> list2) {
        Iterator<IdeaPluginDescriptor> i = list2.iterator();
        while (i.hasNext()) {
            PluginNode node = (PluginNode)i.next();
            if (node.getPluginId() == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.warn("Malformed plugin record (id:" + node.getPluginId() + " repository:" + repositoryUrl + ")");
                i.remove();
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() != null) continue;
            String url = node.getDownloadUrl();
            String name = FileUtil.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1));
            node.setName(name);
        }
        return list2;
    }
}

