/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class BaselinePanel
extends NonOpaquePanel {
    private Component myBaseComponent;
    private final List<Component> myVersionComponents = new ArrayList<Component>();
    private final List<Component> myButtonComponents = new ArrayList<Component>();
    private Component myProgressComponent;
    private final JBValue myOffset = new JBValue.Float(8.0f);
    private final JBValue myBeforeButtonOffset = new JBValue.Float(40.0f);
    private final JBValue myButtonOffset = new JBValue.Float(6.0f);
    private JLabel myErrorComponent;
    private Component myErrorEnableComponent;
    private EventHandler myEventHandler;

    public BaselinePanel() {
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)6, (int)0));
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int width = baseSize.width;
                if (BaselinePanel.this.myProgressComponent == null) {
                    int size;
                    Component component;
                    Iterator iterator = BaselinePanel.this.myVersionComponents.iterator();
                    while (iterator.hasNext() && (component = (Component)iterator.next()).isVisible()) {
                        width += BaselinePanel.this.myOffset.get() + component.getPreferredSize().width;
                    }
                    if (BaselinePanel.this.myErrorComponent != null) {
                        width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorComponent.getPreferredSize().width;
                        if (BaselinePanel.this.myErrorEnableComponent != null) {
                            width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                        }
                    }
                    if ((size = BaselinePanel.this.myButtonComponents.size()) > 0) {
                        width += BaselinePanel.this.myBeforeButtonOffset.get();
                        width += (size - 1) * BaselinePanel.this.myButtonOffset.get();
                        for (Component component2 : BaselinePanel.this.myButtonComponents) {
                            width += component2.getPreferredSize().width;
                        }
                    }
                } else {
                    width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myProgressComponent.getPreferredSize().width;
                }
                Insets insets = parent.getInsets();
                return new Dimension(width, insets.top + baseSize.height + insets.bottom);
            }

            private int calculateBaseWidth(@NotNull Container parent) {
                int parentWidth = parent.getWidth();
                if (BaselinePanel.this.myProgressComponent != null) {
                    return parentWidth - ((BaselinePanel)BaselinePanel.this).myProgressComponent.getPreferredSize().width - BaselinePanel.this.myOffset.get();
                }
                if (!BaselinePanel.this.myVersionComponents.isEmpty() && ((Component)BaselinePanel.this.myVersionComponents.get(0)).isVisible()) {
                    for (Component component : BaselinePanel.this.myVersionComponents) {
                        parentWidth -= component.getPreferredSize().width;
                    }
                    parentWidth -= BaselinePanel.this.myOffset.get() * BaselinePanel.this.myVersionComponents.size();
                }
                for (Component component : BaselinePanel.this.myButtonComponents) {
                    parentWidth -= component.getPreferredSize().width;
                }
                parentWidth -= BaselinePanel.this.myButtonOffset.get() * (BaselinePanel.this.myButtonComponents.size() - 1);
                if (BaselinePanel.this.myErrorComponent != null) {
                    int errorPartWidth;
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        parentWidth -= BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                    }
                    if (((BaselinePanel)BaselinePanel.this).myBaseComponent.getPreferredSize().width >= parentWidth - (errorPartWidth = ((BaselinePanel)BaselinePanel.this).myErrorComponent.getPreferredSize().width / 3)) {
                        parentWidth -= errorPartWidth;
                    }
                }
                return parentWidth;
            }

            public void layoutContainer(Container parent) {
                Dimension size;
                Component component;
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int top = parent.getInsets().top;
                int y = top + BaselinePanel.this.myBaseComponent.getBaseline(baseSize.width, baseSize.height);
                int x = 0;
                int calcBaseWidth = this.calculateBaseWidth(parent);
                JLabel label2 = (JLabel)BaselinePanel.this.myBaseComponent;
                label2.setToolTipText(calcBaseWidth < baseSize.width ? label2.getText() : null);
                baseSize.width = Math.min(baseSize.width, calcBaseWidth);
                BaselinePanel.this.myBaseComponent.setBounds(x, top, baseSize.width, baseSize.height);
                x += baseSize.width;
                if (BaselinePanel.this.myProgressComponent != null) {
                    Dimension size2 = BaselinePanel.this.myProgressComponent.getPreferredSize();
                    this.setBaselineBounds(parent.getWidth() - size2.width, y, BaselinePanel.this.myProgressComponent, size2);
                    return;
                }
                Iterator size2 = BaselinePanel.this.myVersionComponents.iterator();
                while (size2.hasNext() && (component = (Component)size2.next()).isVisible()) {
                    size = component.getPreferredSize();
                    this.setBaselineBounds(x += BaselinePanel.this.myOffset.get(), y, component, size);
                    x += size.width;
                }
                int lastX = parent.getWidth();
                for (int i = BaselinePanel.this.myButtonComponents.size() - 1; i >= 0; --i) {
                    Component component2 = (Component)BaselinePanel.this.myButtonComponents.get(i);
                    Dimension size3 = component2.getPreferredSize();
                    this.setBaselineBounds(lastX -= size3.width, y, component2, size3);
                    lastX -= BaselinePanel.this.myButtonOffset.get();
                }
                if (BaselinePanel.this.myErrorComponent != null) {
                    x += BaselinePanel.this.myOffset.get();
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        if (!BaselinePanel.this.myButtonComponents.isEmpty()) {
                            lastX -= BaselinePanel.this.myBeforeButtonOffset.get();
                        }
                        lastX -= ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                        lastX -= BaselinePanel.this.myOffset.get();
                    }
                    int errorWidth = lastX - x;
                    size = BaselinePanel.this.myErrorComponent.getPreferredSize();
                    if (errorWidth >= size.width) {
                        this.setBaselineBounds(x, y, BaselinePanel.this.myErrorComponent, size);
                        BaselinePanel.this.myErrorComponent.setToolTipText(null);
                        x += size.width;
                    } else {
                        this.setBaselineBounds(x, y, BaselinePanel.this.myErrorComponent, size, errorWidth, size.height);
                        BaselinePanel.this.myErrorComponent.setToolTipText(BaselinePanel.this.myErrorComponent.getText());
                        x += errorWidth;
                    }
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        this.setBaselineBounds(x += BaselinePanel.this.myOffset.get(), y, BaselinePanel.this.myErrorEnableComponent, BaselinePanel.this.myErrorEnableComponent.getPreferredSize());
                    }
                }
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension size) {
                this.setBaselineBounds(x, y, component, size, size.width, size.height);
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension prefSize, int width, int height) {
                component.setBounds(x, y - component.getBaseline(prefSize.width, prefSize.height), width, height);
            }
        });
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        this.myEventHandler = eventHandler;
    }

    public Component add(Component component) {
        assert (this.myBaseComponent == null);
        this.myBaseComponent = component;
        return super.add(component);
    }

    public void addVersionComponent(@NotNull JComponent component) {
        this.myVersionComponents.add(component);
        this.add(component, null);
    }

    public void addErrorComponents(@NotNull String message, boolean enableAction, @NotNull Runnable enableCallback) {
        if (this.myErrorComponent == null) {
            this.myErrorComponent = new JLabel();
            this.myErrorComponent.setForeground(DialogWrapper.ERROR_FOREGROUND_COLOR);
            this.myErrorComponent.setOpaque(false);
            this.add(this.myErrorComponent, null);
            if (this.myEventHandler != null) {
                this.myEventHandler.add(this.myErrorComponent);
            }
        }
        this.myErrorComponent.setText(message);
        if (enableAction) {
            if (this.myErrorEnableComponent == null) {
                LinkLabel errorAction = new LinkLabel("Enable", null);
                errorAction.setOpaque(false);
                errorAction.setListener((aSource, aLinkData) -> enableCallback.run(), null);
                this.myErrorEnableComponent = errorAction;
                this.add(this.myErrorEnableComponent, null);
                if (this.myEventHandler != null) {
                    this.myEventHandler.add((Component)errorAction);
                }
            }
        } else if (this.myErrorEnableComponent != null) {
            this.remove(this.myErrorEnableComponent);
            this.myErrorEnableComponent = null;
        }
        for (Component component : this.myVersionComponents) {
            component.setVisible(false);
        }
        this.doLayout();
    }

    public void removeErrorComponents() {
        if (this.myErrorComponent != null) {
            this.remove(this.myErrorComponent);
            this.myErrorComponent = null;
            if (this.myErrorEnableComponent != null) {
                this.remove(this.myErrorEnableComponent);
                this.myErrorEnableComponent = null;
            }
            for (Component component : this.myVersionComponents) {
                component.setVisible(true);
            }
            this.doLayout();
        }
    }

    public void addButtonComponent(@NotNull JComponent component) {
        this.myButtonComponents.add(component);
        this.add(component, null);
    }

    public void removeButtonComponent(@NotNull JComponent component) {
        this.myButtonComponents.remove(component);
        this.remove(component);
    }

    public void setProgressComponent(@NotNull CellPluginComponent pluginComponent, @NotNull JComponent progressComponent) {
        assert (this.myProgressComponent == null);
        this.myProgressComponent = progressComponent;
        this.add(progressComponent, null);
        if (this.myEventHandler != null) {
            this.myEventHandler.addAll(progressComponent);
            this.myEventHandler.updateHover(pluginComponent);
        }
        this.setVisibleOther(false);
        this.doLayout();
    }

    public void removeProgressComponent() {
        assert (this.myProgressComponent != null);
        this.remove(this.myProgressComponent);
        this.myProgressComponent = null;
        this.setVisibleOther(true);
        this.doLayout();
    }

    private void setVisibleOther(boolean value) {
        for (Component component : this.myVersionComponents) {
            component.setVisible(value);
        }
        if (this.myErrorComponent != null) {
            this.myErrorComponent.setVisible(value);
        }
        if (this.myErrorEnableComponent != null) {
            this.myErrorEnableComponent.setVisible(value);
        }
        for (Component component : this.myButtonComponents) {
            component.setVisible(value);
        }
    }
}

