/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.EmptyCaret;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.LineFunction;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.EditorKit;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CellPluginComponent
extends JPanel {
    public static final Color GRAY_COLOR = JBColor.namedColor((String)"Label.infoForeground", (Color)new JBColor((Color)Gray._120, (Color)Gray._135));
    private static final Color HOVER_COLOR = JBColor.namedColor((String)"Plugins.lightSelectionBackground", (Color)new JBColor(0xF5F9FF, 3553595));
    public final IdeaPluginDescriptor myPlugin;
    protected LinkLabel myIconLabel;
    protected LinkLabel myName;
    protected JEditorPane myDescription;
    protected MouseListener myHoverNameListener;
    protected EventHandler.SelectionType mySelection = EventHandler.SelectionType.NONE;

    protected CellPluginComponent(@NotNull IdeaPluginDescriptor plugin) {
        this.myPlugin = plugin;
    }

    @NotNull
    public IdeaPluginDescriptor getPluginDescriptor() {
        return this.myPlugin;
    }

    protected void addIconComponent(@NotNull JPanel parent, @Nullable Object constraints) {
        this.myIconLabel = new LinkLabel(null, AllIcons.Plugins.PluginLogo_40);
        this.myIconLabel.setVerticalAlignment(1);
        this.myIconLabel.setOpaque(false);
        parent.add((Component)this.myIconLabel, constraints);
    }

    protected void addNameComponent(@NotNull JPanel parent) {
        this.myName = new LinkComponent(){

            public String getToolTipText() {
                return this.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
        };
        this.myName.setText(this.myPlugin.getName());
        this.myName.setToolTipText(this.myPlugin.getName());
        parent.add(RelativeFont.BOLD.install((Component)this.myName));
    }

    protected void updateIcon(boolean errors, boolean disabled) {
        this.myIconLabel.setIcon(PluginLogo.getIcon(this.myPlugin, false, PluginManagerConfigurableNew.isJBPlugin(this.myPlugin), errors, disabled));
    }

    protected void addDescriptionComponent(@NotNull JPanel parent, @Nullable String description, final @NotNull LineFunction function) {
        if (StringUtil.isEmptyOrSpaces((String)description)) {
            return;
        }
        this.myDescription = new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Integer property;
                if (this.getWidth() == 0 || this.getHeight() == 0) {
                    this.setSize((Dimension)new JBDimension(180, 20));
                }
                int width = (property = (Integer)this.getClientProperty("parent.width")) == null ? JBUI.scale((int)180) : property;
                View view = this.getUI().getRootView(this);
                view.setSize(width, 2.1474836E9f);
                return new Dimension(width, function.getHeight(this));
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                function.paintComponent(this, g);
            }
        };
        PluginManagerConfigurableNew.installTiny(this.myDescription);
        this.myDescription.setEditable(false);
        this.myDescription.setFocusable(false);
        this.myDescription.setOpaque(false);
        this.myDescription.setBorder(null);
        this.myDescription.setCaret(EmptyCaret.INSTANCE);
        this.myDescription.setEditorKit((EditorKit)new UIUtil.JBWordWrapHtmlEditorKit());
        this.myDescription.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
        parent.add(this.myDescription);
    }

    @NotNull
    public EventHandler.SelectionType getSelection() {
        return this.mySelection;
    }

    public void setSelection(@NotNull EventHandler.SelectionType type) {
        this.setSelection(type, type == EventHandler.SelectionType.SELECTION);
    }

    public void setSelection(@NotNull EventHandler.SelectionType type, boolean scrollAndFocus) {
        this.mySelection = type;
        if (scrollAndFocus) {
            this.scrollToVisible();
            if (this.getParent() != null && type == EventHandler.SelectionType.SELECTION) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
            }
        }
        this.updateColors(type);
        this.repaint();
    }

    public void scrollToVisible() {
        JComponent parent = (JComponent)this.getParent();
        if (parent == null) {
            return;
        }
        Rectangle bounds2 = this.getBounds();
        if (!parent.getVisibleRect().contains(bounds2)) {
            parent.scrollRectToVisible(bounds2);
        }
    }

    protected void updateColors(@NotNull EventHandler.SelectionType type) {
        this.updateColors(GRAY_COLOR, type == EventHandler.SelectionType.NONE ? PluginManagerConfigurableNew.MAIN_BG_COLOR : HOVER_COLOR);
    }

    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        this.setBackground(background);
        if (this.myDescription != null) {
            this.myDescription.setForeground(grayedFg);
        }
    }

    protected void fullRepaint() {
        Container parent = this.getParent();
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    public void setListeners(@NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
        this.myIconLabel.setListener(listener2, (Object)this.myPlugin);
        this.myName.setListener(listener2, (Object)this.myPlugin);
        this.myHoverNameListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                CellPluginComponent.this.myName.entered(event);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                CellPluginComponent.this.myName.exited(event);
            }
        };
        this.myIconLabel.addMouseListener(this.myHoverNameListener);
        eventHandler.addAll(this);
    }

    public void createPopupMenu(@NotNull DefaultActionGroup group, @NotNull List<CellPluginComponent> selection) {
    }

    public void handleKeyAction(int keyCode, @NotNull List<CellPluginComponent> selection) {
    }

    public void close() {
    }
}

