/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EventHandler {
    public static final int DELETE_CODE = SystemInfo.isMac ? 8 : 127;

    public void connect(@NotNull PluginsGroupComponent container) {
    }

    public void addCell(@NotNull CellPluginComponent component, int index) {
    }

    public void addCell(@NotNull CellPluginComponent component, @Nullable CellPluginComponent anchor2) {
    }

    public void removeCell(@NotNull CellPluginComponent component) {
    }

    public void add(@NotNull Component component) {
    }

    public void addAll(@NotNull Component component) {
        this.add(component);
        for (Component child2 : UIUtil.uiChildren((Component)component)) {
            this.addAll(child2);
        }
    }

    public void updateHover(@NotNull CellPluginComponent component) {
    }

    public void initialSelection(boolean scrollAndFocus) {
    }

    @NotNull
    public List<CellPluginComponent> getSelection() {
        return Collections.emptyList();
    }

    public void setSelection(@NotNull CellPluginComponent component) {
        this.setSelection(component, true);
    }

    public void setSelection(@NotNull CellPluginComponent component, boolean scrollAndFocus) {
    }

    public void setSelection(@NotNull List<CellPluginComponent> components) {
    }

    public void clear() {
    }

    @Nullable
    public static ShortcutSet getShortcuts(@NotNull String id) {
        AnAction action = ActionManager.getInstance().getAction(id);
        return action == null ? null : action.getShortcutSet();
    }

    public static boolean check(@NotNull KeyboardShortcut shortcut, @Nullable ShortcutSet set2) {
        if (set2 != null) {
            for (Shortcut test : set2.getShortcuts()) {
                if (!test.isKeyboard() || !shortcut.startsWith(test)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected static CellPluginComponent get(@NotNull ComponentEvent event) {
        return (CellPluginComponent)UIUtil.getParentOfType(CellPluginComponent.class, (Component)event.getComponent());
    }

    @Nullable
    public static Runnable addGlobalAction(final @NotNull JComponent component, @NotNull Object actionInfo, final @NotNull Runnable callback2) {
        MyAnAction localAction = new MyAnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (component.isShowing()) {
                    callback2.run();
                }
            }
        };
        if (actionInfo instanceof String) {
            AnAction action = ActionManager.getInstance().getAction((String)actionInfo);
            if (action == null) {
                return null;
            }
            localAction.copyShortcutFrom(action);
        } else if (actionInfo instanceof ShortcutSet) {
            localAction.setShortcutSet((ShortcutSet)actionInfo);
        } else {
            return null;
        }
        localAction.registerCustomShortcutSet(component.getRootPane(), null);
        return () -> localAction.unregisterCustomShortcutSet(component.getRootPane());
    }

    private static abstract class MyAnAction
    extends AnAction {
        private MyAnAction() {
        }

        public void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
            super.setShortcutSet(shortcutSet);
        }
    }

    public static enum SelectionType {
        SELECTION,
        HOVER,
        NONE;

    }
}

