/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LineFunction;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.TagBuilder;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.TwoLineProgressIndicator;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class GridCellPluginComponent
extends CellPluginComponent {
    private final MyPluginModel myPluginModel;
    private JLabel myLastUpdated;
    private JLabel myDownloads;
    private JLabel myRating;
    private final JButton myInstallButton = new InstallButton(false);
    private JComponent myLastComponent;
    private List<TagComponent> myTagComponents;
    private ProgressIndicatorEx myIndicator;

    public GridCellPluginComponent(@NotNull MyPluginModel pluginsModel, @NotNull IdeaPluginDescriptor plugin, @NotNull TagBuilder tagBuilder) {
        super(plugin);
        this.myPluginModel = pluginsModel;
        pluginsModel.addComponent(this);
        NonOpaquePanel container = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
        this.add((Component)container);
        this.addIconComponent((JPanel)container, "West");
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5(), JBUI.scale((int)181))));
        container.add((Component)centerPanel);
        this.addNameComponent((JPanel)centerPanel);
        this.addTags((JPanel)centerPanel, tagBuilder);
        this.addDescriptionComponent((JPanel)centerPanel, PluginManagerConfigurableNew.getShortDescription(this.myPlugin, false), new LineFunction(3, true));
        this.createMetricsPanel((JPanel)centerPanel);
        this.addInstallButton();
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)new AbstractLayoutManager((JPanel)container, (JPanel)centerPanel){
            final /* synthetic */ JPanel val$container;
            final /* synthetic */ JPanel val$centerPanel;
            {
                this.val$container = jPanel;
                this.val$centerPanel = jPanel2;
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension size = this.val$container.getPreferredSize();
                size.height += PluginManagerConfigurableNew.offset5();
                size.height += ((GridCellPluginComponent)GridCellPluginComponent.this).myLastComponent.getPreferredSize().height;
                JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                return size;
            }

            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                Dimension size = this.val$container.getPreferredSize();
                Rectangle bounds2 = new Rectangle(insets.left, insets.top, size.width, size.height);
                this.val$container.setBounds(bounds2);
                this.val$container.doLayout();
                Point location = this.val$centerPanel.getLocation();
                Dimension buttonSize = GridCellPluginComponent.this.myLastComponent.getPreferredSize();
                Border border = GridCellPluginComponent.this.myLastComponent.getBorder();
                int borderOffset = border == null ? 0 : border.getBorderInsets((Component)((GridCellPluginComponent)GridCellPluginComponent.this).myLastComponent).left;
                GridCellPluginComponent.this.myLastComponent.setBounds(bounds2.x + location.x - borderOffset, bounds2.y + PluginManagerConfigurableNew.offset5() + bounds2.height, Math.min(buttonSize.width, size.width), buttonSize.height);
            }
        });
        this.updateIcon(false, false);
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    private void createMetricsPanel(@NotNull JPanel centerPanel) {
        if (!(this.myPlugin instanceof PluginNode)) {
            return;
        }
        String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
        String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin);
        String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
        if (downloads != null || date != null || rating != null) {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)7))));
            centerPanel.add((Component)panel2);
            if (date != null) {
                this.myLastUpdated = GridCellPluginComponent.createRatingLabel((JPanel)panel2, date, AllIcons.Plugins.Updated);
            }
            if (downloads != null) {
                this.myDownloads = GridCellPluginComponent.createRatingLabel((JPanel)panel2, downloads, AllIcons.Plugins.Downloads);
            }
            if (rating != null) {
                this.myRating = GridCellPluginComponent.createRatingLabel((JPanel)panel2, rating, AllIcons.Plugins.Rating);
            }
        }
    }

    @NotNull
    private static JLabel createRatingLabel(@NotNull JPanel panel2, @NotNull String text, @NotNull Icon icon) {
        JLabel label2 = new JLabel(text, icon, 0);
        label2.setOpaque(false);
        label2.setIconTextGap(2);
        panel2.add(PluginManagerConfigurableNew.installTiny(label2));
        return label2;
    }

    private void addInstallButton() {
        if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
            this.myLastComponent = new RestartButton(this.myPluginModel);
            this.add(this.myLastComponent);
            return;
        }
        this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, true));
        this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
        this.myLastComponent = this.myInstallButton;
        this.add(this.myLastComponent);
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        TwoLineProgressIndicator indicator = new TwoLineProgressIndicator();
        indicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false, false));
        this.myIndicator = indicator;
        this.myInstallButton.setVisible(false);
        this.myLastComponent = indicator.getComponent();
        this.add(this.myLastComponent);
        this.doLayout();
        this.myPluginModel.addProgress(this.myPlugin, indicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress(boolean success2) {
        this.myIndicator = null;
        JComponent lastComponent = this.myLastComponent;
        if (success2) {
            this.myLastComponent = new RestartButton(this.myPluginModel);
            this.add(this.myLastComponent);
        } else {
            this.myLastComponent = this.myInstallButton;
            this.myInstallButton.setVisible(true);
        }
        this.remove(lastComponent);
        this.doLayout();
        this.fullRepaint();
    }

    private void addTags(@NotNull JPanel parent, @NotNull TagBuilder tagBuilder) {
        List<String> tags = PluginManagerConfigurableNew.getTags(this.myPlugin);
        if (tags.isEmpty()) {
            return;
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
        parent.add((Component)panel2);
        this.myTagComponents = new ArrayList<TagComponent>();
        for (String tag : tags) {
            TagComponent component = tagBuilder.createTagComponent(tag);
            panel2.add((Component)((Object)component));
            this.myTagComponents.add(component);
        }
    }

    @Override
    public void setListeners(final @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
        super.setListeners(listener2, searchListener, eventHandler);
        if (this.myDescription != null) {
            UIUtil.setCursor((Component)this.myDescription, (Cursor)Cursor.getPredefinedCursor(12));
            this.myDescription.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        listener2.linkSelected(GridCellPluginComponent.this.myName, (Object)GridCellPluginComponent.this.myPlugin);
                    }
                }
            });
            this.myDescription.addMouseListener(this.myHoverNameListener);
        }
        if (this.myTagComponents != null) {
            for (TagComponent component : this.myTagComponents) {
                component.setListener(searchListener, SearchQueryParser.getTagQuery(component.getText()));
            }
            this.myTagComponents = null;
        }
    }

    @Override
    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        super.updateColors(grayedFg, background);
        if (this.myLastUpdated != null) {
            this.myLastUpdated.setForeground(grayedFg);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(grayedFg);
        }
        if (this.myRating != null) {
            this.myRating.setForeground(grayedFg);
        }
    }

    @Override
    public void close() {
        if (this.myIndicator != null) {
            this.myPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }
}

