/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginLogoIcon;
import com.intellij.openapi.util.Computable;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class HiDPIPluginLogoIcon
extends PluginLogoIcon {
    private static Icon myCachedDisabledJBLogo;
    private static Icon myCachedJBLogo2x;
    private static Icon myCachedErrorLogo2x;
    private static Icon myCachedDisabledJBLogo2x;

    HiDPIPluginLogoIcon(@NotNull Icon logo_40, @NotNull Icon logo_80) {
        super(logo_40, HiDPIPluginLogoIcon.createHiDPIDisabledIcon(logo_40), logo_80, HiDPIPluginLogoIcon.createHiDPIDisabledIcon(logo_80));
    }

    @Override
    @NotNull
    protected Icon getDisabledJBLogo() {
        if (myCachedDisabledJBLogo == null) {
            myCachedDisabledJBLogo = super.getDisabledJBLogo();
        }
        return myCachedDisabledJBLogo;
    }

    @Override
    @NotNull
    protected Icon getJBLogo2x() {
        if (myCachedJBLogo2x == null) {
            myCachedJBLogo2x = super.getJBLogo2x();
        }
        return myCachedJBLogo2x;
    }

    @Override
    @NotNull
    protected Icon getErrorLogo2x() {
        if (myCachedErrorLogo2x == null) {
            myCachedErrorLogo2x = super.getErrorLogo2x();
        }
        return myCachedErrorLogo2x;
    }

    @Override
    @NotNull
    protected Icon getDisabledJBLogo2x(@NotNull Icon jbLogo2x) {
        if (myCachedDisabledJBLogo2x == null) {
            myCachedDisabledJBLogo2x = super.getDisabledJBLogo2x(jbLogo2x);
        }
        return myCachedDisabledJBLogo2x;
    }

    static void clearCache() {
        myCachedDisabledJBLogo = null;
        myCachedJBLogo2x = null;
        myCachedErrorLogo2x = null;
        myCachedDisabledJBLogo2x = null;
    }

    @Override
    @NotNull
    protected Icon getDisabledIcon(@NotNull Icon icon) {
        return HiDPIPluginLogoIcon.createHiDPIDisabledIcon(icon);
    }

    @Override
    @NotNull
    protected Icon getScaled2xIcon(@NotNull Icon icon) {
        final Computable superCall = () -> super.getScaled2xIcon(icon);
        return new Icon(){
            final JBUI.ScaleContext myContext = JBUI.ScaleContext.create();
            Icon myIcon;

            @NotNull
            Icon getIcon() {
                if (this.myContext.update() || this.myIcon == null) {
                    this.myIcon = (Icon)superCall.compute();
                }
                return this.myIcon;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                this.getIcon().paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return this.getIcon().getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.getIcon().getIconHeight();
            }
        };
    }

    @NotNull
    private static Icon createHiDPIDisabledIcon(@NotNull Icon icon) {
        return HiDPIPluginLogoIcon.getHiDPI(JBUI.ScaleContext.create(), HiDPIPluginLogoIcon.createDisabledIcon(icon));
    }

    @NotNull
    static Icon loadSVG(@NotNull InputStream stream, int width, int height) throws IOException {
        JBUI.ScaleContext context = JBUI.ScaleContext.create();
        return HiDPIPluginLogoIcon.getHiDPI(context, SVGLoader.loadHiDPI(null, (InputStream)stream, (JBUI.ScaleContext)context, (double)width, (double)height));
    }

    @NotNull
    private static Icon getHiDPI(@NotNull JBUI.ScaleContext context, @NotNull Object source) {
        if (source instanceof ImageIcon) {
            Image image = ((ImageIcon)source).getImage();
            if (image instanceof JBHiDPIScaledImage) {
                return HiDPIPluginLogoIcon.wrapHiDPI(context, (JBHiDPIScaledImage)image);
            }
            return (Icon)source;
        }
        if (source instanceof JBHiDPIScaledImage) {
            return HiDPIPluginLogoIcon.wrapHiDPI(context, (JBHiDPIScaledImage)source);
        }
        if (source instanceof Image) {
            return new JBImageIcon((Image)source);
        }
        return (Icon)source;
    }

    @NotNull
    private static Icon wrapHiDPI(final @NotNull JBUI.ScaleContext context, final @NotNull JBHiDPIScaledImage image) {
        return new JBImageIcon((Image)image){
            final double myBase;
            {
                super(x0);
                this.myBase = context.getScale(JBUI.ScaleType.USR_SCALE);
            }

            private void update() {
                if (context.update()) {
                    this.setImage((Image)image.scale(context.getScale(JBUI.ScaleType.USR_SCALE) / this.myBase));
                }
            }

            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                this.update();
                super.paintIcon(c, g, x, y);
            }

            public int getIconWidth() {
                this.update();
                return super.getIconWidth();
            }

            public int getIconHeight() {
                this.update();
                return super.getIconHeight();
            }
        };
    }
}

