/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class LazyPluginLogoIcon
implements PluginLogoIconProvider {
    private PluginLogoIconProvider myLogoIcon;
    private final Map<String, LazyIcon> myIcons = new HashMap<String, LazyIcon>();

    LazyPluginLogoIcon(@NotNull PluginLogoIconProvider logoIcon) {
        this.myLogoIcon = logoIcon;
    }

    @Override
    @NotNull
    public Icon getIcon(boolean big, boolean jb, boolean error, boolean disabled) {
        String key = String.valueOf(big) + jb + error + disabled;
        LazyIcon icon = this.myIcons.get(key);
        if (icon == null) {
            icon = new LazyIcon(new boolean[]{big, jb, error, disabled});
            this.myIcons.put(key, icon);
            icon.setIcon(this.myLogoIcon);
        }
        return icon;
    }

    void setLogoIcon(@NotNull PluginLogoIconProvider logoIcon) {
        this.myLogoIcon = logoIcon;
        for (LazyIcon icon : this.myIcons.values()) {
            icon.setIcon(logoIcon);
        }
    }

    private static class LazyIcon
    implements Icon {
        private final boolean[] myState;
        private Icon myIcon;
        private final Set<Component> myComponents = new HashSet<Component>();

        private LazyIcon(@NotNull boolean[] state) {
            this.myState = state;
        }

        private void setIcon(@NotNull PluginLogoIconProvider logoIcon) {
            this.myIcon = logoIcon.getIcon(this.myState[0], this.myState[1], this.myState[2], this.myState[3]);
            for (Component component : this.myComponents) {
                if (!component.isShowing()) continue;
                component.repaint();
            }
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            this.myComponents.add(component);
            this.myIcon.paintIcon(component, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

