/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;

public class LineFunction {
    private final int myLines;
    private final boolean myShowDots;
    private Point myLastPoint;

    public LineFunction(int lines2, boolean showDots) {
        this.myLines = lines2 + 1;
        this.myShowDots = showDots;
    }

    public void paintComponent(@NotNull JEditorPane pane, @NotNull Graphics g) {
        if (this.myShowDots && this.myLastPoint != null) {
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            g.setColor(pane.getForeground());
            g.drawString("...", this.myLastPoint.x, this.myLastPoint.y + g.getFontMetrics().getAscent());
        }
    }

    public int getHeight(@NotNull JEditorPane pane) {
        this.myLastPoint = null;
        try {
            int line = 0;
            int startLineY = -1;
            int length = pane.getDocument().getLength();
            for (int i = 0; i < length; ++i) {
                Rectangle r = pane.modelToView(i);
                if (r == null || r.height <= 0 || startLineY >= r.y) continue;
                startLineY = r.y;
                if (++line != this.myLines) continue;
                int ii = i;
                while (ii > 0) {
                    Rectangle rr;
                    if ((rr = pane.modelToView(--ii)) == null) continue;
                    this.myLastPoint = rr.getLocation();
                    break;
                }
                return r.y;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return (int)(pane.getUI().getRootView(pane).getPreferredSpan(1) + JBUI.scale((float)2.0f));
    }
}

