/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsListLayout;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiSelectionEventHandler
extends EventHandler {
    private PluginsGroupComponent myContainer;
    private PluginsListLayout myLayout;
    private List<CellPluginComponent> myComponents;
    private CellPluginComponent myHoverComponent;
    private int mySelectionIndex;
    private int mySelectionLength;
    private final MouseAdapter myMouseHandler;
    private final KeyListener myKeyListener;
    private final FocusListener myFocusListener;
    private final ShortcutSet mySelectAllKeys;
    private final ShortcutSet myDeleteKeys;
    private boolean myAllSelected;
    private boolean myMixSelection;

    public MultiSelectionEventHandler() {
        this.clear();
        this.myMouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event)) {
                    CellPluginComponent component = EventHandler.get(event);
                    int index = MultiSelectionEventHandler.this.getIndex(component);
                    if (event.isShiftDown()) {
                        int end = MultiSelectionEventHandler.this.mySelectionIndex + MultiSelectionEventHandler.this.mySelectionLength + (MultiSelectionEventHandler.this.mySelectionLength > 0 ? -1 : 1);
                        if (index != end) {
                            MultiSelectionEventHandler.this.moveOrResizeSelection(index < end, false, Math.abs(end - index));
                        }
                    } else if (event.isMetaDown()) {
                        MultiSelectionEventHandler.this.myMixSelection = true;
                        MultiSelectionEventHandler.this.myAllSelected = false;
                        MultiSelectionEventHandler.this.mySelectionIndex = index;
                        MultiSelectionEventHandler.this.mySelectionLength = 1;
                        component.setSelection(component.getSelection() == EventHandler.SelectionType.SELECTION ? EventHandler.SelectionType.NONE : EventHandler.SelectionType.SELECTION, true);
                    } else {
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(component, index);
                    }
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    CellPluginComponent component = EventHandler.get(event);
                    if (MultiSelectionEventHandler.this.myAllSelected || MultiSelectionEventHandler.this.myMixSelection) {
                        int size = MultiSelectionEventHandler.this.getSelection().size();
                        if (size == 0) {
                            MultiSelectionEventHandler.this.singleSelection(component, MultiSelectionEventHandler.this.getIndex(component));
                        } else if (size == 1) {
                            MultiSelectionEventHandler.this.ensureMoveSingleSelection(component);
                        }
                    } else if (MultiSelectionEventHandler.this.mySelectionLength == 0 || MultiSelectionEventHandler.this.mySelectionLength == 1) {
                        MultiSelectionEventHandler.this.ensureMoveSingleSelection(component);
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    component.createPopupMenu(group, MultiSelectionEventHandler.this.getSelection());
                    if (group.getChildrenCount() == 0) {
                        return;
                    }
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
                    popupMenu.setTargetComponent((JComponent)component);
                    popupMenu.getComponent().show(event.getComponent(), event.getX(), event.getY());
                    event.consume();
                }
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (MultiSelectionEventHandler.this.myHoverComponent != null) {
                    if (MultiSelectionEventHandler.this.myHoverComponent.getSelection() == EventHandler.SelectionType.HOVER) {
                        MultiSelectionEventHandler.this.myHoverComponent.setSelection(EventHandler.SelectionType.NONE);
                    }
                    MultiSelectionEventHandler.this.myHoverComponent = null;
                }
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                CellPluginComponent component;
                if (MultiSelectionEventHandler.this.myHoverComponent == null && (component = EventHandler.get(event)).getSelection() == EventHandler.SelectionType.NONE) {
                    MultiSelectionEventHandler.this.myHoverComponent = component;
                    component.setSelection(EventHandler.SelectionType.HOVER);
                }
            }
        };
        this.mySelectAllKeys = MultiSelectionEventHandler.getShortcuts("$SelectAll");
        this.myDeleteKeys = MultiSelectionEventHandler.getShortcuts("EditorDelete");
        this.myKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int modifiers;
                int code = event.getKeyCode();
                KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(code, modifiers = event.getModifiers()), null);
                if (EventHandler.check(shortcut, MultiSelectionEventHandler.this.mySelectAllKeys)) {
                    event.consume();
                    MultiSelectionEventHandler.this.selectAll();
                    return;
                }
                if (EventHandler.check(shortcut, MultiSelectionEventHandler.this.myDeleteKeys)) {
                    code = EventHandler.DELETE_CODE;
                }
                if (code == 36 || code == 35) {
                    if (MultiSelectionEventHandler.this.myComponents.isEmpty()) {
                        return;
                    }
                    event.consume();
                    if (event.isShiftDown()) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 36, false, 2 * MultiSelectionEventHandler.this.myComponents.size());
                    } else {
                        int index = code == 36 ? 0 : MultiSelectionEventHandler.this.myComponents.size() - 1;
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(index);
                    }
                } else if (code == 38 || code == 40) {
                    event.consume();
                    if (modifiers == 0) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 38, true, 1);
                    } else if (modifiers == 1) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 38, false, 1);
                    }
                } else if (code == 33 || code == 34) {
                    if (MultiSelectionEventHandler.this.myComponents.isEmpty()) {
                        return;
                    }
                    event.consume();
                    int pageCount = ((MultiSelectionEventHandler)MultiSelectionEventHandler.this).myContainer.getVisibleRect().height / ((MultiSelectionEventHandler)MultiSelectionEventHandler.this).myLayout.myLineHeight;
                    MultiSelectionEventHandler.this.moveOrResizeSelection(code == 33, !event.isShiftDown(), pageCount);
                } else if (code == 32 || code == 10 || code == EventHandler.DELETE_CODE) {
                    assert (MultiSelectionEventHandler.this.mySelectionLength != 0);
                    CellPluginComponent component = (CellPluginComponent)MultiSelectionEventHandler.this.myComponents.get(MultiSelectionEventHandler.this.mySelectionIndex);
                    if (component.getSelection() != EventHandler.SelectionType.SELECTION) {
                        component.setSelection(EventHandler.SelectionType.SELECTION);
                    }
                    component.handleKeyAction(code, MultiSelectionEventHandler.this.getSelection());
                }
            }
        };
        this.myFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                if (MultiSelectionEventHandler.this.mySelectionIndex >= 0 && MultiSelectionEventHandler.this.mySelectionLength == 1 && !MultiSelectionEventHandler.this.myMixSelection) {
                    CellPluginComponent component = EventHandler.get(event);
                    int index = MultiSelectionEventHandler.this.getIndex(component);
                    if (MultiSelectionEventHandler.this.mySelectionIndex != index) {
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(component, index);
                    }
                }
            }
        };
    }

    @Override
    public void connect(@NotNull PluginsGroupComponent container) {
        this.myContainer = container;
        this.myLayout = (PluginsListLayout)((Object)container.getLayout());
    }

    @Override
    public void addCell(@NotNull CellPluginComponent component, int index) {
        if (index == -1) {
            this.myComponents.add(component);
        } else {
            this.myComponents.add(index, component);
        }
    }

    @Override
    public void addCell(@NotNull CellPluginComponent component, @Nullable CellPluginComponent anchor2) {
        if (anchor2 == null) {
            this.myComponents.add(component);
        } else {
            this.myComponents.add(this.myComponents.indexOf(anchor2), component);
        }
    }

    @Override
    public void removeCell(@NotNull CellPluginComponent component) {
        this.myComponents.remove(component);
    }

    @Override
    public void initialSelection(boolean scrollAndFocus) {
        if (!this.myComponents.isEmpty() && this.mySelectionLength == 0) {
            this.singleSelection(this.myComponents.get(0), 0, scrollAndFocus);
        }
    }

    @Override
    @NotNull
    public List<CellPluginComponent> getSelection() {
        ArrayList<CellPluginComponent> selection = new ArrayList<CellPluginComponent>();
        for (CellPluginComponent component : this.myComponents) {
            if (component.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            selection.add(component);
        }
        return selection;
    }

    @Override
    public void clear() {
        this.myComponents = new ArrayList<CellPluginComponent>();
        this.myHoverComponent = null;
        this.mySelectionIndex = -1;
        this.mySelectionLength = 0;
        this.myAllSelected = false;
        this.myMixSelection = false;
    }

    private void selectAll() {
        if (this.myAllSelected) {
            return;
        }
        this.myAllSelected = true;
        this.myMixSelection = false;
        this.myHoverComponent = null;
        for (CellPluginComponent component : this.myComponents) {
            if (component.getSelection() == EventHandler.SelectionType.SELECTION) continue;
            component.setSelection(EventHandler.SelectionType.SELECTION, false);
        }
    }

    private void moveOrResizeSelection(boolean up, boolean singleSelection, int count) {
        block9: {
            block12: {
                block10: {
                    block11: {
                        block8: {
                            if (!singleSelection) break block8;
                            assert (this.mySelectionLength != 0);
                            int index = this.mySelectionLength > 0 ? (up ? Math.max(this.mySelectionIndex + this.mySelectionLength - 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength - 1 + count, this.myComponents.size() - 1)) : (up ? Math.max(this.mySelectionIndex + this.mySelectionLength + 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength + 1 + count, this.myComponents.size() - 1));
                            this.clearSelectionWithout(index);
                            this.singleSelection(index);
                            break block9;
                        }
                        if (!up) break block10;
                        if (this.mySelectionLength <= 0) break block11;
                        if (this.mySelectionIndex + this.mySelectionLength - 1 <= 0) break block9;
                        this.clearAllOrMixSelection();
                        for (int i = 0; i < count && this.mySelectionIndex + this.mySelectionLength - 1 > 0; ++i) {
                            --this.mySelectionLength;
                            if (this.mySelectionLength > 0) {
                                this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(EventHandler.SelectionType.NONE, true);
                            }
                            if (this.mySelectionLength != 0) continue;
                            this.myComponents.get(this.mySelectionIndex - 1).setSelection(EventHandler.SelectionType.SELECTION);
                            this.mySelectionLength = -2;
                            int newCount = count - i - 1;
                            if (newCount > 0) {
                                this.moveOrResizeSelection(true, false, newCount);
                            }
                            return;
                        }
                        break block9;
                    }
                    if (this.mySelectionIndex + this.mySelectionLength + 1 <= 0) break block9;
                    this.clearAllOrMixSelection();
                    int i = 0;
                    for (int index = this.mySelectionIndex + this.mySelectionLength + 1; i < count && index > 0; ++i, --index) {
                        --this.mySelectionLength;
                        this.myComponents.get(index - 1).setSelection(EventHandler.SelectionType.SELECTION);
                    }
                    break block9;
                }
                if (this.mySelectionLength <= 0) break block12;
                if (this.mySelectionIndex + this.mySelectionLength >= this.myComponents.size()) break block9;
                this.clearAllOrMixSelection();
                int i = 0;
                int size = this.myComponents.size();
                for (int index = this.mySelectionIndex + this.mySelectionLength; i < count && index < size; ++i, ++index) {
                    this.myComponents.get(index).setSelection(EventHandler.SelectionType.SELECTION);
                    ++this.mySelectionLength;
                }
                break block9;
            }
            this.clearAllOrMixSelection();
            for (int i = 0; i < count; ++i) {
                ++this.mySelectionLength;
                this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(EventHandler.SelectionType.NONE, true);
                if (this.mySelectionLength != -1) continue;
                this.mySelectionLength = 1;
                int newCount = count - i - 1;
                if (newCount > 0) {
                    this.moveOrResizeSelection(false, false, newCount);
                }
                return;
            }
        }
    }

    private int getIndex(@NotNull CellPluginComponent component) {
        int index = this.myComponents.indexOf(component);
        assert (index >= 0) : component;
        return index;
    }

    private void clearAllOrMixSelection() {
        int i;
        int last;
        int first;
        CellPluginComponent component;
        if (!this.myAllSelected && !this.myMixSelection) {
            return;
        }
        if (this.myMixSelection && this.mySelectionIndex != -1 && (component = this.myComponents.get(this.mySelectionIndex)).getSelection() != EventHandler.SelectionType.SELECTION) {
            component.setSelection(EventHandler.SelectionType.SELECTION);
        }
        this.myAllSelected = false;
        this.myMixSelection = false;
        if (this.mySelectionLength > 0) {
            first = this.mySelectionIndex;
            last = this.mySelectionIndex + this.mySelectionLength;
        } else {
            first = this.mySelectionIndex + this.mySelectionLength + 1;
            last = this.mySelectionIndex + 1;
        }
        for (i = 0; i < first; ++i) {
            CellPluginComponent component2 = this.myComponents.get(i);
            if (component2.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component2.setSelection(EventHandler.SelectionType.NONE);
        }
        int size = this.myComponents.size();
        for (i = last; i < size; ++i) {
            CellPluginComponent component3 = this.myComponents.get(i);
            if (component3.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component3.setSelection(EventHandler.SelectionType.NONE);
        }
    }

    private void clearSelectionWithout(int withoutIndex) {
        this.myAllSelected = false;
        this.myMixSelection = false;
        int size = this.myComponents.size();
        for (int i = 0; i < size; ++i) {
            CellPluginComponent component;
            if (i == withoutIndex || (component = this.myComponents.get(i)).getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component.setSelection(EventHandler.SelectionType.NONE);
        }
    }

    private void ensureMoveSingleSelection(CellPluginComponent component) {
        int index = this.getIndex(component);
        if (this.mySelectionLength == 0 || this.mySelectionIndex != index) {
            this.clearSelectionWithout(index);
            this.singleSelection(component, index);
        }
    }

    @Override
    public void setSelection(@NotNull CellPluginComponent component, boolean scrollAndFocus) {
        this.clearSelectionWithout(-1);
        this.singleSelection(component, this.getIndex(component), scrollAndFocus);
    }

    @Override
    public void setSelection(@NotNull List<CellPluginComponent> components) {
        this.clearSelectionWithout(-1);
        this.mySelectionIndex = -1;
        this.mySelectionLength = components.size();
        if (this.mySelectionLength == 0) {
            return;
        }
        this.mySelectionIndex = this.getIndex(components.get(0));
        for (CellPluginComponent component : components) {
            this.mySelectionIndex = Math.min(this.mySelectionIndex, this.getIndex(component));
            if (component.getSelection() == EventHandler.SelectionType.SELECTION) continue;
            component.setSelection(EventHandler.SelectionType.SELECTION, true);
        }
    }

    private void singleSelection(int index) {
        this.singleSelection(this.myComponents.get(index), index);
    }

    private void singleSelection(@NotNull CellPluginComponent component, int index) {
        this.singleSelection(component, index, true);
    }

    private void singleSelection(@NotNull CellPluginComponent component, int index, boolean scrollAndFocus) {
        this.mySelectionIndex = index;
        this.mySelectionLength = 1;
        if (this.myHoverComponent == component) {
            this.myHoverComponent = null;
        }
        if (component.getSelection() != EventHandler.SelectionType.SELECTION) {
            component.setSelection(EventHandler.SelectionType.SELECTION, scrollAndFocus);
        }
    }

    @Override
    public void add(@NotNull Component component) {
        component.addMouseListener(this.myMouseHandler);
        component.addMouseMotionListener(this.myMouseHandler);
        component.addKeyListener(this.myKeyListener);
        component.addFocusListener(this.myFocusListener);
    }

    @Override
    public void updateHover(@NotNull CellPluginComponent component) {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myHoverComponent = component;
            if (component.getSelection() == EventHandler.SelectionType.NONE) {
                component.setSelection(EventHandler.SelectionType.HOVER);
            }
        }, ModalityState.any());
    }
}

