/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.DetailsPagePluginComponent;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginManagerMain.PluginEnabler {
    private final List<ListPluginComponent> myListComponents = new ArrayList<ListPluginComponent>();
    private final Map<IdeaPluginDescriptor, List<ListPluginComponent>> myListMap = new HashMap<IdeaPluginDescriptor, List<ListPluginComponent>>();
    private final Map<IdeaPluginDescriptor, List<GridCellPluginComponent>> myGridMap = new HashMap<IdeaPluginDescriptor, List<GridCellPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myDownloadedPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private PluginsGroup myUpdates;
    private Configurable.TopComponentController myTopController;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Map<IdeaPluginDescriptor, InstallPluginInfo> myInstallingInfos = new HashMap<IdeaPluginDescriptor, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    public DetailsPagePluginComponent detailPanel;
    private StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;

    public MyPluginModel() {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)frame).getStatusBar();
        }
        return null;
    }

    public void addComponent(@NotNull CellPluginComponent component) {
        if (component instanceof ListPluginComponent) {
            if (myInstallingPlugins.contains(component.myPlugin)) {
                return;
            }
            this.myListComponents.add((ListPluginComponent)component);
            List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
            if (components == null) {
                components = new ArrayList<ListPluginComponent>();
                this.myListMap.put(component.myPlugin, components);
            }
            components.add((ListPluginComponent)component);
        } else {
            List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
            if (components == null) {
                components = new ArrayList<GridCellPluginComponent>();
                this.myGridMap.put(component.myPlugin, components);
            }
            components.add((GridCellPluginComponent)component);
        }
    }

    public void removeComponent(@NotNull CellPluginComponent component) {
        if (component instanceof ListPluginComponent) {
            this.myListComponents.remove((ListPluginComponent)component);
            List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myListMap.remove(component.myPlugin);
                }
            }
        } else {
            List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myGridMap.remove(component.myPlugin);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        this.myTopController = topController;
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service2) {
        this.myPluginUpdatesService = service2;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        return myInstallingPlugins;
    }

    public static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor) {
        return myInstallingWithUpdatesPlugins.contains(descriptor);
    }

    public void installOrUpdatePlugin(@NotNull IdeaPluginDescriptor descriptor, boolean install) {
        PluginNode pluginNode;
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(descriptor))) {
            return;
        }
        if (descriptor instanceof PluginNode) {
            pluginNode = (PluginNode)descriptor;
        } else {
            pluginNode = new PluginNode(descriptor.getPluginId(), descriptor.getName(), "-1");
            pluginNode.setDepends(Arrays.asList(descriptor.getDependentPluginIds()), descriptor.getOptionalDependentPluginIds());
            pluginNode.setRepositoryName("__unknown_repository__");
        }
        ArrayList pluginsToInstall = ContainerUtil.newArrayList((Object[])new PluginNode[]{pluginNode});
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
        this.needRestart = true;
        MyPluginModel.installPlugin(pluginsToInstall, this.getAllRepoPlugins(), this, this.prepareToInstall(descriptor, install));
    }

    private static void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<IdeaPluginDescriptor> allPlugins, @NotNull PluginManagerMain.PluginEnabler pluginEnabler, @NotNull InstallPluginInfo info) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean cancel = false;
            boolean error = false;
            try {
                error = !PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, pluginEnabler, info.indicator);
            }
            catch (ProcessCanceledException e) {
                cancel = true;
            }
            catch (Throwable e) {
                PluginManagerMain.LOG.error(e);
                error = true;
            }
            boolean success2 = !error;
            boolean _cancel = cancel;
            ApplicationManager.getApplication().invokeLater(() -> info.finish(success2, _cancel), ModalityState.any());
        });
    }

    public void toBackground() {
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.toBackground(this.myStatusBar);
        }
    }

    @NotNull
    private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor, boolean install) {
        List<ListPluginComponent> listComponents;
        List<GridCellPluginComponent> gridComponents;
        InstallPluginInfo info = new InstallPluginInfo(descriptor, this, install);
        myInstallingInfos.put(descriptor, info);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor);
        if (install) {
            myInstallingPlugins.add(descriptor);
        }
        if (install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor);
                this.myDownloadedPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myDownloadedPanel.addToGroup(this.myInstalling, descriptor);
            }
            this.myInstalling.titleWithCount();
            this.myDownloadedPanel.doLayout();
        }
        if ((gridComponents = this.myGridMap.get(descriptor)) != null) {
            for (GridCellPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor) {
            this.detailPanel.showProgress();
        }
        return info;
    }

    public void finishInstall(@NotNull IdeaPluginDescriptor descriptor, boolean success2, boolean showErrors) {
        List<ListPluginComponent> listComponents;
        List<GridCellPluginComponent> gridComponents;
        InstallPluginInfo info = MyPluginModel.finishInstall(descriptor);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((gridComponents = this.myGridMap.get(descriptor)) != null) {
            for (GridCellPluginComponent gridCellPluginComponent : gridComponents) {
                gridCellPluginComponent.hideProgress(success2);
            }
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.hideProgress(success2);
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor) {
            this.detailPanel.hideProgress(success2);
        }
        if (info.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor);
                if (myInstallingPlugins.isEmpty()) {
                    this.myDownloadedPanel.removeGroup(this.myInstalling);
                } else {
                    this.myDownloadedPanel.removeFromGroup(this.myInstalling, descriptor);
                    this.myInstalling.titleWithCount();
                }
                this.myDownloadedPanel.doLayout();
            }
            if (success2) {
                this.appendOrUpdateDescriptor(descriptor);
                this.appendDependsAfterInstall();
            }
        } else if (success2) {
            CellPluginComponent cellPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && (cellPluginComponent = this.myDownloaded.ui.findComponent(descriptor)) != null) {
                ((ListPluginComponent)cellPluginComponent).changeUpdateToRestart();
            }
            if (this.myUpdates != null) {
                this.myUpdates.titleWithCount();
            }
            this.myPluginUpdatesService.finishUpdate(descriptor);
        }
        info.indicator.cancel();
        if (!success2 && showErrors) {
            Messages.showErrorDialog((String)("Plugin " + descriptor.getName() + " download or installing failed"), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor) {
        if (myInstallingPlugins.isEmpty()) {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                ((ListPluginComponent)listComponent).clearProgress();
            }
        } else {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.myPlugin != descriptor) continue;
                ((ListPluginComponent)listComponent).clearProgress();
                return;
            }
        }
    }

    @NotNull
    public static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor) {
        InstallPluginInfo info = myInstallingInfos.remove(descriptor);
        myInstallingWithUpdatesPlugins.remove(descriptor);
        if (info.install) {
            myInstallingPlugins.remove(descriptor);
        }
        return info;
    }

    public void addProgress(@NotNull IdeaPluginDescriptor descriptor, @NotNull ProgressIndicatorEx indicator) {
        MyPluginModel.myInstallingInfos.get((Object)descriptor).indicator.addStateDelegate(indicator);
    }

    public void removeProgress(@NotNull IdeaPluginDescriptor descriptor, @NotNull ProgressIndicatorEx indicator) {
        MyPluginModel.myInstallingInfos.get((Object)descriptor).indicator.removeStateDelegate(indicator);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group) {
        this.myEnabledGroups.add(group);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        this.myDownloadedPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    public void setUpdateGroup(@NotNull PluginsGroup group) {
        this.myUpdates = group;
    }

    private void appendDependsAfterInstall() {
        block0: for (IdeaPluginDescriptor descriptor : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            if (this.myDownloaded != null && this.myDownloaded.ui != null && this.myDownloaded.ui.findComponent(descriptor) != null) continue;
            this.appendOrUpdateDescriptor(descriptor);
            String id = descriptor.getPluginId().getIdString();
            for (Map.Entry<IdeaPluginDescriptor, List<GridCellPluginComponent>> entry : this.myGridMap.entrySet()) {
                if (!id.equals(entry.getKey().getPluginId().getIdString())) continue;
                for (GridCellPluginComponent component : entry.getValue()) {
                    component.hideProgress(true);
                }
                continue block0;
            }
        }
    }

    @Override
    public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor) {
        super.appendOrUpdateDescriptor(descriptor);
        this.needRestart = true;
        if (this.myDownloaded == null) {
            return;
        }
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myDownloadedPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            CellPluginComponent component = this.myDownloaded.ui.findComponent(descriptor);
            if (component != null) {
                this.myDownloadedPanel.setSelection(component);
                ((ListPluginComponent)component).changeUpdateToRestart();
                return;
            }
            this.myDownloadedPanel.addToGroup(this.myDownloaded, descriptor);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor)));
            this.myDownloadedPanel.doLayout();
        }
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor plugin) {
        Boolean enabled = this.getEnabledMap().get(plugin.getPluginId());
        return enabled == null || enabled != false;
    }

    @NotNull
    public String getEnabledTitle(@NotNull IdeaPluginDescriptor plugin) {
        return this.isEnabled(plugin) ? "Disable" : "Enable";
    }

    public void changeEnableDisable(@NotNull IdeaPluginDescriptor plugin) {
        this.enableRows(new IdeaPluginDescriptor[]{plugin}, !this.isEnabled(plugin));
        this.updateAfterEnableDisable();
    }

    public void changeEnableDisable(@NotNull IdeaPluginDescriptor[] plugins2, boolean state) {
        this.enableRows(plugins2, state);
        this.updateAfterEnableDisable();
    }

    @Override
    public void enablePlugins(Set<IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), true);
    }

    @Override
    public void disablePlugins(Set<IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), false);
    }

    public void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor) {
        Set<PluginId> requiredPluginIds = this.getRequiredPlugins(descriptor.getPluginId());
        if (ContainerUtil.isEmpty(requiredPluginIds)) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> {
                if (d instanceof IdeaPluginDescriptorImpl) {
                    return ((IdeaPluginDescriptorImpl)d).getModules().contains(pluginId.getIdString());
                }
                return false;
            })) != null) {
                this.getEnabledMap().put(pluginId, Boolean.TRUE);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component : this.myListComponents) {
            component.updateEnabledState();
        }
        for (PluginsGroup group : this.myEnabledGroups) {
            group.titleWithEnabled(this);
        }
    }

    public boolean showUninstallDialog(@NotNull List<CellPluginComponent> selection) {
        int size = selection.size();
        return this.showUninstallDialog(size == 1 ? selection.get((int)0).myPlugin.getName() : null, size);
    }

    public boolean showUninstallDialog(@Nullable String singleName, int count) {
        String message = singleName == null ? IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{count}) : IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{singleName});
        return Messages.showYesNoDialog((String)message, (String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public void doUninstall(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor, @Nullable Runnable update) {
        List<ListPluginComponent> listComponents;
        String title;
        String message;
        if (!this.dependent((IdeaPluginDescriptorImpl)descriptor).isEmpty() && Messages.showYesNoDialog((Component)uiParent, (String)(message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{descriptor.getName()})), (String)(title = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        try {
            ((IdeaPluginDescriptorImpl)descriptor).setDeleted(true);
            PluginInstaller.prepareToUninstall(descriptor.getPluginId());
            this.needRestart |= descriptor.isEnabled();
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (update != null) {
            update.run();
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall();
            }
        }
        for (ListPluginComponent component : this.myListComponents) {
            component.updateErrors();
        }
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin) {
        return PluginManagerCore.isIncompatible(plugin) || this.hasProblematicDependencies(plugin.getPluginId());
    }
}

