/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.LazyPluginLogoIcon;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginLogoIcon;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginLogo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.newui.PluginLogo");
    private static final String CACHE_DIR = "imageCache";
    private static final String PLUGIN_ICON = "pluginIcon.svg";
    private static final String PLUGIN_ICON_DARK = "pluginIcon_dark.svg";
    private static final Map<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>> ICONS = new HashMap<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>>();
    private static PluginLogoIconProvider Default;
    private static List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> myPrepareToLoad;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor, boolean big, boolean jb, boolean error, boolean disabled) {
        return PluginLogo.getIcon(descriptor).getIcon(big, jb, error, disabled);
    }

    @NotNull
    private static PluginLogoIconProvider getIcon(@NotNull IdeaPluginDescriptor descriptor) {
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons = PluginLogo.getOrLoadIcon(descriptor);
        if (icons != null) {
            return JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second;
        }
        return PluginLogo.getDefault();
    }

    public static void startBatchMode() {
        assert (myPrepareToLoad == null);
        myPrepareToLoad = new ArrayList<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>>();
    }

    public static void endBatchMode() {
        assert (myPrepareToLoad != null);
        List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> descriptors = myPrepareToLoad;
        myPrepareToLoad = null;
        PluginLogo.runLoadTask(descriptors);
    }

    @NotNull
    private static PluginLogoIconProvider getDefault() {
        if (Default == null) {
            Default = new PluginLogoIcon(AllIcons.Plugins.PluginLogo_40, AllIcons.Plugins.PluginLogoDisabled_40, AllIcons.Plugins.PluginLogo_80, AllIcons.Plugins.PluginLogoDisabled_80);
        }
        return Default;
    }

    @Nullable
    private static Pair<PluginLogoIconProvider, PluginLogoIconProvider> getOrLoadIcon(@NotNull IdeaPluginDescriptor descriptor) {
        String idPlugin = PluginLogo.getIdForKey(descriptor);
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons = ICONS.get(idPlugin);
        if (icons != null) {
            return icons.first == null && icons.second == null ? null : icons;
        }
        LazyPluginLogoIcon lazyIcon = new LazyPluginLogoIcon(PluginLogo.getDefault());
        Pair lazyIcons = Pair.create((Object)lazyIcon, (Object)lazyIcon);
        ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)lazyIcons);
        Pair info = Pair.create((Object)descriptor, (Object)lazyIcon);
        if (myPrepareToLoad == null) {
            PluginLogo.runLoadTask(Collections.singletonList(info));
        } else {
            myPrepareToLoad.add((Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>)info);
        }
        return lazyIcons;
    }

    private static void runLoadTask(@NotNull List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> loadInfo) {
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            for (Pair info : loadInfo) {
                if (application.isDisposed()) {
                    return;
                }
                PluginLogo.loadPluginIcons((IdeaPluginDescriptor)info.first, (LazyPluginLogoIcon)info.second);
            }
        });
    }

    private static void loadPluginIcons(@NotNull IdeaPluginDescriptor descriptor, @NotNull LazyPluginLogoIcon lazyIcon) {
        PluginLogoIconProvider dark;
        PluginLogoIconProvider light;
        String idPlugin = PluginLogo.getIdForKey(descriptor);
        File path = descriptor.getPath();
        if (path != null) {
            if (path.isDirectory()) {
                if (System.getProperty("idea.required.plugins.id") != null && PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, new File(path, "classes"))) {
                    return;
                }
                if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, path)) {
                    return;
                }
                File libFile = new File(path, "lib");
                if (!libFile.exists() || !libFile.isDirectory()) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                File[] files2 = libFile.listFiles();
                if (files2 == null || files2.length == 0) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                for (File file2 : files2) {
                    if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, file2)) {
                        return;
                    }
                    if (!PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, file2, false)) continue;
                    return;
                }
            } else {
                PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, path, true);
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
            return;
        }
        String idFileName = FileUtil.sanitizeFileName((String)idPlugin);
        File cache = new File(PathManager.getPluginTempPath(), CACHE_DIR);
        File lightFile = new File(cache, idFileName + ".svg");
        File darkFile = new File(cache, idFileName + "_dark.svg");
        if (cache.exists()) {
            light = PluginLogo.tryLoadIcon(lightFile);
            dark = PluginLogo.tryLoadIcon(darkFile);
            if (light != null || dark != null) {
                PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
                return;
            }
        }
        try {
            PluginLogo.downloadFile(idPlugin, lightFile, "");
            PluginLogo.downloadFile(idPlugin, darkFile, "&theme=DARCULA");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        light = PluginLogo.tryLoadIcon(lightFile);
        dark = PluginLogo.tryLoadIcon(darkFile);
        PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
    }

    @NotNull
    private static String getIdForKey(@NotNull IdeaPluginDescriptor descriptor) {
        return descriptor.getPluginId().getIdString() + (descriptor.getPath() == null || MyPluginModel.getInstallingPlugins().contains(descriptor) || InstalledPluginsState.getInstance().wasInstalled(descriptor.getPluginId()) ? "" : "#local");
    }

    private static boolean tryLoadDirIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path) {
        PluginLogoIconProvider light = PluginLogo.tryLoadIcon(new File(path, "META-INF/pluginIcon.svg"));
        PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(new File(path, "META-INF/pluginIcon_dark.svg"));
        if (light != null || dark != null) {
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLoadJarIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path, boolean put) {
        if (!FileUtil.isJarOrZip((File)path)) return false;
        if (!path.exists()) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(path);){
            PluginLogoIconProvider light = PluginLogo.tryLoadIcon(zipFile, PLUGIN_ICON);
            PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(zipFile, PLUGIN_ICON_DARK);
            if (!put && light == null) {
                if (dark == null) return false;
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static void downloadFile(@NotNull String idPlugin, @NotNull File file2, @NotNull String theme) {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        try {
            Url url = Urls.newFromEncoded(ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/api/icon?pluginId=" + URLUtil.encodeURIComponent((String)idPlugin) + theme);
            HttpRequests.request((Url)url).forceHttps(PluginManagerConfigurableNew.forceHttps()).productNameAsUserAgent().connect(request -> {
                request.getConnection();
                request.saveToFile(file2, null);
                return null;
            });
        }
        catch (HttpRequests.HttpStatusException url) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void putIcon(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @Nullable PluginLogoIconProvider light, @Nullable PluginLogoIconProvider dark) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (light == null && dark == null) {
                ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)Pair.empty());
                return;
            }
            Pair icons = Pair.create((Object)(light == null ? dark : light), (Object)(dark == null ? light : dark));
            ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)icons);
            lazyIcon.setLogoIcon(JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second);
        }, ModalityState.any());
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull File iconFile) {
        return iconFile.exists() && iconFile.length() > 0L ? PluginLogo.loadFileIcon((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> new FileInputStream(iconFile))) : null;
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull ZipFile zipFile, @NotNull String name) {
        ZipEntry iconEntry = zipFile.getEntry("META-INF/" + name);
        return iconEntry == null ? null : PluginLogo.loadFileIcon((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> zipFile.getInputStream(iconEntry)));
    }

    @Nullable
    private static PluginLogoIconProvider loadFileIcon(@NotNull ThrowableComputable<InputStream, IOException> provider) {
        try {
            Icon logo40 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider.compute(), 40, 40);
            Icon logo80 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider.compute(), 80, 80);
            return new HiDPIPluginLogoIcon(logo40, logo80);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    static {
        LafManager.getInstance().addLafManagerListener(_0 -> {
            Default = null;
            HiDPIPluginLogoIcon.clearCache();
        });
    }
}

