/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PluginLogoIcon
implements PluginLogoIconProvider {
    private final Icon myPluginLogo_40;
    private final Icon myPluginLogoJB_40;
    private final Icon myPluginLogoError_40;
    private final Icon myPluginLogoJBError_40;
    private final Icon myPluginLogoDisabled_40;
    private final Icon myPluginLogoDisabledJB_40;
    private final Icon myPluginLogoDisabledError_40;
    private final Icon myPluginLogoDisabledJBError_40;
    private final Icon myPluginLogo_80;
    private final Icon myPluginLogoJB_80;
    private final Icon myPluginLogoError_80;
    private final Icon myPluginLogoJBError_80;
    private final Icon myPluginLogoDisabled_80;
    private final Icon myPluginLogoDisabledJB_80;
    private final Icon myPluginLogoDisabledError_80;
    private final Icon myPluginLogoDisabledJBError_80;

    PluginLogoIcon(@NotNull Icon logo_40, @NotNull Icon logoDisabled_40, @NotNull Icon logo_80, @NotNull Icon logoDisabled_80) {
        this.myPluginLogo_40 = logo_40;
        this.myPluginLogoJB_40 = PluginLogoIcon.setSouthEast(logo_40, AllIcons.Plugins.ModifierJBLogo);
        this.myPluginLogoError_40 = PluginLogoIcon.setSouthWest(logo_40, AllIcons.Plugins.ModifierInvalid);
        this.myPluginLogoJBError_40 = PluginLogoIcon.setSouthEastWest(logo_40, AllIcons.Plugins.ModifierJBLogo, AllIcons.Plugins.ModifierInvalid);
        Icon disabledJBLogo = this.getDisabledJBLogo();
        this.myPluginLogoDisabled_40 = logoDisabled_40;
        this.myPluginLogoDisabledJB_40 = PluginLogoIcon.setSouthEast(logoDisabled_40, disabledJBLogo);
        this.myPluginLogoDisabledError_40 = PluginLogoIcon.setSouthWest(logoDisabled_40, AllIcons.Plugins.ModifierInvalid);
        this.myPluginLogoDisabledJBError_40 = PluginLogoIcon.setSouthEastWest(logoDisabled_40, disabledJBLogo, AllIcons.Plugins.ModifierInvalid);
        Icon jbLogo2x = this.getJBLogo2x();
        Icon errorLogo2x = this.getErrorLogo2x();
        this.myPluginLogo_80 = logo_80;
        this.myPluginLogoJB_80 = PluginLogoIcon.setSouthEast(logo_80, jbLogo2x);
        this.myPluginLogoError_80 = PluginLogoIcon.setSouthWest(logo_80, errorLogo2x);
        this.myPluginLogoJBError_80 = PluginLogoIcon.setSouthEastWest(logo_80, jbLogo2x, errorLogo2x);
        Icon disabledJBLogo2x = this.getDisabledJBLogo2x(jbLogo2x);
        this.myPluginLogoDisabled_80 = logoDisabled_80;
        this.myPluginLogoDisabledJB_80 = PluginLogoIcon.setSouthEast(logoDisabled_80, disabledJBLogo2x);
        this.myPluginLogoDisabledError_80 = PluginLogoIcon.setSouthWest(logoDisabled_80, errorLogo2x);
        this.myPluginLogoDisabledJBError_80 = PluginLogoIcon.setSouthEastWest(logoDisabled_80, disabledJBLogo2x, errorLogo2x);
    }

    @NotNull
    private static Icon setSouthEast(@NotNull Icon main, @NotNull Icon southEast) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(main, 0);
        layeredIcon.setIcon(southEast, 1, 4);
        return layeredIcon;
    }

    @NotNull
    protected Icon getDisabledIcon(@NotNull Icon icon) {
        return PluginLogoIcon.createDisabledIcon(icon);
    }

    @NotNull
    protected static Icon createDisabledIcon(@NotNull Icon icon) {
        return Objects.requireNonNull(IconLoader.getDisabledIcon((Icon)icon));
    }

    @NotNull
    protected Icon getScaled2xIcon(@NotNull Icon icon) {
        return IconUtil.scale((Icon)icon, null, (float)2.0f);
    }

    @NotNull
    private static Icon setSouthWest(@NotNull Icon main, @NotNull Icon southWest) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(main, 0);
        layeredIcon.setIcon(southWest, 1, 6);
        return layeredIcon;
    }

    @NotNull
    private static Icon setSouthEastWest(@NotNull Icon main, @NotNull Icon southEast, @NotNull Icon southWest) {
        LayeredIcon layeredIcon = new LayeredIcon(3);
        layeredIcon.setIcon(main, 0);
        layeredIcon.setIcon(southEast, 1, 4);
        layeredIcon.setIcon(southWest, 2, 6);
        return layeredIcon;
    }

    @NotNull
    protected Icon getDisabledJBLogo() {
        return this.getDisabledIcon(AllIcons.Plugins.ModifierJBLogo);
    }

    @NotNull
    protected Icon getJBLogo2x() {
        return this.getScaled2xIcon(AllIcons.Plugins.ModifierJBLogo);
    }

    @NotNull
    protected Icon getErrorLogo2x() {
        return this.getScaled2xIcon(AllIcons.Plugins.ModifierInvalid);
    }

    @NotNull
    protected Icon getDisabledJBLogo2x(@NotNull Icon jbLogo2x) {
        return this.getDisabledIcon(jbLogo2x);
    }

    @Override
    @NotNull
    public Icon getIcon(boolean big, boolean jb, boolean error, boolean disabled) {
        if (jb && !error) {
            if (big) {
                return disabled ? this.myPluginLogoDisabledJB_80 : this.myPluginLogoJB_80;
            }
            return disabled ? this.myPluginLogoDisabledJB_40 : this.myPluginLogoJB_40;
        }
        if (!jb && error) {
            if (big) {
                return disabled ? this.myPluginLogoDisabledError_80 : this.myPluginLogoError_80;
            }
            return disabled ? this.myPluginLogoDisabledError_40 : this.myPluginLogoError_40;
        }
        if (jb) {
            if (big) {
                return disabled ? this.myPluginLogoDisabledJBError_80 : this.myPluginLogoJBError_80;
            }
            return disabled ? this.myPluginLogoDisabledJBError_40 : this.myPluginLogoJBError_40;
        }
        if (big) {
            return disabled ? this.myPluginLogoDisabled_80 : this.myPluginLogo_80;
        }
        return disabled ? this.myPluginLogoDisabled_40 : this.myPluginLogo_40;
    }
}

