/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginSiteUtils {
    private static final Pattern TAG_PATTERN = Pattern.compile("</?\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[\\^'\">\\s]+))?)+\\s*|\\s*)/?>");
    private static final int SHORT_DESC_SIZE = 170;
    private static final Pattern BR_PATTERN = Pattern.compile("<br\\s*/?>");

    @Nullable
    public static String preparePluginDescription(@Nullable String s, boolean shortSize) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String description = PluginSiteUtils.prepareDescription(s, shortSize);
        return description.isEmpty() || description.endsWith(".") ? description : description + ".";
    }

    @NotNull
    private static String prepareDescription(@NotNull String s, boolean shortSize) {
        String[] sanitize;
        String[] split;
        if (shortSize && (split = BR_PATTERN.split(s)).length > 1 && (sanitize = PluginSiteUtils.stripTags(split[0])).length() <= 170) {
            return sanitize;
        }
        String stripped = PluginSiteUtils.stripTags(s);
        if (shortSize) {
            for (String sep : new String[]{". ", ".\n", ": ", ":\n"}) {
                String by = PluginSiteUtils.substringBy(stripped, sep);
                if (by == null) continue;
                return by;
            }
            if (stripped.length() > 170) {
                int index = (stripped = stripped.substring(0, 170)).lastIndexOf(32);
                if (index == -1) {
                    index = stripped.length();
                }
                stripped = stripped.substring(0, index) + "...";
            }
        }
        return stripped;
    }

    @Nullable
    private static String substringBy(@NotNull String str, @NotNull String separator) {
        int end = str.indexOf(separator);
        if (end > 0 && end <= 170) {
            return str.substring(0, end + (separator.contains(":") ? 0 : separator.length())).trim();
        }
        return null;
    }

    @NotNull
    private static String stripTags(@NotNull String s) {
        return TAG_PATTERN.matcher(s).replaceAll("").trim();
    }
}

