/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static Collection<PluginDownloader> myCache;
    private static boolean myPrepared;
    private static boolean myPreparing;
    private Consumer<Integer> myTreeCallback;
    private Consumer<Integer> myTabCallback;
    private Consumer<Collection<PluginDownloader>> myInstalledPanelCallback;
    private Consumer<Collection<PluginDownloader>> myUpdatePanelCallback;

    @NotNull
    public static PluginUpdatesService connectTreeRenderer(@NotNull Consumer<Integer> callback2) {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service2 = new PluginUpdatesService();
        SERVICES.add(service2);
        service2.myTreeCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        return service2;
    }

    @NotNull
    public static PluginUpdatesService connectConfigurable(@NotNull Consumer<Integer> callback2) {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service2 = new PluginUpdatesService();
        SERVICES.add(service2);
        service2.myTabCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        return service2;
    }

    public void connectInstalled(@NotNull Consumer<Collection<PluginDownloader>> callback2) {
        PluginUpdatesService.checkAccess();
        this.myInstalledPanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void calculateUpdates(@NotNull Consumer<Collection<PluginDownloader>> callback2) {
        PluginUpdatesService.checkAccess();
        this.myUpdatePanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void finishUpdate(@NotNull IdeaPluginDescriptor descriptor) {
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Iterator<PluginDownloader> I = myCache.iterator();
        while (I.hasNext()) {
            PluginDownloader downloader = I.next();
            if (downloader.getDescriptor() != descriptor) continue;
            I.remove();
            Integer countValue = PluginUpdatesService.getCount();
            for (PluginUpdatesService service2 : SERVICES) {
                service2.runCountCallbacks(countValue);
            }
            return;
        }
    }

    public void recalculateUpdates() {
        PluginUpdatesService.checkAccess();
        assert (!myPreparing);
        Integer countValue = -1;
        for (PluginUpdatesService service2 : SERVICES) {
            service2.runCountCallbacks(countValue);
            if (service2.myInstalledPanelCallback == null) continue;
            service2.myInstalledPanelCallback.accept(null);
        }
        PluginUpdatesService.calculateUpdates();
    }

    public void dispose() {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService.dispose(this);
    }

    private static void dispose(@NotNull PluginUpdatesService service2) {
        SERVICES.remove(service2);
        if (SERVICES.isEmpty()) {
            myCache = null;
            myPrepared = false;
            myPreparing = false;
        }
    }

    private static void calculateUpdates() {
        if (myPreparing) {
            return;
        }
        myPreparing = true;
        myCache = null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Collection<PluginDownloader> updates = UpdateChecker.getPluginUpdates();
            ApplicationManager.getApplication().invokeLater(() -> {
                PluginUpdatesService.checkAccess();
                myPreparing = false;
                myPrepared = true;
                myCache = updates;
                Integer countValue = PluginUpdatesService.getCount();
                for (PluginUpdatesService service2 : SERVICES) {
                    service2.runAllCallbacks(countValue);
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable Integer countValue) {
        this.runCountCallbacks(countValue);
        if (this.myInstalledPanelCallback != null) {
            this.myInstalledPanelCallback.accept(myCache);
        }
        if (this.myUpdatePanelCallback != null) {
            this.myUpdatePanelCallback.accept(myCache);
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myTreeCallback != null) {
            this.myTreeCallback.accept(countValue);
        }
        if (this.myTabCallback != null) {
            this.myTabCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount() {
        return myCache == null ? null : new Integer(myCache.size());
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }
}

