/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PluginsGroupComponent
extends JBPanelWithEmptyText {
    private final EventHandler myEventHandler;
    private final LinkListener<IdeaPluginDescriptor> myListener;
    private final LinkListener<String> mySearchListener;
    private final Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent> myFunction;
    private final List<UIPluginGroup> myGroups = new ArrayList<UIPluginGroup>();
    private static final Color SECTION_HEADER_FOREGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.foreground", (Color)new JBColor(0x787878, 0x999999));
    private static final Color SECTION_HEADER_BACKGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.background", (Color)new JBColor(0xF7F7F7, 3948353));

    public PluginsGroupComponent(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent> function) {
        super(layout);
        this.myEventHandler = eventHandler;
        this.myListener = listener2;
        this.mySearchListener = searchListener;
        this.myFunction = function;
        this.myEventHandler.connect(this);
        this.setOpaque(true);
        this.setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
    }

    @NotNull
    public List<UIPluginGroup> getGroups() {
        return this.myGroups;
    }

    @NotNull
    public List<CellPluginComponent> getSelection() {
        return this.myEventHandler.getSelection();
    }

    public void setSelection(@NotNull CellPluginComponent component) {
        this.myEventHandler.setSelection(component);
    }

    public void setSelection(@NotNull List<CellPluginComponent> components) {
        this.myEventHandler.setSelection(components);
    }

    public void addGroup(@NotNull PluginsGroup group) {
        this.addGroup(group, -1);
    }

    public void addGroup(@NotNull PluginsGroup group, int groupIndex) {
        this.addGroup(group, group.descriptors, groupIndex);
    }

    public void addLazyGroup(final @NotNull PluginsGroup group, final @NotNull JScrollBar scrollBar, final int gapSize, final @NotNull Runnable uiCallback) {
        if (group.descriptors.size() <= gapSize) {
            this.addGroup(group);
        } else {
            this.addGroup(group, group.descriptors.subList(0, gapSize), -1);
            AdjustmentListener listener2 = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (scrollBar.getValue() + scrollBar.getVisibleAmount() >= scrollBar.getMaximum()) {
                        int fromIndex = group.ui.plugins.size();
                        int toIndex = Math.min(fromIndex + gapSize, group.descriptors.size());
                        int uiIndex = PluginsGroupComponent.this.getComponentIndex(group.ui.plugins.get(fromIndex - 1));
                        PluginLogo.startBatchMode();
                        PluginsGroupComponent.this.addToGroup(group, group.descriptors.subList(fromIndex, toIndex), uiIndex);
                        PluginLogo.endBatchMode();
                        if (group.descriptors.size() == group.ui.plugins.size()) {
                            scrollBar.removeAdjustmentListener(this);
                            group.clearCallback = null;
                        }
                        uiCallback.run();
                    }
                }
            };
            group.clearCallback = () -> scrollBar.removeAdjustmentListener(listener2);
            scrollBar.addAdjustmentListener(listener2);
        }
    }

    private void addGroup(@NotNull PluginsGroup group, @NotNull List<IdeaPluginDescriptor> descriptors, int groupIndex) {
        int index;
        UIPluginGroup uiGroup;
        group.ui = uiGroup = new UIPluginGroup();
        this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
        OpaquePanel panel2 = new OpaquePanel((LayoutManager)new BorderLayout(), SECTION_HEADER_BACKGROUND);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JLabel title = new JLabel(group.title){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Container parent = this.getParent();
                Insets insets = parent.getInsets();
                size.width = Math.min(parent.getWidth() - insets.left - insets.right - (parent.getComponentCount() == 2 ? parent.getComponent(1).getWidth() + JBUI.scale((int)20) : 0), size.width);
                return size;
            }

            @Override
            public String getToolTipText() {
                return super.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
        };
        title.setToolTipText(group.title);
        title.setForeground(SECTION_HEADER_FOREGROUND);
        panel2.add((Component)title, (Object)"West");
        group.titleLabel = title;
        if (group.rightAction != null) {
            panel2.add(group.rightAction, (Object)"East");
        }
        if (groupIndex == 0) {
            this.add((Component)panel2, 0);
            index = 1;
        } else if (groupIndex == -1) {
            this.add((Component)panel2);
            index = -1;
        } else {
            Component anchorPanel = this.myGroups.get((int)(groupIndex + 1)).panel;
            int components = this.getComponentCount();
            index = -1;
            for (int i = 0; i < components; ++i) {
                if (this.getComponent(i) != anchorPanel) continue;
                index = i;
                break;
            }
            assert (index != -1);
            this.add((Component)panel2, index++);
        }
        uiGroup.panel = panel2;
        this.addToGroup(group, descriptors, index);
    }

    private void addToGroup(@NotNull PluginsGroup group, @NotNull List<IdeaPluginDescriptor> descriptors, int index) {
        for (IdeaPluginDescriptor descriptor : descriptors) {
            CellPluginComponent pluginComponent = (CellPluginComponent)this.myFunction.fun((Object)descriptor);
            group.ui.plugins.add(pluginComponent);
            this.add(pluginComponent, index);
            this.myEventHandler.addCell(pluginComponent, index);
            pluginComponent.setListeners(this.myListener, this.mySearchListener, this.myEventHandler);
            if (index == -1) continue;
            ++index;
        }
    }

    public void addToGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor) {
        int index = group.addWithIndex(descriptor);
        CellPluginComponent anchor2 = null;
        int uiIndex = -1;
        if (index == group.ui.plugins.size()) {
            int groupIndex = this.myGroups.indexOf(group.ui);
            if (groupIndex < this.myGroups.size() - 1) {
                UIPluginGroup nextGroup = this.myGroups.get(groupIndex + 1);
                anchor2 = nextGroup.plugins.get(0);
                uiIndex = this.getComponentIndex(nextGroup.panel);
            }
        } else {
            anchor2 = group.ui.plugins.get(index);
            uiIndex = this.getComponentIndex(anchor2);
        }
        CellPluginComponent pluginComponent = (CellPluginComponent)this.myFunction.fun((Object)descriptor);
        group.ui.plugins.add(index, pluginComponent);
        this.add(pluginComponent, uiIndex);
        this.myEventHandler.addCell(pluginComponent, anchor2);
        pluginComponent.setListeners(this.myListener, this.mySearchListener, this.myEventHandler);
    }

    public void removeGroup(@NotNull PluginsGroup group) {
        this.myGroups.remove(group.ui);
        this.remove(group.ui.panel);
        for (CellPluginComponent plugin : group.ui.plugins) {
            plugin.close();
            this.remove(plugin);
            this.myEventHandler.removeCell(plugin);
        }
        group.clear();
    }

    public void removeFromGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor) {
        int index = ContainerUtil.indexOf(group.ui.plugins, component -> component.myPlugin == descriptor);
        assert (index != -1);
        CellPluginComponent component2 = group.ui.plugins.remove(index);
        component2.close();
        this.remove(component2);
        this.myEventHandler.removeCell(component2);
        group.descriptors.remove(descriptor);
    }

    private int getComponentIndex(@NotNull Component component) {
        int components = this.getComponentCount();
        for (int i = 0; i < components; ++i) {
            if (this.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        for (UIPluginGroup group : this.myGroups) {
            for (CellPluginComponent plugin : group.plugins) {
                plugin.close();
            }
        }
        this.myGroups.clear();
        this.myEventHandler.clear();
        this.removeAll();
    }

    public void initialSelection() {
        this.initialSelection(true);
    }

    public void initialSelection(boolean scrollAndFocus) {
        SwingUtilities.invokeLater(() -> {
            this.myEventHandler.initialSelection(scrollAndFocus);
            if (!this.myGroups.isEmpty()) {
                this.scrollRectToVisible(this.myGroups.get((int)0).panel.getBounds());
            }
        });
    }
}

