/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PluginsGroupComponentWithProgress
extends PluginsGroupComponent {
    private AsyncProcessIcon myIcon = new CenteredIcon();
    private Runnable myVisibleRunnable;

    public PluginsGroupComponentWithProgress(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent> function) {
        super(layout, eventHandler, listener2, searchListener, function);
        this.myIcon.setOpaque(false);
        this.myIcon.setPaintPassiveIcon(false);
        this.add((Component)this.myIcon);
        this.myIcon.resume();
    }

    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.updateIconLocation();
    }

    private void updateIconLocation() {
        if (this.myIcon != null && this.myIcon.isVisible()) {
            this.myIcon.updateLocation((JComponent)((Object)this));
        }
    }

    public void startLoading() {
        if (this.myIcon != null) {
            this.myIcon.setVisible(true);
            this.myIcon.resume();
            this.fullRepaint();
        }
    }

    public void stopLoading() {
        if (this.myIcon != null) {
            this.myIcon.suspend();
            this.myIcon.setVisible(false);
            this.fullRepaint();
        }
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        if (this.myIcon != null) {
            this.remove((Component)this.myIcon);
            Disposer.dispose((Disposable)this.myIcon);
            this.myIcon = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.myIcon != null) {
            this.add((Component)this.myIcon);
        }
    }

    public void setVisibleRunnable(@NotNull Runnable visibleRunnable) {
        this.myVisibleRunnable = visibleRunnable;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag && this.myVisibleRunnable != null) {
            Runnable runnable2 = this.myVisibleRunnable;
            this.myVisibleRunnable = null;
            runnable2.run();
        }
    }

    private static class CenteredIcon
    extends AsyncProcessIcon.Big {
        CenteredIcon() {
            super("Loading");
        }

        @NotNull
        protected Rectangle calculateBounds(@NotNull JComponent container) {
            Dimension size = container.getSize();
            Dimension iconSize = this.getPreferredSize();
            return new Rectangle((size.width - iconSize.width) / 2, (size.height - iconSize.height) / 2, iconSize.width, iconSize.height);
        }
    }
}

