/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchPopupController {
    private final PluginSearchTextField myTextField;
    protected SearchPopup myPopup;
    private final JBPopupListener mySearchPopupListener = new JBPopupAdapter(){

        public void onClosed(@NotNull LightweightWindowEvent event) {
            SearchPopupController.this.myPopup = null;
        }
    };

    public SearchPopupController(@NotNull PluginSearchTextField searchTextField) {
        this.myTextField = searchTextField;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleShowPopup() {
        String query = this.myTextField.getText();
        int length = query.length();
        int position = this.getCaretPosition();
        if (position < length) {
            if (query.charAt(position) != ' ') {
                this.hidePopup();
                this.handleAppendToQuery();
                return;
            }
            if (position == 0 || query.charAt(position - 1) == ' ') {
                this.showAttributesPopup(null, position);
                return;
            }
        } else if (query.charAt(position - 1) == ' ') {
            this.showAttributesPopup(null, position);
            return;
        }
        Ref startPosition = new Ref();
        Pair<String, String> attribute = SearchPopupController.parseAttributeInQuery(query, position, (Ref<Integer>)startPosition);
        if (attribute.second == null) {
            this.showAttributesPopup((String)attribute.first, (Integer)startPosition.get());
            return;
        }
        this.handleShowAttributeValuesPopup((String)attribute.first, (String)attribute.second, (Integer)startPosition.get());
    }

    private int getCaretPosition() {
        return this.myTextField.getTextEditor().getCaretPosition();
    }

    @NotNull
    private static Pair<String, String> parseAttributeInQuery(@NotNull String query, int end, @NotNull Ref<Integer> startPosition) {
        int index;
        String value = null;
        for (index = end - 1; index >= 0; --index) {
            char ch = query.charAt(index);
            if (ch == ':') {
                value = query.substring(index + 1, end);
                startPosition.set((Object)(index + 1));
                end = index + 1;
                --index;
                while (index >= 0 && query.charAt(index) != ' ') {
                    --index;
                }
                break;
            }
            if (ch == ' ') break;
        }
        String name = StringUtil.trimStart((String)query.substring(index + 1, end), (String)"-");
        if (startPosition.isNull()) {
            startPosition.set((Object)(index + (query.charAt(index + 1) == '-' ? 2 : 1)));
        }
        return Pair.create((Object)name, (Object)value);
    }

    public void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async;
        CollectionListModel model = new CollectionListModel(this.getAttributes());
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model, namePrefix)) {
            return;
        }
        boolean bl = async = this.myPopup != null;
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeName, (CollectionListModel<Object>)model, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async, new SearchPopupCallback(namePrefix){

            public void consume(String value) {
                SearchPopupController.this.appendSearchText(value, this.prefix);
                SearchPopupController.this.handleShowAttributeValuesPopup(value, null, SearchPopupController.this.getCaretPosition());
            }
        });
    }

    private void handleShowAttributeValuesPopup(@NotNull String name, @Nullable String valuePrefix, int caretPosition) {
        List<String> values = this.getValues(name);
        if (ContainerUtil.isEmpty(values)) {
            this.showPopupForQuery();
            return;
        }
        CollectionListModel model = new CollectionListModel(values);
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model, valuePrefix)) {
            return;
        }
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeValue, (CollectionListModel<Object>)model, valuePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(true, new SearchPopupCallback(valuePrefix){

            public void consume(String value) {
                if (StringUtil.containsAnyChar((String)value, (String)" ,:")) {
                    value = "\"" + value + "\"";
                }
                SearchPopupController.this.appendSearchText(value, this.prefix);
                SearchPopupController.this.handleAppendAttributeValue();
            }
        });
    }

    private boolean updatePopupOrCreate(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model, @Nullable String prefix, int caretPosition) {
        if (this.myPopup != null && this.myPopup.type == type && this.myPopup.isValid()) {
            this.myPopup.model.replaceAll(model.getItems());
            this.myPopup.callback.prefix = prefix;
            this.myPopup.caretPosition = caretPosition;
            this.myPopup.update();
            return true;
        }
        this.createPopup(type, model, caretPosition);
        return false;
    }

    protected void createPopup(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model, int caretPosition) {
        this.hidePopup();
        this.myPopup = new SearchPopup(this.myTextField, this.mySearchPopupListener, type, model, caretPosition);
    }

    private void createAndShow(boolean async, @NotNull SearchPopupCallback callback2) {
        ColoredListCellRenderer renderer2 = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)value);
            }
        };
        this.myPopup.createAndShow(callback2, renderer2, async);
    }

    private boolean noPrefixSearchValues(@NotNull CollectionListModel<Object> model, @Nullable String prefix) {
        if (StringUtil.isEmptyOrSpaces((String)prefix)) {
            return false;
        }
        int index = 0;
        while (index < model.getSize()) {
            String attribute = (String)model.getElementAt(index);
            if (attribute.equals(prefix)) {
                this.hidePopup();
                return true;
            }
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)prefix)) {
                ++index;
                continue;
            }
            model.remove(index);
        }
        if (model.isEmpty()) {
            this.showPopupForQuery();
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract List<String> getAttributes();

    @Nullable
    protected abstract List<String> getValues(@NotNull String var1);

    protected abstract void showPopupForQuery();

    protected void handleAppendToQuery() {
    }

    protected void handleAppendAttributeValue() {
    }

    public boolean isPopupShow() {
        return this.myPopup != null && this.myPopup.isValid();
    }

    public void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide();
            this.myPopup = null;
        }
    }

    private void appendSearchText(@NotNull String value, @Nullable String prefix) {
        String text = this.myTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.myPopup != null) {
            this.myPopup.skipCaretEvent = true;
        }
        if (position < text.length()) {
            suffix = text.substring(position);
            text = text.substring(0, position);
        }
        if (prefix == null) {
            this.myTextField.setTextIgnoreEvents(text + value + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value, (String)prefix) || StringUtil.startsWithIgnoreCase((String)value, (String)("\"" + prefix))) {
            this.myTextField.setTextIgnoreEvents(text.substring(0, text.length() - prefix.length()) + value + suffix);
        } else {
            this.myTextField.setTextIgnoreEvents(text + value + suffix);
        }
        this.myTextField.getTextEditor().setCaretPosition(this.myTextField.getText().length() - suffix.length());
    }

    public boolean handleEnter(@NotNull KeyEvent event) {
        if (this.myPopup != null && this.myPopup.list != null && this.myPopup.list.getSelectedIndex() != -1) {
            this.myPopup.list.dispatchEvent(event);
            return true;
        }
        this.handleEnter();
        return false;
    }

    protected void handleEnter() {
    }

    public boolean handleUpDown(@NotNull KeyEvent event) {
        if (this.myPopup != null && this.myPopup.list != null) {
            if (event.getKeyCode() == 40 && this.myPopup.list.getSelectedIndex() == -1) {
                this.myPopup.list.setSelectedIndex(0);
                this.handlePopupListFirstSelection();
            } else {
                this.myPopup.list.dispatchEvent(event);
            }
        }
        return false;
    }

    protected void handlePopupListFirstSelection() {
    }
}

