/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchQueryParser {
    public String searchQuery;

    @NotNull
    public static List<String> split(@NotNull String name, @Nullable String query) {
        int end;
        ArrayList<String> result2 = new ArrayList<String>();
        if (query == null) {
            result2.add(name);
            return result2;
        }
        int length = name.length();
        int queryLength = query.length();
        int index = 0;
        while ((end = StringUtil.indexOfIgnoreCase((String)name, (String)query, (int)index)) != -1) {
            result2.add(name.substring(index, end));
            index = end + queryLength;
            result2.add(name.substring(end, index));
        }
        if (index < length) {
            result2.add(name.substring(index));
        }
        return result2;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query) {
        ArrayList<String> words = new ArrayList<String>();
        int length = query.length();
        int index = 0;
        block0: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query.indexOf(34, index);
                if (end == -1) break;
                words.add(query.substring(index, end));
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index < length) {
                char nextCh;
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                words.add(query.substring(start2, nextCh == ' ' ? index - 1 : index));
                continue block0;
            }
        }
        if (words.isEmpty() && length > 0) {
            words.add(query);
        }
        return words;
    }

    protected final void parse(@NotNull String query) {
        List<String> words = SearchQueryParser.splitQuery(query);
        int size = words.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.searchQuery = words.get(0);
            return;
        }
        int index = 0;
        while (index < size) {
            String name;
            if ((name = words.get(index++)).endsWith(":")) {
                if (index < size) {
                    boolean invert2 = name.startsWith("-");
                    name = name.substring(invert2 ? 1 : 0, name.length() - 1);
                    this.handleAttribute(name, words.get(index++), invert2);
                    continue;
                }
                this.searchQuery = query;
                return;
            }
            if (this.searchQuery == null) {
                this.searchQuery = name;
                continue;
            }
            this.searchQuery = query;
            return;
        }
    }

    protected abstract void handleAttribute(@NotNull String var1, @NotNull String var2, boolean var3);

    @NotNull
    public static String getTagQuery(@NotNull String tag) {
        return "tag:" + (tag.indexOf(32) == -1 ? tag : StringUtil.wrapWithDoubleQuote((String)tag));
    }

    public static class Installed
    extends SearchQueryParser {
        public Boolean enabled;
        public Boolean bundled;
        public Boolean invalid;
        public Boolean needUpdate;
        public Boolean deleted;
        public Boolean needRestart;
        public final boolean attributes;

        public Installed(@NotNull String query) {
            for (String word : Installed.splitQuery(query)) {
                if (word.startsWith("#")) {
                    this.handleAttribute(word.substring(1), "", false);
                    continue;
                }
                if (word.startsWith("-#")) {
                    this.handleAttribute(word.substring(2), "", true);
                    continue;
                }
                if (this.searchQuery == null) {
                    this.searchQuery = word;
                    continue;
                }
                this.searchQuery = query;
                break;
            }
            this.attributes = this.enabled != null || this.bundled != null || this.invalid != null || this.needUpdate != null || this.deleted != null || this.needRestart != null;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert2) {
            switch (name) {
                case "enabled": {
                    this.enabled = !invert2;
                    break;
                }
                case "disabled": {
                    this.enabled = invert2;
                    break;
                }
                case "bundled": {
                    this.bundled = !invert2;
                    break;
                }
                case "custom": {
                    this.bundled = invert2;
                    break;
                }
                case "invalid": {
                    this.invalid = !invert2;
                    break;
                }
                case "outdated": {
                    this.needUpdate = !invert2;
                    break;
                }
                case "uninstalled": {
                    this.deleted = !invert2;
                    break;
                }
                case "inactive": {
                    this.needRestart = !invert2;
                }
            }
        }
    }

    public static class Trending
    extends SearchQueryParser {
        public final Set<String> tags = new HashSet<String>();
        public final Set<String> repositories = new HashSet<String>();
        public String sortBy;

        public Trending(@NotNull String query) {
            this.parse(query);
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if ("featured".equals(this.sortBy)) {
                url.append("is_featured_search=true");
            } else if ("updated".equals(this.sortBy)) {
                url.append("orderBy=update+date");
            } else if ("downloads".equals(this.sortBy)) {
                url.append("orderBy=downloads");
            } else if ("rating".equals(this.sortBy)) {
                url.append("orderBy=rating");
            } else if ("name".equals(this.sortBy)) {
                url.append("orderBy=name");
            }
            for (String tag : this.tags) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag));
            }
            if (this.searchQuery != null) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            return url.toString();
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert2) {
            if (name.equals("tag")) {
                this.tags.add(value);
            } else if (name.equals("sortBy")) {
                this.sortBy = value;
            } else if (name.equals("repository")) {
                this.repositories.add(value);
            }
        }
    }
}

