/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.SearchPopupController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchResultPanel {
    public final SearchPopupController controller;
    public final int tabIndex;
    public final int backTabIndex;
    protected final PluginsGroupComponent myPanel;
    private JScrollBar myVerticalScrollBar;
    private final PluginsGroup myGroup = new PluginsGroup("Search Results");
    private String myQuery;
    private AtomicBoolean myRunQuery;
    private boolean myEmpty = true;

    public SearchResultPanel(@Nullable SearchPopupController controller, @NotNull PluginsGroupComponent panel2, int tabIndex, int backTabIndex) {
        this.controller = controller;
        this.myPanel = panel2;
        this.tabIndex = tabIndex;
        this.backTabIndex = backTabIndex;
        this.setEmptyText();
        if (this.isProgressMode()) {
            this.loading(false);
        }
    }

    @NotNull
    public JComponent createScrollPane() {
        JBScrollPane pane = new JBScrollPane((Component)((Object)this.myPanel));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (this.isProgressMode()) {
            this.myVerticalScrollBar = pane.getVerticalScrollBar();
        }
        return pane;
    }

    private void setEmptyText() {
        this.myPanel.getEmptyText().setText("Nothing to show");
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public void setEmpty() {
        this.myEmpty = true;
    }

    @NotNull
    public String getQuery() {
        return StringUtil.defaultIfEmpty((String)this.myQuery, (String)"");
    }

    public void setQuery(@NotNull String query) {
        this.setEmptyText();
        if (query.equals(this.myQuery)) {
            this.myEmpty = query.isEmpty();
            return;
        }
        if (this.myRunQuery != null) {
            this.myRunQuery.set(false);
            this.myRunQuery = null;
            this.loading(false);
        }
        this.removeGroup();
        this.myQuery = query;
        this.myEmpty = query.isEmpty();
        if (!this.myEmpty) {
            this.handleQuery(query);
        }
    }

    private void handleQuery(@NotNull String query) {
        this.myGroup.clear();
        if (this.isProgressMode()) {
            this.loading(true);
            AtomicBoolean runQuery = this.myRunQuery = new AtomicBoolean(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.handleQuery(this.myQuery, this.myGroup);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!runQuery.get()) {
                        return;
                    }
                    this.myRunQuery = null;
                    this.loading(false);
                    if (!this.myGroup.descriptors.isEmpty()) {
                        this.myGroup.titleWithCount();
                        PluginLogo.startBatchMode();
                        this.myPanel.addLazyGroup(this.myGroup, this.myVerticalScrollBar, 100, this::fullRepaint);
                        PluginLogo.endBatchMode();
                    }
                    this.myPanel.initialSelection(false);
                    this.fullRepaint();
                }, ModalityState.any());
            });
        } else {
            this.handleQuery(query, this.myGroup);
            if (!this.myGroup.descriptors.isEmpty()) {
                this.myPanel.addGroup(this.myGroup);
                this.myGroup.titleWithCount();
                this.myPanel.initialSelection(false);
            }
            this.fullRepaint();
        }
    }

    protected abstract void handleQuery(@NotNull String var1, @NotNull PluginsGroup var2);

    private void loading(boolean start2) {
        PluginsGroupComponentWithProgress panel2 = (PluginsGroupComponentWithProgress)this.myPanel;
        if (start2) {
            panel2.startLoading();
        } else {
            panel2.stopLoading();
        }
    }

    public void dispose() {
        if (this.isProgressMode()) {
            ((PluginsGroupComponentWithProgress)this.myPanel).dispose();
        }
    }

    private boolean isProgressMode() {
        return this.myPanel instanceof PluginsGroupComponentWithProgress;
    }

    private void removeGroup() {
        if (this.myGroup.ui != null) {
            this.myPanel.removeGroup(this.myGroup);
            this.fullRepaint();
        }
    }

    private void fullRepaint() {
        this.myPanel.doLayout();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }
}

