/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.TabHeaderListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TabHeaderComponent
extends JComponent {
    private final List<Computable<String>> myTabs = new ArrayList<Computable<String>>();
    private final JComponent myToolbarComponent;
    private final TabHeaderListener myListener;
    private int mySelectionTab = -1;
    private int myHoverTab = -1;
    private SizeInfo mySizeInfo;
    private int myBaselineY;
    private Breadcrumbs myBreadcrumbs;
    private Color mySelectedForeground;
    private static final Color SELECTED_BG_COLOR = JBColor.namedColor((String)"Plugins.Tab.selectedBackground", (Color)JBUI.CurrentTheme.ToolWindow.tabSelectedBackground());
    private static final Color HOVER_BG_COLOR = JBColor.namedColor((String)"Plugins.Tab.hoverBackground", (Color)JBUI.CurrentTheme.ToolWindow.tabHoveredBackground());

    public TabHeaderComponent(@NotNull DefaultActionGroup actions, @NotNull TabHeaderListener listener2) {
        this.myListener = listener2;
        this.myToolbarComponent = TabHeaderComponent.createToolbar(actions);
        this.add(this.myToolbarComponent);
        this.setBackground(JBUI.CurrentTheme.ToolWindow.headerBackground());
        this.setOpaque(true);
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int tab;
                if (SwingUtilities.isLeftMouseButton(event) && (tab = TabHeaderComponent.this.findTab(event)) != -1 && tab != TabHeaderComponent.this.mySelectionTab) {
                    TabHeaderComponent.this.setSelectionWithEvents(tab);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (TabHeaderComponent.this.myHoverTab != -1) {
                    TabHeaderComponent.this.myHoverTab = -1;
                    TabHeaderComponent.this.fullRepaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                int tab = TabHeaderComponent.this.findTab(event);
                if (tab != -1 && tab != TabHeaderComponent.this.myHoverTab) {
                    TabHeaderComponent.this.myHoverTab = tab;
                    TabHeaderComponent.this.fullRepaint();
                }
            }
        };
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addTabSelectionAction("NextTab", () -> this.setSelectionWithEvents(this.mySelectionTab == this.myTabs.size() - 1 ? 0 : this.mySelectionTab + 1));
        this.addTabSelectionAction("PreviousTab", () -> this.setSelectionWithEvents(this.mySelectionTab == 0 ? this.myTabs.size() - 1 : this.mySelectionTab - 1));
    }

    private void addTabSelectionAction(@NotNull String actionId, @NotNull Runnable callback2) {
        EventHandler.addGlobalAction(this, actionId, () -> {
            if (!this.myTabs.isEmpty()) {
                callback2.run();
            }
        });
    }

    @NotNull
    private static JComponent createToolbar(final @NotNull DefaultActionGroup actions) {
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("NavBarToolbar", (ActionGroup)toolbarActionGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutPolicy(0);
        final JComponent toolbarComponent = toolbar.getComponent();
        toolbarActionGroup.add((AnAction)new DumbAwareAction(null, "Manage Repositories, Configure Proxy or Install Plugin from Disk", AllIcons.General.GearPlain){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ListPopup actionGroupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions, e.getDataContext(), true, null, Integer.MAX_VALUE);
                HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)actionGroupPopup);
                actionGroupPopup.show(new RelativePoint((Component)toolbarComponent, this.getPopupPoint()));
            }

            private Point getPopupPoint() {
                int dH = UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)1) : 0;
                return new Point(JBUI.scale((int)2), toolbarComponent.getHeight() - dH);
            }
        });
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        return toolbarComponent;
    }

    public void addTab(@NotNull String title) {
        this.addTab((Computable<String>)((Computable)() -> title));
    }

    public void addTab(@NotNull Computable<String> titleComputable) {
        this.myTabs.add(titleComputable);
        this.update();
    }

    public void update() {
        this.mySizeInfo = null;
        this.fullRepaint();
    }

    private void fullRepaint() {
        Container parent = (Container)ObjectUtils.notNull((Object)this.getParent(), (Object)this);
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    public int getSelectionTab() {
        return this.mySelectionTab;
    }

    public void clearSelection() {
        this.setSelection(-1);
    }

    public void setSelection(int index) {
        this.mySelectionTab = index < 0 ? -1 : (index >= this.myTabs.size() ? this.myTabs.size() - 1 : index);
        this.fullRepaint();
    }

    public void setSelectionWithEvents(int index) {
        this.mySelectionTab = index;
        this.myListener.selectionChanged(index);
        this.fullRepaint();
    }

    @NotNull
    public Point getTabLocation(@NotNull String tabTitle) {
        this.calculateSize();
        for (int i = 0; i < this.myTabs.size(); ++i) {
            if (!((String)this.myTabs.get(i).compute()).equals(tabTitle)) continue;
            Point point = this.mySizeInfo.tabs[i].getLocation();
            return new Point(this.getStartX() + point.x, point.y);
        }
        throw new IllegalArgumentException("Tab " + tabTitle + " not found");
    }

    private int findTab(@NotNull MouseEvent event) {
        this.calculateSize();
        int x = this.getStartX();
        int height = this.getHeight();
        int eventX = event.getX();
        int eventY = event.getY();
        int size = this.myTabs.size();
        for (int i = 0; i < size; ++i) {
            Rectangle bounds2 = this.mySizeInfo.tabs[i];
            if (!new Rectangle(x + bounds2.x, 0, bounds2.width, height).contains(eventX, eventY)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private Color getSelectedForeground() {
        if (this.mySelectedForeground == null) {
            this.mySelectedForeground = JBColor.namedColor((String)"Plugins.Tab.selectedForeground", (Color)this.getForeground());
        }
        return this.mySelectedForeground;
    }

    @Override
    protected void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        g.setFont(this.getFont());
        super.paintComponent(g);
        this.calculateSize();
        int x = this.getStartX();
        int height = this.getHeight();
        int tabTitleY = this.getBaseline(-1, -1);
        int size = this.myTabs.size();
        for (int i = 0; i < size; ++i) {
            if (this.mySelectionTab == i || this.myHoverTab == i) {
                Rectangle bounds2 = this.mySizeInfo.tabs[i];
                g.setColor(this.mySelectionTab == i ? SELECTED_BG_COLOR : HOVER_BG_COLOR);
                g.fillRect(x + bounds2.x, 0, bounds2.width, height);
                g.setColor(this.mySelectionTab == i ? this.getSelectedForeground() : this.getForeground());
            }
            g.drawString((String)this.myTabs.get(i).compute(), x + this.mySizeInfo.tabTitleX[i], tabTitleY);
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int tabTitleY = fm.getAscent() + (this.getHeight() - fm.getHeight()) / 2;
        if (this.myBreadcrumbs != null) {
            tabTitleY = this.myBaselineY + Math.max(this.myBreadcrumbs.getBaseline(-1, -1), 0);
        }
        return tabTitleY;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.myBaselineY = y;
        super.setBounds(x, 0, width, height += y);
        if (this.myBreadcrumbs == null) {
            this.myBreadcrumbs = (Breadcrumbs)UIUtil.findComponentOfType((JComponent)((JComponent)this.getParent()), Breadcrumbs.class);
        }
        this.calculateSize();
        Dimension size = this.myToolbarComponent.getPreferredSize();
        int toolbarX = this.getStartX() + this.mySizeInfo.toolbarX;
        int toolbarY = (height - size.height) / 2;
        this.myToolbarComponent.setBounds(toolbarX, toolbarY, size.width, size.height);
    }

    private int getStartX() {
        return (this.getParent().getWidth() - this.mySizeInfo.width) / 2 - this.getX();
    }

    @Override
    public Dimension getPreferredSize() {
        this.calculateSize();
        return new Dimension(this.mySizeInfo.width, JBUI.scale((int)30));
    }

    private void calculateSize() {
        if (this.mySizeInfo != null) {
            return;
        }
        this.mySizeInfo = new SizeInfo();
        int size = this.myTabs.size();
        this.mySizeInfo.tabs = new Rectangle[size];
        this.mySizeInfo.tabTitleX = new int[size];
        int offset = JBUI.scale((int)22);
        int x = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int i = 0; i < size; ++i) {
            int tabWidth = offset + UIUtilities.stringWidth(null, (FontMetrics)fm, (String)((String)this.myTabs.get(i).compute())) + offset;
            this.mySizeInfo.tabTitleX[i] = x + offset;
            this.mySizeInfo.tabs[i] = new Rectangle(x, 0, tabWidth, -1);
            x += tabWidth;
        }
        Dimension toolbarSize = this.myToolbarComponent.getPreferredSize();
        this.mySizeInfo.width = (x += JBUI.scale((int)10)) + toolbarSize.width;
        this.mySizeInfo.toolbarX = x;
    }

    private static class SizeInfo {
        public int width;
        public Rectangle[] tabs;
        public int[] tabTitleX;
        public int toolbarX;

        private SizeInfo() {
        }
    }
}

