/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectViewSettings
extends ViewSettings {
    public boolean isShowExcludedFiles();

    default public boolean isUseFileNestingRules() {
        return true;
    }

    public static final class Delegate
    implements ProjectViewSettings {
        private final Project project;
        private final String id;

        public Delegate(@NotNull Project project, @Nullable String id) {
            this.project = project;
            this.id = id;
        }

        @Override
        public boolean isShowExcludedFiles() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowExcludedFiles(this.getPaneID(view));
        }

        @Override
        public boolean isUseFileNestingRules() {
            ProjectViewSettings settings = this.getProjectViewSettings();
            return settings != null && settings.isUseFileNestingRules();
        }

        public boolean isFoldersAlwaysOnTop() {
            ProjectView view = this.getProjectView();
            return view != null && view.isFoldersAlwaysOnTop(this.getPaneID(view));
        }

        public boolean isShowMembers() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowMembers(this.getPaneID(view));
        }

        public boolean isStructureView() {
            return false;
        }

        public boolean isShowModules() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowModules(this.getPaneID(view));
        }

        public boolean isFlattenModules() {
            ProjectView view = this.getProjectView();
            return view != null && view.isFlattenModules(this.getPaneID(view));
        }

        public boolean isShowURL() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowURL(this.getPaneID(view));
        }

        public boolean isFlattenPackages() {
            ProjectViewDirectoryHelper helper = this.getProjectViewDirectoryHelper();
            if (helper == null || !helper.supportsFlattenPackages()) {
                return false;
            }
            ProjectView view = this.getProjectView();
            return view != null && view.isFlattenPackages(this.getPaneID(view));
        }

        public boolean isAbbreviatePackageNames() {
            ProjectView view = this.getProjectView();
            return view != null && view.isAbbreviatePackageNames(this.getPaneID(view));
        }

        public boolean isHideEmptyMiddlePackages() {
            ProjectViewDirectoryHelper helper = this.getProjectViewDirectoryHelper();
            if (helper == null || !helper.supportsHideEmptyMiddlePackages()) {
                return false;
            }
            ProjectView view = this.getProjectView();
            return view != null && view.isHideEmptyMiddlePackages(this.getPaneID(view));
        }

        public boolean isCompactDirectories() {
            ProjectView view = this.getProjectView();
            return view != null && view.isCompactDirectories(this.getPaneID(view));
        }

        public boolean isShowLibraryContents() {
            ProjectView view = this.getProjectView();
            return view != null && view.isShowLibraryContents(this.getPaneID(view));
        }

        @Nullable
        private ProjectViewDirectoryHelper getProjectViewDirectoryHelper() {
            return this.project.isDisposed() ? null : ProjectViewDirectoryHelper.getInstance(this.project);
        }

        @Nullable
        private ProjectView getProjectView() {
            return this.project.isDisposed() ? null : ProjectView.getInstance(this.project);
        }

        @Nullable
        private String getPaneID(@NotNull ProjectView view) {
            return this.id != null ? this.id : view.getCurrentViewId();
        }

        @Nullable
        private AbstractTreeStructure getStructure(@NotNull ProjectView view) {
            AbstractProjectViewPane pane = this.id == null ? view.getCurrentProjectViewPane() : view.getProjectViewPaneById(this.id);
            return pane == null ? null : pane.getTreeStructure();
        }

        @Nullable
        private ProjectViewSettings getProjectViewSettings() {
            ProjectView view = this.getProjectView();
            AbstractTreeStructure structure = view == null ? null : this.getStructure(view);
            return structure instanceof ProjectViewSettings ? (ProjectViewSettings)structure : null;
        }
    }

    public static class Immutable
    extends ViewSettings.Immutable
    implements ProjectViewSettings {
        public static final ProjectViewSettings DEFAULT = new Immutable(null);
        private final boolean myShowExcludedFiles;
        private final boolean myUseFileNestingRules;

        public Immutable(ProjectViewSettings settings) {
            super((ViewSettings)settings);
            this.myShowExcludedFiles = settings != null && settings.isShowExcludedFiles();
            this.myUseFileNestingRules = settings == null || settings.isUseFileNestingRules();
        }

        @Override
        public boolean isShowExcludedFiles() {
            return this.myShowExcludedFiles;
        }

        @Override
        public boolean isUseFileNestingRules() {
            return this.myUseFileNestingRules;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ProjectViewSettings settings = (ProjectViewSettings)object;
            return settings.isShowExcludedFiles() == this.isShowExcludedFiles() && settings.isUseFileNestingRules() == this.isUseFileNestingRules();
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + Boolean.hashCode(this.isShowExcludedFiles());
            result2 = 31 * result2 + Boolean.hashCode(this.isUseFileNestingRules());
            return result2;
        }
    }
}

