/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundProjectViewNodeDecorator
implements ProjectViewNodeDecorator {
    private static final ProjectViewNodeDecorator EMPTY = new CompoundProjectViewNodeDecorator(new ProjectViewNodeDecorator[0]);
    private static final Key<ProjectViewNodeDecorator> KEY = Key.create((String)"ProjectViewNodeDecorator");
    private static final Logger LOG = Logger.getInstance(CompoundProjectViewNodeDecorator.class);
    private final ProjectViewNodeDecorator[] decorators;

    @NotNull
    public static ProjectViewNodeDecorator get(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            return EMPTY;
        }
        ProjectViewNodeDecorator provider = (ProjectViewNodeDecorator)project.getUserData(KEY);
        if (provider != null) {
            return provider;
        }
        provider = new CompoundProjectViewNodeDecorator((ProjectViewNodeDecorator[])EP_NAME.getExtensions((AreaInstance)project));
        project.putUserData(KEY, (Object)provider);
        return provider;
    }

    public CompoundProjectViewNodeDecorator(ProjectViewNodeDecorator ... decorators) {
        this.decorators = decorators;
    }

    @Override
    public void decorate(ProjectViewNode node, PresentationData data) {
        this.forEach(decorator -> decorator.decorate(node, data));
    }

    @Override
    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        this.forEach(decorator -> decorator.decorate(node, cellRenderer));
    }

    private void forEach(@NotNull Consumer<? super ProjectViewNodeDecorator> consumer) {
        for (ProjectViewNodeDecorator decorator : this.decorators) {
            try {
                consumer.accept(decorator);
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + decorator, (Throwable)exception);
            }
        }
    }
}

