/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundTreeStructureProvider
implements TreeStructureProvider {
    private static final TreeStructureProvider EMPTY = new CompoundTreeStructureProvider(Collections.emptyList());
    private static final Key<TreeStructureProvider> KEY = Key.create((String)"TreeStructureProvider");
    private static final Logger LOG = Logger.getInstance(CompoundTreeStructureProvider.class);
    private final List<TreeStructureProvider> providers;

    @NotNull
    public static TreeStructureProvider get(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            return EMPTY;
        }
        TreeStructureProvider provider = (TreeStructureProvider)project.getUserData(KEY);
        if (provider != null) {
            return provider;
        }
        provider = new CompoundTreeStructureProvider(EP.getExtensions((AreaInstance)project));
        project.putUserData(KEY, (Object)provider);
        return provider;
    }

    public CompoundTreeStructureProvider(@NotNull List<TreeStructureProvider> providers) {
        this.providers = providers;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        for (TreeStructureProvider provider : this.providers) {
            try {
                if (!(children2 = provider.modify(parent, children2, settings)).stream().anyMatch(Objects::isNull)) continue;
                LOG.warn("null child provided by " + provider);
                children2 = StreamEx.of((Collection)children2).nonNull().toImmutableList();
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + provider, (Throwable)exception);
            }
        }
        children2.forEach(node -> node.setParent(parent));
        return children2;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode> selection, @NotNull String dataId) {
        if (dataId != null && !selection.isEmpty()) {
            for (TreeStructureProvider provider : this.providers) {
                try {
                    Object data = provider.getData(selection, dataId);
                    if (data == null) continue;
                    return data;
                }
                catch (IndexNotReadyException data) {
                }
                catch (ProcessCanceledException data) {
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider, (Throwable)exception);
                }
            }
        }
        return null;
    }
}

