/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectViewFileNesting", storages={@Storage(value="ui.lnf.xml")})
public class ProjectViewFileNestingService
implements PersistentStateComponent<MyState>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ProjectViewFileNestingService.class);
    private static final ExtensionPointName<ProjectViewNestingRulesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewNestingRulesProvider");
    private MyState myState = new MyState();
    private long myModCount;

    @NotNull
    public static ProjectViewFileNestingService getInstance() {
        return (ProjectViewFileNestingService)ServiceManager.getService(ProjectViewFileNestingService.class);
    }

    @NotNull
    static List<NestingRule> loadDefaultNestingRules() {
        ArrayList<NestingRule> result2 = new ArrayList<NestingRule>();
        ProjectViewNestingRulesProvider.Consumer consumer = (parentFileSuffix, childFileSuffix) -> {
            LOG.assertTrue(!parentFileSuffix.isEmpty() && !childFileSuffix.isEmpty(), (Object)"file suffix must not be empty");
            LOG.assertTrue(!parentFileSuffix.equals(childFileSuffix), (Object)("parent and child suffixes must be different: " + parentFileSuffix));
            result2.add(new NestingRule(parentFileSuffix, childFileSuffix));
        };
        for (ProjectViewNestingRulesProvider provider : (ProjectViewNestingRulesProvider[])EP_NAME.getExtensions()) {
            provider.addFileNestingRules(consumer);
        }
        return result2;
    }

    public MyState getState() {
        return this.myState;
    }

    public void loadState(@NotNull MyState state) {
        this.myState = state;
        ++this.myModCount;
    }

    @NotNull
    public List<NestingRule> getRules() {
        return this.myState.myRules;
    }

    public void setRules(@NotNull List<? extends NestingRule> rules) {
        this.myState.myRules.clear();
        this.myState.myRules.addAll(rules);
        ++this.myModCount;
    }

    public long getModificationCount() {
        return this.myModCount;
    }

    public static class NestingRule {
        @NotNull
        private String myParentFileSuffix;
        @NotNull
        private String myChildFileSuffix;

        public NestingRule() {
            this("", "");
        }

        public NestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
            this.myParentFileSuffix = parentFileSuffix;
            this.myChildFileSuffix = childFileSuffix;
        }

        @Attribute(value="parent-file-suffix")
        @NotNull
        public String getParentFileSuffix() {
            return this.myParentFileSuffix;
        }

        public void setParentFileSuffix(@NotNull String parentFileSuffix) {
            this.myParentFileSuffix = parentFileSuffix;
        }

        @Attribute(value="child-file-suffix")
        @NotNull
        public String getChildFileSuffix() {
            return this.myChildFileSuffix;
        }

        public void setChildFileSuffix(@NotNull String childFileSuffix) {
            this.myChildFileSuffix = childFileSuffix;
        }

        public String toString() {
            return this.myParentFileSuffix + "->" + this.myChildFileSuffix;
        }

        public boolean equals(Object o) {
            return o instanceof NestingRule && this.myParentFileSuffix.equals(((NestingRule)o).myParentFileSuffix) && this.myChildFileSuffix.equals(((NestingRule)o).myChildFileSuffix);
        }

        public int hashCode() {
            return this.myParentFileSuffix.hashCode() + 239 * this.myChildFileSuffix.hashCode();
        }
    }

    public static class MyState {
        @XCollection(propertyElementName="nesting-rules")
        public List<NestingRule> myRules = new SortedList(Comparator.comparing(o -> o.getParentFileSuffix()));

        public MyState() {
            this.myRules.addAll(ProjectViewFileNestingService.loadDefaultNestingRules());
        }
    }
}

