/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewSharedSettings;
import com.intellij.ide.projectView.impl.ShowExcludedFilesAction;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
Disposable,
QuickActionProvider,
BusyObject {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.ProjectViewImpl");
    private static final Key<String> ID_KEY = Key.create((String)"pane-id");
    private static final Key<String> SUB_ID_KEY = Key.create((String)"pane-sub-id");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private boolean myExtensionsLoaded;
    @NotNull
    private final Project myProject;
    private final Map<String, Boolean> myFlattenPackages = new THashMap();
    private static final boolean ourFlattenPackagesDefaults = false;
    private final Map<String, Boolean> myShowMembers = new THashMap();
    private static final boolean ourShowMembersDefaults = false;
    private final Map<String, Boolean> myManualOrder = new THashMap();
    private static final boolean ourManualOrderDefaults = false;
    private final Map<String, Boolean> mySortByType = new THashMap();
    private static final boolean ourSortByTypeDefaults = false;
    private final Map<String, Boolean> myShowModules = new THashMap();
    private static final boolean ourShowModulesDefaults = true;
    private final Map<String, Boolean> myFlattenModules = new THashMap();
    private static final boolean ourFlattenModulesDefaults = false;
    private final Map<String, Boolean> myShowExcludedFiles = new THashMap();
    private static final boolean ourShowExcludedFilesDefaults = true;
    private final Map<String, Boolean> myShowLibraryContents = new THashMap();
    private static final boolean ourShowLibraryContentsDefaults = true;
    private final Map<String, Boolean> myHideEmptyPackages = new THashMap();
    private static final boolean ourHideEmptyPackagesDefaults = true;
    private final Map<String, Boolean> myCompactDirectories = new THashMap();
    private static final boolean ourCompactDirectoriesDefaults = false;
    private final Map<String, Boolean> myAbbreviatePackageNames = new THashMap();
    private static final boolean ourAbbreviatePackagesDefaults = false;
    private final Map<String, Boolean> myAutoscrollToSource = new THashMap();
    private final Map<String, Boolean> myAutoscrollFromSource = new THashMap();
    private static final boolean ourAutoscrollFromSourceDefaults = false;
    private boolean myFoldersAlwaysOnTop = true;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private volatile ThreeState myCurrentSelectionObsolete = ThreeState.NO;
    private final IdeView myIdeView = new IdeViewForProjectViewPane(this::getCurrentProjectViewPane);
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
    private final Collection<AbstractProjectViewPane> myUninitializedPanes = new THashSet();
    private static final DataKey<ProjectViewImpl> DATA_KEY = DataKey.create((String)"com.intellij.ide.projectView.impl.ProjectViewImpl");
    private DefaultActionGroup myActionGroup;
    private String mySavedPaneId = ProjectViewImpl.getDefaultViewId();
    private String mySavedPaneSubId;
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flattenPackages";
    @NonNls
    private static final String ELEMENT_SHOW_MEMBERS = "showMembers";
    @NonNls
    private static final String ELEMENT_SHOW_MODULES = "showModules";
    @NonNls
    private static final String ELEMENT_SHOW_EXCLUDED_FILES = "showExcludedFiles";
    @NonNls
    private static final String ELEMENT_SHOW_LIBRARY_CONTENTS = "showLibraryContents";
    @NonNls
    private static final String ELEMENT_HIDE_EMPTY_PACKAGES = "hideEmptyPackages";
    @NonNls
    private static final String ELEMENT_COMPACT_DIRECTORIES = "compactDirectories";
    @NonNls
    private static final String ELEMENT_ABBREVIATE_PACKAGE_NAMES = "abbreviatePackageNames";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "autoscrollToSource";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_FROM_SOURCE = "autoscrollFromSource";
    @NonNls
    private static final String ELEMENT_SORT_BY_TYPE = "sortByType";
    @NonNls
    private static final String ELEMENT_FOLDERS_ALWAYS_ON_TOP = "foldersAlwaysOnTop";
    @NonNls
    private static final String ELEMENT_MANUAL_ORDER = "manualOrder";
    private static final String ATTRIBUTE_ID = "id";
    private JPanel myViewContentPanel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = Comparator.comparingInt(AbstractProjectViewPane::getWeight);
    private final FileEditorManager myFileEditorManager;
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions = new SplitterProportionsDataImpl();
    private final MessageBusConnection myConnection;
    private final Map<String, Element> myUninitializedPaneState = new THashMap();
    private final Map<String, SelectInTarget> mySelectInTargets = new LinkedHashMap<String, SelectInTarget>();
    private ContentManager myContentManager;

    public ProjectViewImpl(@NotNull Project project, FileEditorManager fileEditorManager, final ToolWindowManagerEx toolWindowManager) {
        this.myProject = project;
        this.constructUi();
        this.myFileEditorManager = fileEditorManager;
        this.myConnection = project.getMessageBus().connect();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel);
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.isAutoscrollToSource(ProjectViewImpl.this.myCurrentViewId);
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.setAutoscrollToSource(state, ProjectViewImpl.this.myCurrentViewId);
            }
        };
        this.myConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            private boolean toolWindowVisible;

            @Override
            public void stateChanged() {
                SimpleSelectInContext context;
                AbstractProjectViewPane currentProjectViewPane;
                ToolWindow window = toolWindowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
                if (window == null || this.toolWindowVisible == window.isVisible()) {
                    return;
                }
                ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.NO;
                if (window.isVisible() && !this.toolWindowVisible && (currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane()) != null && ProjectViewImpl.this.isAutoscrollFromSource(currentProjectViewPane.getId()) && (context = ProjectViewImpl.this.myAutoScrollFromSourceHandler.findSelectInContext()) != null) {
                    ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.UNSURE;
                    context.selectInCurrentTarget();
                }
                this.toolWindowVisible = window.isVisible();
            }
        });
    }

    private void constructUi() {
        this.myViewContentPanel = new JPanel();
        this.myPanel = new SimpleToolWindowPanel(true).setProvideQuickActions(false);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
    }

    @NotNull
    public String getName() {
        return IdeUICustomization.getInstance().getProjectViewTitle();
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        DefaultActionGroup views = new DefaultActionGroup("Change View", true);
        ChangeViewAction lastHeader = null;
        for (int i = 0; i < this.myContentManager.getContentCount(); ++i) {
            Content each = this.myContentManager.getContent(i);
            if (each == null) continue;
            String id = (String)each.getUserData(ID_KEY);
            String subId = (String)each.getUserData(SUB_ID_KEY);
            ChangeViewAction newHeader = new ChangeViewAction(id, subId);
            if (lastHeader != null) {
                boolean newHasKids;
                boolean lastHasKids = lastHeader.mySubId != null;
                boolean bl = newHasKids = newHeader.mySubId != null;
                if (lastHasKids != newHasKids || lastHasKids && lastHeader.myId != newHeader.myId) {
                    views.add((AnAction)Separator.getInstance());
                }
            }
            views.add((AnAction)newHeader);
            lastHeader = newHeader;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)views);
        result2.add((AnAction)Separator.getInstance());
        if (this.myActionGroup != null) {
            ArrayList<AnAction> secondary = new ArrayList<AnAction>();
            for (AnAction each : this.myActionGroup.getChildren(null)) {
                if (this.myActionGroup.isPrimary(each)) {
                    result2.add(each);
                    continue;
                }
                secondary.add(each);
            }
            result2.add((AnAction)Separator.getInstance());
            result2.addAll(secondary);
        }
        return result2;
    }

    @Override
    public synchronized void addProjectPane(@NotNull AbstractProjectViewPane pane) {
        this.myUninitializedPanes.add(pane);
        SelectInTarget selectInTarget = pane.createSelectInTarget();
        String id = selectInTarget.getMinorViewId();
        if (pane.getId().equals(id)) {
            this.mySelectInTargets.put(id, selectInTarget);
        } else {
            try {
                LOG.error("Unexpected SelectInTarget: " + selectInTarget.getClass() + "\n  created by project pane:" + pane.getClass());
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(@NotNull AbstractProjectViewPane pane) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUninitializedPanes.remove(pane);
        String idToRemove = pane.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        for (int i = this.getContentManager().getContentCount() - 1; i >= 0; --i) {
            String id;
            Content content = this.getContentManager().getContent(i);
            String string = id = content != null ? (String)content.getUserData(ID_KEY) : null;
            if (!idToRemove.equals(id)) continue;
            this.getContentManager().removeContent(content, true);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        for (AbstractProjectViewPane pane : this.myUninitializedPanes) {
            this.doAddPane(pane);
        }
        Content contents = this.getContentManager().getContents();
        for (int i = 1; i < ((Content[])contents).length; ++i) {
            Content content = contents[i];
            Content prev2 = contents[i - 1];
            if (StringUtil.equals((CharSequence)((CharSequence)content.getUserData(ID_KEY)), (CharSequence)((CharSequence)prev2.getUserData(ID_KEY))) || prev2.getUserData(SUB_ID_KEY) == null || content.getSeparator() != null) continue;
            content.setSeparator("");
        }
        String selectID = null;
        String selectSubID = null;
        for (Content content : contents) {
            String id = (String)content.getUserData(ID_KEY);
            String subId = (String)content.getUserData(SUB_ID_KEY);
            if (id == null || !id.equals(this.mySavedPaneId) || !StringUtil.equals((CharSequence)subId, (CharSequence)this.mySavedPaneSubId)) continue;
            selectID = id;
            selectSubID = subId;
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
            break;
        }
        if (selectID == null && ((Content)contents).length > 0 && this.myCurrentViewId == null) {
            Content content = contents[0];
            selectID = (String)content.getUserData(ID_KEY);
            selectSubID = (String)content.getUserData(SUB_ID_KEY);
        }
        if (selectID != null) {
            this.changeView(selectID, selectSubID);
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(@NotNull AbstractProjectViewPane newPane) {
        String[] stringArray;
        int index;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContentManager manager = this.getContentManager();
        for (index = 0; index < manager.getContentCount(); ++index) {
            Content content = manager.getContent(index);
            String id = (String)content.getUserData(ID_KEY);
            AbstractProjectViewPane pane = this.myId2Pane.get(id);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane, newPane);
            LOG.assertTrue(comp != 0, (Object)("Project view pane " + newPane + " has the same weight as " + pane + ". Please make sure that you overload getWeight() and return a distinct weight value."));
            if (comp > 0) break;
        }
        String id = newPane.getId();
        this.myId2Pane.put(id, newPane);
        String[] subIds = newPane.getSubIds();
        if (subIds.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = subIds;
        }
        subIds = stringArray;
        boolean first = true;
        for (String subId : subIds) {
            String title = subId != null ? newPane.getPresentableSubIdName(subId) : newPane.getTitle();
            Content content = this.getContentManager().getFactory().createContent(this.getComponent(), title, false);
            content.setTabName(title);
            content.putUserData(ID_KEY, (Object)id);
            content.putUserData(SUB_ID_KEY, (Object)subId);
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            Icon icon = subId != null ? newPane.getPresentableSubIdIcon(subId) : newPane.getIcon();
            content.setIcon(icon);
            content.setPopupIcon(icon);
            content.setPreferredFocusedComponent(() -> {
                AbstractProjectViewPane current = this.getCurrentProjectViewPane();
                return current != null ? current.getComponentToFocus() : null;
            });
            content.setBusyObject((BusyObject)this);
            if (first && subId != null) {
                content.setSeparator(newPane.getTitle());
            }
            manager.addContent(content, index++);
            first = false;
        }
    }

    private void showPane(@NotNull AbstractProjectViewPane newPane) {
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            }
        }
        this.myViewContentPanel.removeAll();
        JComponent component = newPane.createComponent();
        UIUtil.removeScrollBorder((Component)component);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions();
        this.myAutoScrollToSourceHandler.install((JTree)((Object)newPane.myTree));
        IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)newPane.getComponentToFocus(), this.myProject);
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && newSubId != null) {
            ProjectViewSelectInTarget target2;
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)selectedPsiElement);
            ProjectViewSelectInTarget projectViewSelectInTarget = target2 = virtualFile == null ? null : this.getProjectViewSelectInTarget(newPane);
            if (target2 != null && target2.isSubIdSelectable(newSubId, (SelectInContext)new FileSelectInContext(this.myProject, virtualFile, null))) {
                newPane.select(selectedPsiElement, virtualFile, true);
            }
        }
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)((Object)newPane.myTree));
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow) {
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow, boolean loadPaneExtensions) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        this.myContentManager = toolWindow.getContentManager();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)this.myActionGroup);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(() -> this.splitterProportions.restoreSplitterProportions((Component)this.myPanel));
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
        this.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ProjectViewImpl.this.viewSelectionChanged();
                }
            }
        });
        this.viewSelectionChanged();
    }

    private void ensurePanesLoaded() {
        if (this.myExtensionsLoaded) {
            return;
        }
        AbstractProjectViewPane[] extensions = (AbstractProjectViewPane[])AbstractProjectViewPane.EP_NAME.getExtensions((AreaInstance)this.myProject);
        Arrays.sort(extensions, PANE_WEIGHT_COMPARATOR);
        this.myExtensionsLoaded = true;
        for (AbstractProjectViewPane pane : extensions) {
            if (this.myUninitializedPaneState.containsKey(pane.getId())) {
                try {
                    pane.readExternal(this.myUninitializedPaneState.get(pane.getId()));
                }
                catch (InvalidDataException invalidDataException) {
                    // empty catch block
                }
                this.myUninitializedPaneState.remove(pane.getId());
            }
            if (!pane.isInitiallyVisible() || this.myId2Pane.containsKey(pane.getId())) continue;
            this.addProjectPane(pane);
        }
    }

    private void viewSelectionChanged() {
        Content content = this.getContentManager().getSelectedContent();
        if (content == null) {
            return;
        }
        String id = (String)content.getUserData(ID_KEY);
        String subId = (String)content.getUserData(SUB_ID_KEY);
        if (Objects.equals(id, this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            return;
        }
        AbstractProjectViewPane newPane = this.getProjectViewPaneById(id);
        if (newPane == null) {
            return;
        }
        newPane.setSubId(subId);
        this.showPane(newPane);
        ProjectViewSelectInTarget target2 = this.getProjectViewSelectInTarget(newPane);
        if (target2 != null) {
            target2.setSubId(subId);
        }
        if (this.isAutoscrollFromSource(id)) {
            this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
    }

    private void createToolbarActions() {
        ToolWindowEx window;
        if (this.myActionGroup == null) {
            return;
        }
        this.myActionGroup.removeAll();
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myFlattenPackages, IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON, false){

                @Override
                public void setSelected(@NotNull AnActionEvent event, boolean flag) {
                    AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
                    if (ProjectViewImpl.isGlobalOptions()) {
                        ProjectViewImpl.this.setFlattenPackages(viewPane.getId(), flag);
                    }
                    super.setSelected(event, flag);
                    selectionInfo.apply(viewPane);
                }

                @Override
                public boolean isSelected(@NotNull AnActionEvent event) {
                    if (ProjectViewImpl.isGlobalOptions()) {
                        return ProjectViewImpl.getGlobalOptions().getFlattenPackages();
                    }
                    return super.isSelected(event);
                }
            }).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsHideEmptyMiddlePackages()) {
            this.myActionGroup.addAction((AnAction)new HideEmptyMiddlePackagesAction()).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            class FlattenPackagesDependableAction
            extends PaneOptionAction {
                FlattenPackagesDependableAction(@NotNull Map<String, Boolean> optionsMap, @NotNull String text, @NotNull String description, Icon icon, boolean optionDefaultValue) {
                    super(optionsMap, text, description, icon, optionDefaultValue);
                }

                @Override
                public void setSelected(@NotNull AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.isGlobalOptions()) {
                        ProjectViewImpl.getGlobalOptions().setFlattenPackages(flag);
                    }
                    super.setSelected(event, flag);
                }

                public void update(@NotNull AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setVisible(ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId));
                }
            }
            this.myActionGroup.addAction((AnAction)new FlattenPackagesDependableAction((Map)this.myAbbreviatePackageNames, IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), AllIcons.ObjectBrowser.AbbreviatePackageNames, false){
                {
                    super(optionsMap, text, description, icon, optionDefaultValue);
                }

                @Override
                public boolean isSelected(@NotNull AnActionEvent event) {
                    return ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId) && ProjectViewImpl.this.isAbbreviatePackageNames(ProjectViewImpl.this.myCurrentViewId);
                }

                @Override
                public void setSelected(@NotNull AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.isGlobalOptions()) {
                        ProjectViewImpl.this.setAbbreviatePackageNames(ProjectViewImpl.this.myCurrentViewId, flag);
                    }
                    ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
                }

                @Override
                public void update(@NotNull AnActionEvent event) {
                    super.update(event);
                    Presentation presentation = event.getPresentation();
                    presentation.setEnabledAndVisible(!"Scope".equals(ProjectViewImpl.this.myCurrentViewId));
                }
            }).setAsSecondary(true);
        }
        this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myCompactDirectories, IdeBundle.message((String)"action.compact.directories.text", (Object[])new Object[0]), IdeBundle.message((String)"action.compact.directories.description", (Object[])new Object[0]), null, false){

            public void update(@NotNull AnActionEvent event) {
                super.update(event);
                Presentation presentation = event.getPresentation();
                presentation.setEnabledAndVisible("Scope".equals(ProjectViewImpl.this.myCurrentViewId));
            }

            @Override
            public boolean isSelected(@NotNull AnActionEvent event) {
                return ProjectViewImpl.isGlobalOptions() ? ProjectViewImpl.getGlobalOptions().getCompactDirectories() : super.isSelected(event);
            }

            @Override
            public void setSelected(@NotNull AnActionEvent event, boolean compactDirectories) {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
                if (ProjectViewImpl.isGlobalOptions()) {
                    ProjectViewImpl.getGlobalOptions().setCompactDirectories(compactDirectories);
                }
                super.setSelected(event, compactDirectories);
                ProjectViewImpl.this.setPaneOption(ProjectViewImpl.this.myCompactDirectories, compactDirectories, viewPane.getId(), true);
                selectionInfo.apply(viewPane);
            }
        }).setAsSecondary(true);
        if (this.isShowMembersOptionSupported()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myShowMembers, IdeBundle.message((String)"action.show.members", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.members", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowMembers, false){

                @Override
                public boolean isSelected(@NotNull AnActionEvent event) {
                    if (ProjectViewImpl.isGlobalOptions()) {
                        return ProjectViewImpl.getGlobalOptions().getShowMembers();
                    }
                    return super.isSelected(event);
                }

                @Override
                public void setSelected(@NotNull AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.isGlobalOptions()) {
                        ProjectViewImpl.getGlobalOptions().setShowMembers(flag);
                    }
                    super.setSelected(event, flag);
                }
            }).setAsSecondary(true);
        }
        this.myActionGroup.addAction((AnAction)this.myAutoScrollToSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new ManualOrderAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new SortByTypeAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new FoldersAlwaysOnTopAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)ShowExcludedFilesAction.INSTANCE).setAsSecondary(true);
        this.getProjectViewPaneById(this.myCurrentViewId == null ? ProjectViewImpl.getDefaultViewId() : this.myCurrentViewId).addToolbarActions(this.myActionGroup);
        List titleActions = ContainerUtil.newSmartList();
        this.createTitleActions(titleActions);
        if (!titleActions.isEmpty() && (window = (ToolWindowEx)ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
            window.setTitleActions(titleActions.toArray(AnAction.EMPTY_ARRAY));
        }
    }

    protected void createTitleActions(@NotNull List<AnAction> titleActions) {
        if (!this.myAutoScrollFromSourceHandler.isAutoScrollEnabled()) {
            titleActions.add(new ScrollFromSourceAction());
        }
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                DnDAwareTree tree = pane.myTree;
                if (tree != null) {
                    TreeUtil.collapseAll((JTree)((Object)tree), (int)0);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, this.getComponent());
        collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        collapseAllAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        titleActions.add(collapseAllAction);
    }

    protected boolean isShowMembersOptionSupported() {
        return true;
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id) {
        AbstractProjectViewPane pane;
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            this.ensurePanesLoaded();
        }
        if ((pane = this.myId2Pane.get(id)) != null) {
            return pane;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        return this.getProjectViewPaneById(this.myCurrentViewId);
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    private boolean isCurrentSelectionObsolete(boolean requestFocus) {
        if (this.myCurrentSelectionObsolete == ThreeState.YES) {
            this.myCurrentSelectionObsolete = ThreeState.NO;
            return true;
        }
        if (this.myCurrentSelectionObsolete == ThreeState.UNSURE) {
            this.myCurrentSelectionObsolete = requestFocus ? ThreeState.YES : ThreeState.NO;
        }
        return false;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            return;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            viewPane.select(element, file2, requestFocus);
        }
    }

    @Override
    @NotNull
    public ActionCallback selectCB(Object element, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            return ActionCallback.REJECTED;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane instanceof AbstractProjectViewPSIPane) {
            return ((AbstractProjectViewPSIPane)viewPane).selectCB(element, file2, requestFocus);
        }
        this.select(element, file2, requestFocus);
        return ActionCallback.DONE;
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    public JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    private SelectInTarget getCurrentSelectInTarget() {
        return this.getSelectInTarget(this.getCurrentViewId());
    }

    private SelectInTarget getSelectInTarget(String id) {
        return this.mySelectInTargets.get(id);
    }

    private ProjectViewSelectInTarget getProjectViewSelectInTarget(AbstractProjectViewPane pane) {
        SelectInTarget target2 = this.getSelectInTarget(pane.getId());
        return target2 instanceof ProjectViewSelectInTarget ? (ProjectViewSelectInTarget)target2 : null;
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path = viewPane.getSelectedPath();
        if (path == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        ProjectViewNode descriptor = (ProjectViewNode)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)path);
        if (descriptor != null) {
            Object element = descriptor.getValue();
            if (element instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    public ContentManager getContentManager() {
        if (this.myContentManager == null) {
            ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PROJECT_VIEW).getContentManager();
        }
        return this.myContentManager;
    }

    @Override
    public void changeView() {
        ArrayList<AbstractProjectViewPane> views = new ArrayList<AbstractProjectViewPane>(this.myId2Pane.values());
        views.remove(this.getCurrentProjectViewPane());
        Collections.sort(views, PANE_WEIGHT_COMPARATOR);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(views).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                AbstractProjectViewPane pane = (AbstractProjectViewPane)value;
                this.setText(pane.getTitle());
                return this;
            }
        }).setTitle(IdeBundle.message((String)"title.popup.views", (Object[])new Object[0])).setItemChosenCallback(pane -> this.changeView(pane.getId()));
        if (!views.isEmpty()) {
            builder2 = builder2.setSelectedValue(views.get(0), true);
        }
        builder2.createPopup().showInCenterOf((Component)this.getComponent());
    }

    @Override
    public void changeView(@NotNull String viewId) {
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        this.changeViewCB(viewId, subId);
    }

    @Override
    @NotNull
    public ActionCallback changeViewCB(@NotNull String viewId, @Nullable String subId) {
        boolean hasSubViews;
        AbstractProjectViewPane pane = this.getProjectViewPaneById(viewId);
        LOG.assertTrue(pane != null, (Object)("Project view pane not found: " + viewId + "; subId:" + subId + "; project: " + this.myProject));
        boolean bl = hasSubViews = pane.getSubIds().length > 0;
        if (hasSubViews) {
            if (subId == null) {
                subId = pane.getSubId();
            }
        } else if (subId != null) {
            LOG.error("View doesn't have subviews: " + viewId + "; subId:" + subId + "; project: " + this.myProject);
        }
        if (viewId.equals(this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            return ActionCallback.REJECTED;
        }
        for (Content content : this.getContentManager().getContents()) {
            if (!viewId.equals(content.getUserData(ID_KEY)) || subId != null && !subId.equals(content.getUserData(SUB_ID_KEY))) continue;
            return this.getContentManager().setSelectedContentCB(content);
        }
        return ActionCallback.REJECTED;
    }

    @Nullable
    private Module moduleBySingleContentRoot(@NotNull VirtualFile file2) {
        Module module;
        if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2)) != null && !module.isDisposed() && ModuleRootManager.getInstance((Module)module).getContentRoots().length == 1) {
            return module;
        }
        return null;
    }

    @Nullable
    private UnloadedModuleDescription getUnloadedModuleByContentRoot(@NotNull VirtualFile file2) {
        String moduleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, this.myProject);
        if (moduleName != null) {
            return ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
        }
        return null;
    }

    @NotNull
    private <T> List<T> getSelectedElements(@NotNull Class<T> klass) {
        Object[] elements;
        ArrayList<Object> result2 = new ArrayList<Object>();
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return result2;
        }
        for (Object element : elements = viewPane.getSelectedElements()) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result2.add(element);
        }
        return result2;
    }

    @Override
    public void selectPsiElement(@NotNull PsiElement element, boolean requestFocus) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        this.select(element, virtualFile, requestFocus);
    }

    private static void readOption(@Nullable Element node, @NotNull Map<String, Boolean> options) {
        if (node == null) {
            return;
        }
        for (Attribute attribute : node.getAttributes()) {
            options.put(attribute.getName(), Boolean.parseBoolean(attribute.getValue()));
        }
    }

    private static void writeOption(@NotNull Element parentNode, @NotNull Map<String, Boolean> optionsForPanes, @NotNull String optionName) {
        if (optionsForPanes.isEmpty()) {
            return;
        }
        Element e = new Element(optionName);
        for (Map.Entry<String, Boolean> entry : optionsForPanes.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            e.setAttribute(key, Boolean.toString(entry.getValue()));
        }
        parentNode.addContent(e);
    }

    public void loadState(@NotNull Element parentNode) {
        Element panesElement;
        Element navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR);
        if (navigatorElement != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            if (this.mySavedPaneId == null) {
                this.mySavedPaneId = ProjectViewImpl.getDefaultViewId();
                this.mySavedPaneSubId = null;
            }
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_FLATTEN_PACKAGES), this.myFlattenPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MEMBERS), this.myShowMembers);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MODULES), this.myShowModules);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_EXCLUDED_FILES), this.myShowExcludedFiles);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_LIBRARY_CONTENTS), this.myShowLibraryContents);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_HIDE_EMPTY_PACKAGES), this.myHideEmptyPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_COMPACT_DIRECTORIES), this.myCompactDirectories);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_ABBREVIATE_PACKAGE_NAMES), this.myAbbreviatePackageNames);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_TO_SOURCE), this.myAutoscrollToSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_FROM_SOURCE), this.myAutoscrollFromSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SORT_BY_TYPE), this.mySortByType);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_MANUAL_ORDER), this.myManualOrder);
            Element foldersElement = navigatorElement.getChild(ELEMENT_FOLDERS_ALWAYS_ON_TOP);
            if (foldersElement != null) {
                this.myFoldersAlwaysOnTop = Boolean.valueOf(foldersElement.getAttributeValue("value"));
            }
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    @NotNull
    public static String getDefaultViewId() {
        if ("AndroidStudio".equals(PlatformUtils.getPlatformPrefix()) && !Boolean.getBoolean("studio.projectview")) {
            return "AndroidView";
        }
        return "ProjectPane";
    }

    private void readPaneState(@NotNull Element panesElement) {
        List paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            if (StringUtil.isEmptyOrSpaces((String)paneId)) continue;
            AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
            if (pane != null) {
                try {
                    pane.readExternal(paneElement);
                }
                catch (InvalidDataException invalidDataException) {}
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    public Element getState() {
        String subId;
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (!(currentPane == null || (subId = currentPane.getSubId()) == null && currentPane.getId().equals(ProjectViewImpl.getDefaultViewId()))) {
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        ProjectViewImpl.writeOption(navigatorElement, this.myFlattenPackages, ELEMENT_FLATTEN_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowMembers, ELEMENT_SHOW_MEMBERS);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowModules, ELEMENT_SHOW_MODULES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowExcludedFiles, ELEMENT_SHOW_EXCLUDED_FILES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowLibraryContents, ELEMENT_SHOW_LIBRARY_CONTENTS);
        ProjectViewImpl.writeOption(navigatorElement, this.myHideEmptyPackages, ELEMENT_HIDE_EMPTY_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myCompactDirectories, ELEMENT_COMPACT_DIRECTORIES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAbbreviatePackageNames, ELEMENT_ABBREVIATE_PACKAGE_NAMES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollToSource, ELEMENT_AUTOSCROLL_TO_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollFromSource, ELEMENT_AUTOSCROLL_FROM_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.mySortByType, ELEMENT_SORT_BY_TYPE);
        ProjectViewImpl.writeOption(navigatorElement, this.myManualOrder, ELEMENT_MANUAL_ORDER);
        Element foldersElement = new Element(ELEMENT_FOLDERS_ALWAYS_ON_TOP);
        foldersElement.setAttribute("value", Boolean.toString(this.myFoldersAlwaysOnTop));
        navigatorElement.addContent(foldersElement);
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        if (!JDOMUtil.isEmpty((Element)navigatorElement)) {
            parentNode.addContent(navigatorElement);
        }
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(@NotNull Element panesElement) {
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane.getId());
            try {
                pane.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element : this.myUninitializedPaneState.values()) {
            panesElement.addContent(element.clone());
        }
    }

    private static boolean isGlobalOptions() {
        return Registry.is((String)"ide.projectView.globalOptions");
    }

    private static ProjectViewSharedSettings getGlobalOptions() {
        return ProjectViewSharedSettings.Companion.getInstance();
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getAutoscrollToSource();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollToSource, paneId, UISettings.getInstance().getState().getDefaultAutoScrollToSource());
    }

    public void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setAutoscrollToSource(autoscrollMode);
        }
        this.myAutoscrollToSource.put(paneId, autoscrollMode);
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getAutoscrollFromSource();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollFromSource, paneId, false);
    }

    public void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setAutoscrollFromSource(autoscrollMode);
        }
        this.setPaneOption(this.myAutoscrollFromSource, autoscrollMode, paneId, false);
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getFlattenPackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenPackages, paneId, false);
    }

    public void setFlattenPackages(String paneId, boolean flattenPackages) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setFlattenPackages(flattenPackages);
            for (String pane : this.myFlattenPackages.keySet()) {
                this.setPaneOption(this.myFlattenPackages, flattenPackages, pane, true);
            }
        }
        this.setPaneOption(this.myFlattenPackages, flattenPackages, paneId, true);
    }

    @Override
    public boolean isFoldersAlwaysOnTop(String paneId) {
        return this.isFoldersAlwaysOnTop();
    }

    @Deprecated
    public boolean isFoldersAlwaysOnTop() {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getFoldersAlwaysOnTop();
        }
        return this.myFoldersAlwaysOnTop;
    }

    public void setFoldersAlwaysOnTop(boolean foldersAlwaysOnTop) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setFoldersAlwaysOnTop(foldersAlwaysOnTop);
        }
        if (this.myFoldersAlwaysOnTop != foldersAlwaysOnTop) {
            this.myFoldersAlwaysOnTop = foldersAlwaysOnTop;
            for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
                if (pane.getTree() == null) continue;
                pane.updateFromRoot(false);
            }
        }
    }

    @Override
    public boolean isShowMembers(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getShowMembers();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowMembers, paneId, false);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getHideEmptyPackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myHideEmptyPackages, paneId, true);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getAbbreviatePackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAbbreviatePackageNames, paneId, false);
    }

    @Override
    public boolean isShowExcludedFiles(String paneId) {
        AbstractProjectViewPane pane;
        boolean showExcludedFiles;
        boolean bl = showExcludedFiles = ProjectViewImpl.isGlobalOptions() ? ProjectViewImpl.getGlobalOptions().getShowExcludedFiles() : ProjectViewImpl.getPaneOptionValue(this.myShowExcludedFiles, paneId, true);
        if (showExcludedFiles && EventQueue.isDispatchThread() && (pane = this.getProjectViewPaneById("ProjectPane")) instanceof ProjectViewPane) {
            ProjectViewPane old = (ProjectViewPane)pane;
            showExcludedFiles = old.myShowExcludedFiles;
            if (!showExcludedFiles) {
                this.setShowExcludedFiles(paneId, showExcludedFiles, false);
                this.setPaneOption(this.myShowExcludedFiles, showExcludedFiles, "ProjectPane", false);
                old.myShowExcludedFiles = true;
            }
        }
        return showExcludedFiles;
    }

    void setShowExcludedFiles(@NotNull String paneId, boolean showExcludedFiles, boolean updatePane) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setShowExcludedFiles(showExcludedFiles);
            for (String id : this.getPaneIds()) {
                if (!ShowExcludedFilesAction.INSTANCE.isSupported(this, id)) continue;
                this.setPaneOption(this.myShowExcludedFiles, showExcludedFiles, id, updatePane);
            }
        } else if (ShowExcludedFilesAction.INSTANCE.isSupported(this, paneId)) {
            this.setPaneOption(this.myShowExcludedFiles, showExcludedFiles, paneId, updatePane);
        }
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getShowLibraryContents();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowLibraryContents, paneId, true);
    }

    @Override
    public void setShowLibraryContents(@NotNull String paneId, boolean showLibraryContents) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setShowLibraryContents(showLibraryContents);
        }
        this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    @NotNull
    public ActionCallback setShowLibraryContentsCB(String paneId, boolean showLibraryContents) {
        return this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    @Override
    public boolean isShowModules(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getShowModules();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowModules, paneId, true);
    }

    @Override
    public void setShowModules(@NotNull String paneId, boolean showModules) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setShowModules(showModules);
        }
        this.setPaneOption(this.myShowModules, showModules, paneId, true);
    }

    @Override
    public boolean isFlattenModules(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getFlattenModules();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenModules, paneId, false);
    }

    @Override
    public void setFlattenModules(@NotNull String paneId, boolean flattenModules) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setFlattenModules(flattenModules);
        }
        this.setPaneOption(this.myFlattenModules, flattenModules, paneId, true);
    }

    @Override
    public boolean isShowURL(String paneId) {
        return Registry.is((String)"project.tree.structure.show.url");
    }

    @Override
    public void setHideEmptyPackages(@NotNull String paneId, boolean hideEmptyPackages) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setHideEmptyPackages(hideEmptyPackages);
            for (String pane : this.myHideEmptyPackages.keySet()) {
                this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, pane, true);
            }
        }
        this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, paneId, true);
    }

    @Override
    public boolean isCompactDirectories(String paneId) {
        return ProjectViewImpl.isGlobalOptions() ? ProjectViewImpl.getGlobalOptions().getCompactDirectories() : ProjectViewImpl.getPaneOptionValue(this.myCompactDirectories, paneId, false);
    }

    @Override
    public void setCompactDirectories(@NotNull String paneId, boolean compactDirectories) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setCompactDirectories(compactDirectories);
            for (String pane : this.myCompactDirectories.keySet()) {
                this.setPaneOption(this.myCompactDirectories, compactDirectories, pane, true);
            }
        }
        this.setPaneOption(this.myCompactDirectories, compactDirectories, paneId, true);
    }

    @Override
    public void setAbbreviatePackageNames(@NotNull String paneId, boolean abbreviatePackageNames) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setAbbreviatePackages(abbreviatePackageNames);
        }
        this.setPaneOption(this.myAbbreviatePackageNames, abbreviatePackageNames, paneId, true);
    }

    @NotNull
    private ActionCallback setPaneOption(@NotNull Map<String, Boolean> optionsMap, boolean value, String paneId, boolean updatePane) {
        if (paneId != null) {
            AbstractProjectViewPane pane;
            optionsMap.put(paneId, value);
            if (updatePane && (pane = this.getProjectViewPaneById(paneId)) != null) {
                return pane.updateFromRoot(false);
            }
        }
        return ActionCallback.DONE;
    }

    private static boolean getPaneOptionValue(@NotNull Map<String, Boolean> optionsMap, String paneId, boolean defaultValue) {
        Boolean value = optionsMap.get(paneId);
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean isManualOrder(String paneId) {
        if (ProjectViewImpl.isGlobalOptions()) {
            return ProjectViewImpl.getGlobalOptions().getManualOrder();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myManualOrder, paneId, false);
    }

    @Override
    public void setManualOrder(@NotNull String paneId, boolean enabled) {
        if (ProjectViewImpl.isGlobalOptions()) {
            ProjectViewImpl.getGlobalOptions().setManualOrder(enabled);
        }
        this.setPaneOption(this.myManualOrder, enabled, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    public boolean isSortByType(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.mySortByType, paneId, false);
    }

    @Override
    public void setSortByType(@NotNull String paneId, boolean sortByType) {
        this.setPaneOption(this.mySortByType, sortByType, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    @NotNull
    public Collection<String> getPaneIds() {
        return Collections.unmodifiableCollection(this.myId2Pane.keySet());
    }

    @Override
    @NotNull
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        return this.mySelectInTargets.values();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        AbstractProjectViewPane pane = this.myId2Pane.get(this.myCurrentViewSubId);
        if (pane == null) {
            pane = this.myId2Pane.get(this.myCurrentViewId);
        }
        return pane != null ? pane.getReady(requestor) : ActionCallback.DONE;
    }

    private class ScrollFromSourceAction
    extends AnAction
    implements DumbAware {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", AllIcons.General.Locate);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
    }

    private class FoldersAlwaysOnTopAction
    extends ToggleAction
    implements DumbAware {
        private FoldersAlwaysOnTopAction() {
            super("Folders Always on Top");
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return ProjectViewImpl.this.isFoldersAlwaysOnTop(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setFoldersAlwaysOnTop(flag);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            presentation.setEnabledAndVisible(pane != null && pane.supportsFoldersAlwaysOnTop());
        }
    }

    private class SortByTypeAction
    extends ToggleAction
    implements DumbAware {
        private SortByTypeAction() {
            super(IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), AllIcons.ObjectBrowser.SortByType);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return ProjectViewImpl.this.isSortByType(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setSortByType(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            presentation.setVisible(pane != null && pane.supportsSortByType());
        }
    }

    private class ManualOrderAction
    extends ToggleAction
    implements DumbAware {
        private ManualOrderAction() {
            super(IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]), null, AllIcons.ObjectBrowser.Sorted);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return ProjectViewImpl.this.isManualOrder(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setManualOrder(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (pane == null) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setEnabledAndVisible(pane.supportsManualOrder());
                presentation.setText(pane.getManualOrderOptionText());
            }
        }
    }

    private class EditorSelectInContext
    extends SimpleSelectInContext {
        private final Editor editor;

        EditorSelectInContext(@NotNull PsiFile psiFile, Editor editor) {
            super(psiFile);
            this.editor = editor;
        }

        @Override
        void selectInCurrentTarget() {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.getProject());
            if (manager != null) {
                manager.performLaterWhenAllCommitted(() -> super.selectInCurrentTarget());
            }
        }

        public Object getSelectorInFile() {
            PsiFile file2 = this.getPsiFile();
            if (file2 != null) {
                int offset = this.editor.getCaretModel().getOffset();
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.getProject());
                LOG.assertTrue(manager.isCommitted(this.editor.getDocument()));
                PsiElement element = file2.findElementAt(offset);
                if (element != null) {
                    return element;
                }
            }
            return file2;
        }
    }

    private class SimpleSelectInContext
    extends SmartSelectInContext {
        SimpleSelectInContext(PsiFile psiFile) {
            super(psiFile, (PsiElement)psiFile);
        }

        void selectInCurrentTarget() {
            SelectInTarget target2 = ProjectViewImpl.this.getCurrentSelectInTarget();
            if (target2 != null && this.getPsiFile() != null) {
                this.selectIn(target2, false);
            }
        }

        @NotNull
        public FileEditorProvider getFileEditorProvider() {
            return () -> (FileEditor)ArrayUtil.getFirstElement((Object[])ProjectViewImpl.this.myFileEditorManager.openFile(this.getVirtualFile(), false));
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (JComponent)ProjectViewImpl.this.myViewContentPanel, (Disposable)ProjectViewImpl.this);
        }

        protected void selectElementFromEditor(@NotNull FileEditor fileEditor) {
            SimpleSelectInContext context;
            if (this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                return;
            }
            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId()) && !this.isCurrentProjectViewPaneFocused() && (context = this.getSelectInContext(fileEditor)) != null) {
                context.selectInCurrentTarget();
            }
        }

        void scrollFromSource() {
            SimpleSelectInContext context = this.findSelectInContext();
            if (context != null) {
                context.selectInCurrentTarget();
            }
        }

        @Nullable
        SimpleSelectInContext findSelectInContext() {
            SimpleSelectInContext context = this.getSelectInContext(ProjectViewImpl.this.myFileEditorManager.getSelectedEditor());
            if (context != null) {
                return context;
            }
            for (FileEditor fileEditor : ProjectViewImpl.this.myFileEditorManager.getSelectedEditors()) {
                context = this.getSelectInContext(fileEditor);
                if (context == null) continue;
                return context;
            }
            return null;
        }

        @Nullable
        private SimpleSelectInContext getSelectInContext(@Nullable FileEditor fileEditor) {
            if (fileEditor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)fileEditor;
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(textEditor.getEditor().getDocument());
                return psiFile == null ? null : new EditorSelectInContext(psiFile, textEditor.getEditor());
            }
            PsiFile psiFile = this.getPsiFile(this.getVirtualFile(fileEditor));
            return psiFile == null ? null : new SimpleSelectInContext(psiFile);
        }

        private PsiFile getPsiFile(VirtualFile file2) {
            return file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)this.myProject).findFile(file2);
        }

        private VirtualFile getVirtualFile(FileEditor fileEditor) {
            return fileEditor == null ? null : FileEditorManagerEx.getInstanceEx(this.myProject).getFile(fileEditor);
        }

        private boolean isCurrentProjectViewPaneFocused() {
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            return pane != null && IJSwingUtilities.hasFocus(pane.getComponentToFocus());
        }

        protected boolean isAutoScrollEnabled() {
            return ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.myCurrentViewId);
        }

        protected void setAutoScrollEnabled(boolean state) {
            ProjectViewImpl.this.setAutoscrollFromSource(state, ProjectViewImpl.this.myCurrentViewId);
            if (state && !this.isCurrentProjectViewPaneFocused()) {
                this.scrollFromSource();
            }
            ProjectViewImpl.this.createToolbarActions();
        }
    }

    private static class SelectionInfo {
        @NotNull
        private final Object[] myElements;

        private SelectionInfo(@NotNull Object[] elements) {
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            if (treeBuilder != null) {
                DefaultTreeModel treeModel = (DefaultTreeModel)((JTree)((Object)tree)).getModel();
                ArrayList<TreePath> paths = new ArrayList<TreePath>(this.myElements.length);
                for (Object element : this.myElements) {
                    DefaultMutableTreeNode node = treeBuilder.getNodeForElement(element);
                    if (node == null) {
                        treeBuilder.buildNodeForElement(element);
                        node = treeBuilder.getNodeForElement(element);
                    }
                    if (node == null) continue;
                    paths.add(new TreePath(treeModel.getPathToRoot(node)));
                }
                if (!paths.isEmpty()) {
                    ((JTree)((Object)tree)).setSelectionPaths(paths.toArray(new TreePath[0]));
                }
            } else {
                List<TreeVisitor> visitors = AbstractProjectViewPane.createVisitors(this.myElements);
                if (1 == visitors.size()) {
                    TreeUtil.promiseSelect((JTree)((Object)tree), (TreeVisitor)visitors.get(0));
                } else if (!visitors.isEmpty()) {
                    TreeUtil.promiseSelect((JTree)((Object)tree), visitors.stream());
                }
            }
        }

        @NotNull
        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path : selectionPaths) {
                    NodeDescriptor descriptor = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path);
                    if (descriptor == null) continue;
                    selectedElements.add(descriptor.getElement());
                }
            }
            return new SelectionInfo(selectedElements.toArray());
        }
    }

    private class HideEmptyMiddlePackagesAction
    extends PaneOptionAction {
        private HideEmptyMiddlePackagesAction() {
            super(ProjectViewImpl.this.myHideEmptyPackages, "", "", null, true);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
            if (ProjectViewImpl.isGlobalOptions()) {
                ProjectViewImpl.getGlobalOptions().setHideEmptyPackages(flag);
            }
            super.setSelected(event, flag);
            selectionInfo.apply(viewPane);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            if (ProjectViewImpl.isGlobalOptions()) {
                return ProjectViewImpl.getGlobalOptions().getHideEmptyPackages();
            }
            return super.isSelected(event);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId)) {
                presentation.setText(IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]));
                presentation.setEnabledAndVisible(true);
            } else {
                presentation.setText(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]));
                presentation.setEnabledAndVisible(!"Scope".equals(ProjectViewImpl.this.myCurrentViewId));
            }
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
            ArrayList snapshot = new ArrayList(ProjectViewImpl.this.myId2Pane.values());
            UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from((Iterable)snapshot).map(pane -> {
                JComponent last = null;
                for (Component c : UIUtil.uiParents((Component)pane.getComponentToFocus(), (boolean)false)) {
                    if (c == this || !(c instanceof JComponent)) {
                        return null;
                    }
                    last = (JComponent)c;
                }
                return last;
            }).filter(Conditions.notNull()).iterator());
        }

        @Nullable
        private Object getSelectedNodeElement() {
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane == null) {
                return null;
            }
            NodeDescriptor descriptor = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)currentProjectViewPane.getSelectedPath());
            if (descriptor == null) {
                return null;
            }
            return descriptor instanceof AbstractTreeNode ? ((AbstractTreeNode)descriptor).getValue() : descriptor.getElement();
        }

        public Object getData(@NotNull String dataId) {
            List selectedElements;
            Object selected;
            PsiElement[] elements;
            Object paneSpecificData;
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane != null && (paneSpecificData = currentProjectViewPane.getData(dataId)) != null) {
                return paneSpecificData;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 1 ? elements[0] : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 0 ? null : elements;
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                VirtualFile[] virtualFiles = (VirtualFile[])this.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName());
                if (virtualFiles == null || virtualFiles.length <= 1) {
                    return null;
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (VirtualFile virtualFile : virtualFiles) {
                    modules.add(ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)ProjectViewImpl.this.myProject));
                }
                return modules.size() == 1 ? modules.iterator().next() : null;
            }
            if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                return null;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                Module[] modules = this.getSelectedModules();
                if (modules != null || !this.getSelectedUnloadedModules().isEmpty()) {
                    return ProjectViewImpl.this.myDeleteModuleProvider;
                }
                final LibraryOrderEntry orderEntry = this.getSelectedLibrary();
                if (orderEntry != null) {
                    return new DeleteProvider(){

                        public void deleteElement(@NotNull DataContext dataContext) {
                            MyPanel.this.detachLibrary(orderEntry, ProjectViewImpl.this.myProject);
                        }

                        public boolean canDeleteElement(@NotNull DataContext dataContext) {
                            return true;
                        }
                    };
                }
                return ProjectViewImpl.this.myDeletePSIElementProvider;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (DATA_KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                return selected instanceof Project ? selected : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                if (selected instanceof Module) {
                    return !((Module)selected).isDisposed() ? selected : null;
                }
                if (selected instanceof PsiDirectory) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)selected).getVirtualFile());
                }
                if (selected instanceof VirtualFile) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)selected);
                }
                return null;
            }
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                return this.getSelectedModules();
            }
            if (ProjectView.UNLOADED_MODULES_CONTEXT_KEY.is(dataId)) {
                return Collections.unmodifiableList(this.getSelectedUnloadedModules());
            }
            if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(ModuleGroup.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[0]);
            }
            if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(LibraryGroupElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[0]);
            }
            if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(NamedLibraryElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[0]);
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                return viewPane == null ? null : viewPane.getSelectedElements();
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            return null;
        }

        @Nullable
        private LibraryOrderEntry getSelectedLibrary() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            TreePath path = viewPane.getSelectedPath();
            if (path == null) {
                return null;
            }
            TreePath parent = path.getParentPath();
            if (parent == null) {
                return null;
            }
            Object userObject = TreeUtil.getLastUserObject((TreePath)parent);
            if (userObject instanceof LibraryGroupNode) {
                userObject = TreeUtil.getLastUserObject((TreePath)path);
                if (userObject instanceof NamedLibraryElementNode) {
                    NamedLibraryElement element = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
                    LibraryOrSdkOrderEntry orderEntry = element.getOrderEntry();
                    return orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
                }
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)((Object)userObject)).getValue();
                VirtualFile virtualFile = directory.getVirtualFile();
                Module module = (Module)((AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)parent.getParentPath())).getValue();
                if (module == null) {
                    return null;
                }
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
                OrderEntry entry = index.getOrderEntryForFile(virtualFile);
                if (entry instanceof LibraryOrderEntry) {
                    return (LibraryOrderEntry)entry;
                }
            }
            return null;
        }

        private void detachLibrary(@NotNull LibraryOrderEntry orderEntry, @NotNull Project project) {
            String title;
            Module module = orderEntry.getOwnerModule();
            String message = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{orderEntry.getPresentableName(), module.getName()});
            int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)(title = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(module.getProject(), () -> {
                Runnable action = () -> {
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                    OrderEntry[] orderEntries = rootManager.getOrderEntries();
                    ModifiableRootModel model = rootManager.getModifiableModel();
                    OrderEntry[] modifiableEntries = model.getOrderEntries();
                    for (int i = 0; i < orderEntries.length; ++i) {
                        OrderEntry entry = orderEntries[i];
                        if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != orderEntry.getLibrary()) continue;
                        model.removeOrderEntry(modifiableEntries[i]);
                    }
                    model.commit();
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }, title, null);
        }

        @Nullable
        private Module[] getSelectedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            Object[] elements = viewPane.getSelectedElements();
            ArrayList<Module> result2 = new ArrayList<Module>();
            for (Object element : elements) {
                Module module;
                if (element instanceof Module) {
                    module = (Module)element;
                    if (module.isDisposed()) continue;
                    result2.add(module);
                    continue;
                }
                if (element instanceof ModuleGroup) {
                    Collection<Module> modules = ((ModuleGroup)element).modulesInGroup(ProjectViewImpl.this.myProject, true);
                    result2.addAll(modules);
                    continue;
                }
                if (element instanceof PsiDirectory) {
                    module = ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)element).getVirtualFile());
                    if (module == null) continue;
                    result2.add(module);
                    continue;
                }
                if (!(element instanceof VirtualFile) || (module = ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)element)) == null) continue;
                result2.add(module);
            }
            return result2.isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
        }

        private List<UnloadedModuleDescription> getSelectedUnloadedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return Collections.emptyList();
            }
            SmartList result2 = new SmartList();
            for (Object element : viewPane.getSelectedElements()) {
                if (element instanceof PsiDirectory) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot(((PsiDirectory)element).getVirtualFile()));
                    continue;
                }
                if (!(element instanceof VirtualFile)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot((VirtualFile)element));
            }
            return result2;
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : this.getElementsToDelete()) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> DeleteHandler.deletePsiElement(elements, ProjectViewImpl.this.myProject));
            }
            finally {
                a.finish();
            }
        }

        @NotNull
        private PsiElement[] getElementsToDelete() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            PsiElement[] elements = viewPane.getSelectedPSIElements();
            for (int idx = 0; idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                PsiElement element = elements[idx];
                if (!(element instanceof PsiDirectory)) continue;
                PsiDirectory directory = (PsiDirectory)element;
                ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject);
                if (ProjectViewImpl.this.isHideEmptyMiddlePackages(viewPane.getId()) && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                    PsiElement[] children2;
                    PsiDirectory parent;
                    while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && !PsiDirectoryFactory.getInstance(ProjectViewImpl.this.myProject).getQualifiedName(parent, false).isEmpty() && ((children2 = parent.getChildren()).length == 0 || children2.length == 1 && children2[0] == directory)) {
                        directory = parent;
                    }
                    elements[idx] = directory;
                }
                if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)ProjectViewImpl.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            return elements;
        }
    }

    private class PaneOptionAction
    extends ToggleAction
    implements DumbAware {
        final Map<String, Boolean> myOptionsMap;
        private final boolean myOptionDefaultValue;

        PaneOptionAction(@NotNull Map<String, Boolean> optionsMap, @NotNull String text, String description, Icon icon, boolean optionDefaultValue) {
            super(text, description, icon);
            this.myOptionsMap = optionsMap;
            this.myOptionDefaultValue = optionDefaultValue;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return ProjectViewImpl.getPaneOptionValue(this.myOptionsMap, ProjectViewImpl.this.myCurrentViewId, this.myOptionDefaultValue);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
        }
    }

    private class ChangeViewAction
    extends AnAction {
        @NotNull
        private final String myId;
        @Nullable
        private final String mySubId;

        private ChangeViewAction(@Nullable String id, String subId) {
            this.myId = id;
            this.mySubId = subId;
        }

        public void update(@NotNull AnActionEvent e) {
            AbstractProjectViewPane pane = ProjectViewImpl.this.getProjectViewPaneById(this.myId);
            e.getPresentation().setText(this.mySubId != null ? pane.getPresentableSubIdName(this.mySubId) : pane.getTitle());
            e.getPresentation().setIcon(this.mySubId != null ? pane.getPresentableSubIdIcon(this.mySubId) : pane.getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProjectViewImpl.this.changeView(this.myId, this.mySubId);
        }
    }
}

