/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.FileNestingInProjectViewDialog;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.scratch.ScratchProjectViewPane;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.Consumer;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "ProjectPane";
    private static final String SHOW_EXCLUDED_FILES_OPTION = "show-excluded-files";
    private static final String USE_FILE_NESTING_RULES = "use-file-nesting-rules";
    boolean myShowExcludedFiles = true;
    private boolean myUseFileNestingRules = true;

    public ProjectViewPane(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public String getTitle() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    @Override
    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        return new ProjectViewTreeUpdater(treeBuilder);
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPaneTreeStructure();
    }

    @Override
    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        return new ProjectViewTree((TreeModel)treeModel){

            public String toString() {
                return ProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public void setFont(Font font) {
                if (Registry.is((String)"bigger.font.in.project.view")) {
                    font = font.deriveFont((float)font.getSize() + 1.0f);
                }
                super.setFont(font);
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return ID;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        super.readExternal(element);
        String showExcludedOption = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_EXCLUDED_FILES_OPTION);
        this.myShowExcludedFiles = showExcludedOption == null || Boolean.parseBoolean(showExcludedOption);
        String useFileNestingRules = JDOMExternalizerUtil.readField((Element)element, (String)USE_FILE_NESTING_RULES);
        this.myUseFileNestingRules = useFileNestingRules == null || Boolean.parseBoolean(useFileNestingRules);
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (!this.myUseFileNestingRules) {
            JDOMExternalizerUtil.writeField((Element)element, (String)USE_FILE_NESTING_RULES, (String)String.valueOf(false));
        }
    }

    @Override
    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)this.createFlattenModulesAction(this::hasSeveralTopLevelModuleNodes)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ConfigureFilesNestingAction()).setAsSecondary(true);
        AnAction editScopesAction = ActionManager.getInstance().getAction("ScopeView.EditScopes");
        if (editScopesAction != null) {
            actionGroup.addAction(editScopesAction).setAsSecondary(true);
        }
    }

    private boolean hasSeveralTopLevelModuleNodes() {
        Object root;
        TreeModel treeModel = this.myTree.getModel();
        int count = treeModel.getChildCount(root = treeModel.getRoot());
        if (count <= 1) {
            return false;
        }
        int moduleNodes = 0;
        for (int i = 0; i < count; ++i) {
            Object node;
            Object child2 = treeModel.getChild(root, i);
            if (!(child2 instanceof DefaultMutableTreeNode) || !((node = ((DefaultMutableTreeNode)child2).getUserObject()) instanceof ProjectViewModuleNode || node instanceof PsiDirectoryNode ? ++moduleNodes > 1 : node instanceof ModuleGroupNode)) continue;
            return true;
        }
        return false;
    }

    boolean isUseFileNestingRules() {
        return this.myUseFileNestingRules;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel model) {
        return null;
    }

    public static boolean canBeSelectedInProjectView(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile archiveFile = file2.getFileSystem() instanceof ArchiveFileSystem ? ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2) : null;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return archiveFile != null && index.getContentRootForFile(archiveFile, false) != null || index.getContentRootForFile(file2, false) != null || index.isInLibrary(file2) || Comparing.equal((Object)file2.getParent(), (Object)project.getBaseDir()) || ScratchProjectViewPane.isScratchesMergedIntoProjectTab() && ScratchUtil.isScratch(file2);
    }

    private class ConfigureFilesNestingAction
    extends DumbAwareAction {
        private ConfigureFilesNestingAction() {
            super(IdeBundle.message((String)"action.file.nesting.in.project.view", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            ProjectView projectView = ProjectView.getInstance(ProjectViewPane.this.myProject);
            e.getPresentation().setEnabledAndVisible(projectView.getCurrentProjectViewPane() == ProjectViewPane.this);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileNestingInProjectViewDialog dialog2 = new FileNestingInProjectViewDialog(ProjectViewPane.this.myProject);
            dialog2.reset(ProjectViewPane.this.myUseFileNestingRules);
            dialog2.show();
            if (dialog2.isOK()) {
                dialog2.apply((Consumer<Boolean>)((Consumer)useFileNestingRules -> ProjectViewPane.this.myUseFileNestingRules = useFileNestingRules));
                ProjectViewPane.this.updateFromRoot(true);
            }
        }
    }

    private class ProjectViewPaneTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        ProjectViewPaneTreeStructure() {
            super(ProjectViewPane.this.myProject, ProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            return new ProjectViewProjectNode(project, settings);
        }

        @Override
        public boolean isShowExcludedFiles() {
            return ProjectView.getInstance(this.myProject).isShowExcludedFiles(ProjectViewPane.ID);
        }

        @Override
        public boolean isUseFileNestingRules() {
            return ProjectViewPane.this.myUseFileNestingRules;
        }

        public boolean isToBuildChildrenInBackground(@NotNull Object element) {
            return Registry.is((String)"ide.projectView.ProjectViewPaneTreeStructure.BuildChildrenInBackground");
        }
    }

    private final class ProjectViewTreeUpdater
    extends AbstractTreeUpdater {
        private ProjectViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(@NotNull Object element) {
            if (element instanceof PsiDirectory && !ProjectViewPane.this.myProject.isDisposed()) {
                boolean addedOk;
                PsiDirectory dirToUpdateFrom;
                PsiDirectory dir = (PsiDirectory)element;
                ProjectTreeStructure treeStructure = (ProjectTreeStructure)ProjectViewPane.this.myTreeStructure;
                if (!treeStructure.isFlattenPackages() && treeStructure.isHideEmptyMiddlePackages() && !DumbService.isDumb((Project)ProjectViewPane.this.myProject)) {
                    for (dirToUpdateFrom = dir; dirToUpdateFrom != null && ProjectViewDirectoryHelper.getInstance(ProjectViewPane.this.myProject).isEmptyMiddleDirectory(dirToUpdateFrom, true); dirToUpdateFrom = dirToUpdateFrom.getParentDirectory()) {
                    }
                }
                while (!(addedOk = super.addSubtreeToUpdateByElement(dirToUpdateFrom == null ? ProjectViewPane.this.myTreeStructure.getRootElement() : dirToUpdateFrom)) && dirToUpdateFrom != null) {
                    dirToUpdateFrom = dirToUpdateFrom.getParentDirectory();
                }
                return addedOk;
            }
            return super.addSubtreeToUpdateByElement(element);
        }
    }
}

