/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectViewToggleAction
extends ToggleAction
implements DumbAware {
    ProjectViewToggleAction(@NotNull String text, @Nullable String description) {
        super(text, description, null);
    }

    abstract boolean isSupported(@NotNull ProjectViewImpl var1, @NotNull String var2);

    abstract boolean isSelected(@NotNull ProjectViewImpl var1, @NotNull String var2);

    abstract void setSelected(@NotNull ProjectViewImpl var1, @NotNull String var2, boolean var3);

    public boolean isSelected(@NotNull AnActionEvent event) {
        ProjectViewImpl view = ProjectViewToggleAction.getProjectView(event);
        String id = view == null ? null : view.getCurrentViewId();
        return id != null && this.isSelected(view, id);
    }

    public void setSelected(@NotNull AnActionEvent event, boolean flag) {
        String id;
        ProjectViewImpl view = ProjectViewToggleAction.getProjectView(event);
        String string = id = view == null ? null : view.getCurrentViewId();
        if (id != null) {
            this.setSelected(view, id, flag);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        ProjectViewImpl view = ProjectViewToggleAction.getProjectView(event);
        String id = view == null ? null : view.getCurrentViewId();
        event.getPresentation().setEnabledAndVisible(id != null && this.isSupported(view, id));
    }

    @Nullable
    private static ProjectViewImpl getProjectView(AnActionEvent event) {
        Project project = event == null ? null : event.getProject();
        ProjectView view = project == null ? null : ProjectView.getInstance(project);
        return view instanceof ProjectViewImpl ? (ProjectViewImpl)view : null;
    }
}

