/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleNode
extends ProjectViewNode<Module>
implements NavigatableWithText {
    protected AbstractModuleNode(Project project, @NotNull Module module, ViewSettings viewSettings) {
        super(project, (Object)module, viewSettings);
    }

    public void update(@NotNull PresentationData presentation) {
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(module.getName());
        if (this.showModuleNameInBold()) {
            presentation.addText(module.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.setIcon(ModuleType.get((Module)module).getIcon());
        presentation.setTooltip(ModuleType.get((Module)module).getName());
    }

    protected boolean showModuleNameInBold() {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Module module = (Module)this.getValue();
        return module != null && !module.isDisposed() ? Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots()) : Collections.emptyList();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (file2.getFileSystem() instanceof JarFileSystem) {
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (local == null) {
                return false;
            }
            file2 = local;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void navigate(boolean requestFocus) {
        Module module = (Module)this.getValue();
        if (module != null && !module.isDisposed()) {
            ProjectSettingsService.getInstance(this.myProject).openModuleSettings(module);
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }

    public boolean canNavigate() {
        if (!ProjectSettingsService.getInstance(this.myProject).canOpenModuleSettings()) {
            return false;
        }
        Module module = (Module)this.getValue();
        return module != null && !module.isDisposed();
    }

    public String getTestPresentation() {
        return "Module";
    }
}

