/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project, @NotNull Value value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected abstract void updateImpl(@NotNull PresentationData var1);

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        return (Collection)AstLoadingFilter.disallowTreeLoading(this::doGetChildren);
    }

    @NotNull
    private Collection<AbstractTreeNode> doGetChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return new ArrayList<AbstractTreeNode>();
        }
        if (!psiElement.isValid()) {
            LOG.error((Throwable)new IllegalStateException("Node contains invalid PSI: \n" + ((Object)((Object)this)).getClass() + " [" + (Object)((Object)this) + "]\n" + psiElement.getClass() + " [" + psiElement + "]"));
            return Collections.emptyList();
        }
        Collection<AbstractTreeNode> children2 = this.getChildrenImpl();
        return children2 != null ? children2 : Collections.emptyList();
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        return AbstractPsiBasedNode.computeFileStatus(this.getVirtualFileForValue(), Objects.requireNonNull(this.getProject()));
    }

    protected static FileStatus computeFileStatus(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
    }

    public void update(@NotNull PresentationData data) {
        AstLoadingFilter.disallowTreeLoading(() -> this.doUpdate(data));
    }

    private void doUpdate(@NotNull PresentationData data) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.validate()) {
                return;
            }
            PsiElement value = this.extractPsiFromValue();
            LOG.assertTrue(value.isValid());
            int flags = this.getIconableFlags();
            try {
                Icon icon = value.getIcon(flags);
                data.setIcon(icon);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            data.setPresentableText(this.myName);
            try {
                if (this.isDeprecated()) {
                    data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            this.updateImpl(data);
            data.setIcon(AbstractPsiBasedNode.patchIcon(this.myProject, data.getIcon(true), this.getVirtualFile()));
            CompoundProjectViewNodeDecorator.get(this.myProject).decorate(this, data);
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags;
        int n = flags = Registry.is((String)"ide.projectView.show.visibility") ? 1 : 0;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    @Nullable
    public static Icon patchIcon(@NotNull Project project, @Nullable Icon original, @Nullable VirtualFile file2) {
        if (file2 == null || original == null) {
            return original;
        }
        Icon icon = original;
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(project).findFileBookmark(file2);
        if (bookmarkAtFile != null) {
            RowIcon composite = new RowIcon(2, RowIcon.Alignment.CENTER);
            composite.setIcon(icon, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            icon = composite;
        }
        if (!file2.isWritable()) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.LOCKED_ICON);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        return icon;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return file2.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(requestFocus);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }
}

