/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NestingTreeNode
extends PsiFileNode {
    @NotNull
    private final Collection<? extends PsiFileNode> myChildNodes;

    public NestingTreeNode(@NotNull PsiFileNode originalNode, @NotNull Collection<? extends PsiFileNode> childNodes) {
        super(originalNode.getProject(), (PsiFile)originalNode.getValue(), originalNode.getSettings());
        this.myChildNodes = childNodes;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>(this.myChildNodes.size());
        for (PsiFileNode psiFileNode : this.myChildNodes) {
            PsiFile value = (PsiFile)psiFileNode.getValue();
            if (value == null) continue;
            result2.add((AbstractTreeNode)new PsiFileNode(psiFileNode.getProject(), value, psiFileNode.getSettings()));
        }
        Collection<AbstractTreeNode> superChildren = super.getChildrenImpl();
        if (superChildren != null) {
            result2.addAll(superChildren);
        }
        return result2;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (super.contains(file2)) {
            return true;
        }
        for (PsiFileNode psiFileNode : this.myChildNodes) {
            PsiFile psiFile = (PsiFile)psiFileNode.getValue();
            if (psiFile == null || !file2.equals(psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }
}

