/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewModuleNode
extends AbstractModuleNode {
    public ProjectViewModuleNode(Project project, @NotNull Module value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            return Collections.emptyList();
        }
        List<VirtualFile> contentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module, this.getSettings());
        return ProjectViewDirectoryHelper.getInstance(this.myProject).createFileAndDirectoryNodes(contentRoots, this.getSettings());
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }
}

