/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticLibraryElementNode
extends ProjectViewNode<SyntheticLibrary>
implements NavigatableWithText {
    @NotNull
    private final ItemPresentation myItemPresentation;

    public SyntheticLibraryElementNode(@NotNull Project project, @NotNull SyntheticLibrary library, @NotNull ItemPresentation itemPresentation, ViewSettings settings) {
        super(project, (Object)library, settings);
        this.myItemPresentation = itemPresentation;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.getLibrary().contains(file2);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        SyntheticLibrary library = this.getLibrary();
        Project project = Objects.requireNonNull(this.getProject());
        Set<VirtualFile> excludedRoots = library.getExcludedRoots();
        List children2 = ContainerUtil.filter(library.getAllRoots(), file2 -> file2.isValid() && !excludedRoots.contains(file2));
        return ProjectViewDirectoryHelper.getInstance(project).createFileAndDirectoryNodes(children2, this.getSettings());
    }

    public String getName() {
        return this.myItemPresentation.getPresentableText();
    }

    @NotNull
    private SyntheticLibrary getLibrary() {
        return (SyntheticLibrary)Objects.requireNonNull(this.getValue());
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.updateFrom(this.myItemPresentation);
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        NavigatableWithText navigatable = (NavigatableWithText)ObjectUtils.tryCast((Object)this.getLibrary(), NavigatableWithText.class);
        return navigatable != null ? navigatable.getNavigateActionText(focusEditor) : null;
    }

    public boolean canNavigate() {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        return navigatable != null && navigatable.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        return navigatable != null && navigatable.canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }
}

