/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class EditScopesAction
extends AnAction
implements DumbAware {
    public EditScopesAction() {
        super(AllIcons.Ide.LocalScope);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ProjectView view;
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        ProjectView projectView = view = project == null ? null : ProjectView.getInstance(project);
        if (view != null) {
            ScopeChooserConfigurable configurable = new ScopeChooserConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
                NamedScopeFilter filter;
                AbstractProjectViewPane pane = view.getCurrentProjectViewPane();
                if (pane instanceof ScopeViewPane && (filter = ((ScopeViewPane)pane).getFilter(pane.getSubId())) != null) {
                    configurable.selectNodeInTree(filter.getScope().getName());
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        ProjectView view = project == null ? null : ProjectView.getInstance(project);
        event.getPresentation().setEnabledAndVisible(view != null && view.getProjectViewPaneById("Scope") != null);
    }
}

