/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class NamedScopeFilter
implements VirtualFileFilter {
    private static final Logger LOG = Logger.getInstance(NamedScopeFilter.class);
    private final NamedScopesHolder holder;
    private final NamedScope scope;
    private final String string;

    public NamedScopeFilter(@NotNull NamedScopesHolder holder, @NotNull NamedScope scope) {
        this.holder = holder;
        this.scope = scope;
        this.string = scope + "; " + scope.getClass();
    }

    @NotNull
    public NamedScopesHolder getHolder() {
        return this.holder;
    }

    @NotNull
    public NamedScope getScope() {
        return this.scope;
    }

    @NotNull
    public String toString() {
        return this.string;
    }

    public boolean accept(VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        PackageSet set2 = this.scope.getValue();
        if (set2 == null) {
            return false;
        }
        Project project = this.holder.getProject();
        if (set2 instanceof PackageSetBase) {
            PackageSetBase base = (PackageSetBase)set2;
            return base.contains(file2, project, this.holder);
        }
        PsiFile psiFile = PackageSetBase.getPsiFile((VirtualFile)file2, (Project)project);
        return psiFile != null && set2.contains(psiFile, this.holder);
    }

    static boolean isVisible(@NotNull NamedScope scope) {
        return !(scope instanceof NonProjectFilesScope) && !(scope instanceof ScratchesNamedScope) && scope != CustomScopesProviderEx.getAllScope();
    }

    @NotNull
    static List<NamedScopeFilter> list(NamedScopesHolder ... holders) {
        return NamedScopeFilter.list(NamedScopeFilter::isVisible, holders);
    }

    @NotNull
    static List<NamedScopeFilter> list(@NotNull Predicate<? super NamedScope> visible, NamedScopesHolder ... holders) {
        ArrayList<NamedScopeFilter> list2 = new ArrayList<NamedScopeFilter>();
        for (NamedScopesHolder holder : holders) {
            for (NamedScope scope : holder.getScopes()) {
                String name = scope.getName();
                if (null == scope.getValue()) {
                    LOG.debug("ignore scope without package set: ", new Object[]{name, "; holder: ", holder});
                    continue;
                }
                if (!visible.test((NamedScope)scope)) {
                    LOG.debug("ignore hidden scope: ", new Object[]{name, "; holder: ", holder});
                    continue;
                }
                list2.add(new NamedScopeFilter(holder, scope));
            }
        }
        return list2;
    }
}

