/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.SCOPE;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        ProjectRootManager manager;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)fileSystemItem);
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        ProjectRootManager projectRootManager = manager = this.myProject.isDisposed() ? null : ProjectRootManager.getInstance((Project)this.myProject);
        if (manager == null || null == manager.getFileIndex().getModuleForFile(file2)) {
            return false;
        }
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        return this.getContainingFilter((PsiFile)fileSystemItem) != null;
    }

    @Nullable
    private NamedScopeFilter getContainingFilter(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        if (ScratchUtil.isScratch(file2.getVirtualFile())) {
            return null;
        }
        ScopeViewPane pane = this.getScopeViewPane();
        if (pane == null) {
            return null;
        }
        for (NamedScopeFilter filter : pane.getFilters()) {
            if (!filter.accept(file2.getVirtualFile())) continue;
            return filter;
        }
        return null;
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        if (this.getSubId() == null) {
            NamedScopeFilter filter = this.getContainingFilter(element.getContainingFile());
            if (filter == null) {
                return;
            }
            this.setSubId(filter.toString());
        }
        super.select(element, requestFocus);
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    public boolean isSubIdSelectable(@NotNull String subId, @NotNull SelectInContext context) {
        PsiFileSystemItem file2 = this.getContextPsiFile(context);
        if (!(file2 instanceof PsiFile)) {
            return false;
        }
        ScopeViewPane pane = this.getScopeViewPane();
        NamedScopeFilter filter = pane == null ? null : pane.getFilter(subId);
        return filter != null && filter.accept(file2.getVirtualFile());
    }

    private ScopeViewPane getScopeViewPane() {
        ProjectView view = ProjectView.getInstance(this.myProject);
        AbstractProjectViewPane pane = view == null ? null : view.getProjectViewPaneById("Scope");
        return pane instanceof ScopeViewPane ? (ScopeViewPane)pane : null;
    }
}

