/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.pom.NavigatableWithText;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.search.scope.ProblemsScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileTreeModel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeViewTreeModel
extends BaseTreeModel<AbstractTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ScopeViewTreeModel.class);
    private volatile Comparator<? super NodeDescriptor> comparator;
    private final ProjectFileTreeModel model;
    private final ProjectNode root;

    ScopeViewTreeModel(@NotNull Project project, @NotNull ViewSettings settings) {
        this.model = new ProjectFileTreeModel(project);
        this.model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (type == TreeModelAdapter.EventType.StructureChanged) {
                    TreePath path = event.getTreePath();
                    if (path == null || null == path.getParentPath()) {
                        ScopeViewTreeModel.this.invalidate(null);
                    } else {
                        Object component = path.getLastPathComponent();
                        if (component instanceof ProjectFileNode) {
                            ProjectFileNode node = (ProjectFileNode)component;
                            ScopeViewTreeModel.this.notifyStructureChanged(node.getVirtualFile());
                        }
                    }
                }
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.model);
        this.root = new ProjectNode(project, settings);
        project.getMessageBus().connect((Disposable)this).subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                this.problemsDisappeared(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                NamedScopeFilter filter = ScopeViewTreeModel.this.getFilter();
                if (filter != null && filter.getScope() instanceof ProblemsScope) {
                    ScopeViewTreeModel.this.model.setFilter(filter);
                } else {
                    ScopeViewTreeModel.this.notifyPresentationChanged(file2);
                }
            }
        });
        FileStatusManager.getInstance((Project)project).addFileStatusListener(new FileStatusListener(){

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                ScopeViewTreeModel.this.notifyPresentationChanged(file2);
            }

            public void fileStatusesChanged() {
                ScopeViewTreeModel.this.invalidate(null);
            }
        }, (Disposable)this);
        CopyPasteUtil.addDefaultListener((Disposable)this, element -> {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file2 != null) {
                this.notifyPresentationChanged(file2);
            }
        });
    }

    void setStructureProvider(TreeStructureProvider provider) {
        this.model.onValidThread(() -> {
            if (this.root.provider == null && provider == null) {
                return;
            }
            this.root.provider = provider;
            this.treeStructureChanged(null, null, null);
        });
    }

    void setNodeDecorator(ProjectViewNodeDecorator decorator) {
        this.model.onValidThread(() -> {
            if (this.root.decorator == null && decorator == null) {
                return;
            }
            this.root.decorator = decorator;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setComparator(Comparator<? super NodeDescriptor> comparator2) {
        this.model.onValidThread(() -> {
            if (this.comparator == null && comparator2 == null) {
                return;
            }
            this.comparator = comparator2;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setFilter(@Nullable NamedScopeFilter filter) {
        this.root.filter = filter;
        LOG.debug("set filter", new Object[]{filter});
        this.model.setFilter((VirtualFileFilter)(filter != null && filter.getScope() instanceof ProjectFilesScope ? null : filter));
    }

    public NamedScopeFilter getFilter() {
        return this.root.filter;
    }

    @Nullable
    public Object getContent(Object object) {
        Node node;
        if (object instanceof GroupNode) {
            node = (GroupNode)((Object)object);
            object = ((GroupNode)node).getSingleRoot();
        }
        if (object instanceof FileNode) {
            node = (FileNode)((Object)object);
            PsiFileSystemItem element = node.findFileSystemItem(((FileNode)node).getVirtualFile());
            if (element == null || ((FileNode)node).compacted == null) {
                return element;
            }
            if (ScopeViewTreeModel.isPackage(node.getIcon()) && node.getSettings().isFlattenPackages()) {
                return element;
            }
            ArrayDeque<PsiFileSystemItem> deque = new ArrayDeque<PsiFileSystemItem>();
            ((FileNode)node).compacted.forEach(arg_0 -> ScopeViewTreeModel.lambda$getContent$4((FileNode)node, deque, arg_0));
            if (deque.isEmpty()) {
                return element;
            }
            deque.addFirst(element);
            return deque.toArray();
        }
        if (object instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)object;
            object = descriptor.getElement();
        }
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        return object;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.model.getInvoker();
    }

    public void invalidate(@Nullable Runnable onDone) {
        this.model.onValidThread(() -> {
            this.root.childrenValid = false;
            LOG.debug("whole structure changed");
            ViewSettings settings = this.root.getSettings();
            boolean isShowExcludedFiles = false;
            if (settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles()) {
                NamedScopeFilter filter = this.getFilter();
                Class<?> type = filter == null ? null : filter.getScope().getClass();
                isShowExcludedFiles = !NamedScope.class.equals(type);
            }
            this.model.setSettings(isShowExcludedFiles, ShowModulesAction.hasModules() && settings.isShowModules());
            this.treeStructureChanged(null, null, null);
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void update(@NotNull AbstractTreeNode node, boolean structure) {
        this.model.onValidThread(() -> {
            boolean changed;
            boolean updated = node.update();
            boolean bl = changed = structure || !(node instanceof Node);
            if (!updated && !changed) {
                return;
            }
            TreePath path = TreePathUtil.pathToCustomNode(node, AbstractTreeNode::getParent);
            if (path == null || this.root != path.getPathComponent(0)) {
                return;
            }
            if (changed) {
                LOG.debug("structure changed: ", new Object[]{node});
                this.treeStructureChanged(path, null, null);
            } else {
                LOG.debug("node updated: ", new Object[]{node});
                this.treeNodesChanged(path, null, null);
            }
        });
    }

    private void notifyStructureChanged(@NotNull VirtualFile file2) {
        boolean flattenPackages = this.root.getSettings().isFlattenPackages();
        if (flattenPackages) {
            VirtualFile ancestor;
            ProjectFileIndex index = ScopeViewTreeModel.getProjectFileIndex(this.root.getProject());
            VirtualFile virtualFile = ancestor = index == null ? null : index.getSourceRootForFile(file2);
            if (ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
                file2 = ancestor;
            } else {
                flattenPackages = false;
            }
        }
        boolean resolveCompactedFolder = !flattenPackages && file2.isDirectory() && this.root.getSettings().isCompactDirectories();
        this.find(file2, null, (Consumer<Object>)((Consumer)found -> {
            if (found instanceof Node) {
                AbstractTreeNode parent;
                Node node = (Node)((Object)((Object)found));
                if (resolveCompactedFolder && (parent = node.getParent()) instanceof Node) {
                    node = (Node)parent;
                }
                if (node.childrenValid) {
                    node.childrenValid = false;
                    this.update((AbstractTreeNode)node, true);
                }
            } else if (found instanceof AbstractTreeNode) {
                this.update((AbstractTreeNode)found, true);
            }
        }));
    }

    private void notifyPresentationChanged(@NotNull VirtualFile file2) {
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList list2 = new SmartList();
        this.find(file2, (List<? super Node>)list2, (Consumer<Object>)((Consumer)arg_0 -> this.lambda$notifyPresentationChanged$9((List)list2, arg_0)));
    }

    private void find(@NotNull VirtualFile file2, final @Nullable List<? super Node> list2, @NotNull Consumer<Object> consumer) {
        this.model.onValidThread(() -> {
            final AreaInstance area = ProjectFileNode.findArea(file2, this.root.getProject());
            if (area != null) {
                TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode> visitor = new TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode>(file2, AbstractTreeNode.class){

                    protected boolean matches(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        if (pathComponent.canRepresent((Object)thisComponent)) {
                            return true;
                        }
                        if (pathComponent instanceof Node) {
                            return false;
                        }
                        ProjectViewNode node = pathComponent instanceof ProjectViewNode ? (ProjectViewNode)pathComponent : null;
                        return node != null && node.contains(thisComponent);
                    }

                    protected boolean contains(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        Node node;
                        Node node2 = node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        if (node == null || !node.contains(thisComponent, area)) {
                            return false;
                        }
                        if (list2 != null) {
                            list2.add(node);
                        }
                        return true;
                    }
                };
                AbstractTreeWalker<AbstractTreeNode> walker = new AbstractTreeWalker<AbstractTreeNode>((TreeVisitor)visitor){

                    @Override
                    protected Collection<AbstractTreeNode> getChildren(@NotNull AbstractTreeNode pathComponent) {
                        Node node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        return node != null && node.childrenValid ? node.children : Collections.emptyList();
                    }
                };
                walker.start((AbstractTreeNode)this.root);
                walker.promise().onProcessed(path -> consumer.consume(path == null ? null : path.getLastPathComponent()));
            }
        });
    }

    public Object getRoot() {
        if (!this.model.isValidThread()) {
            return null;
        }
        this.root.update();
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof AbstractTreeNode && this.model.isValidThread()) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            return node.getChildren().size();
        }
        return 0;
    }

    @Override
    @NotNull
    public List<AbstractTreeNode> getChildren(Object object) {
        AbstractTreeNode parent;
        Collection children2;
        if (object instanceof AbstractTreeNode && this.model.isValidThread() && !(children2 = (parent = (AbstractTreeNode)object).getChildren()).isEmpty()) {
            SmartList result2 = new SmartList();
            children2.forEach(arg_0 -> ScopeViewTreeModel.lambda$getChildren$12(parent, (List)result2, arg_0));
            Comparator<? super NodeDescriptor> comparator2 = this.comparator;
            if (comparator2 != null) {
                result2.sort(comparator2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    ErrorStripe getStripe(Object object, boolean expanded) {
        if (expanded && object instanceof Node) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node.getPresentation().getTextAttributesKey();
            TextAttributes attributes = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes == null ? null : attributes.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create(color, 1);
            }
        }
        return null;
    }

    @Nullable
    private static WolfTheProblemSolver getWolfTheProblemSolver(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : WolfTheProblemSolver.getInstance((Project)project);
    }

    @Nullable
    private static FileStatusManager getFileStatusManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : FileStatusManager.getInstance((Project)project);
    }

    @Nullable
    private static ModuleManager getModuleManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ModuleManager.getInstance((Project)project);
    }

    @Nullable
    private static ProjectFileIndex getProjectFileIndex(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectFileIndex.getInstance((Project)project);
    }

    @Nullable
    private static ModuleRootManager getModuleRootManager(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : ModuleRootManager.getInstance((Module)module);
    }

    @Nullable
    private static ProjectSettingsService getProjectSettingsService(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectSettingsService.getInstance(project);
    }

    @Nullable
    private static Module getModule(@NotNull VirtualFile file2, @Nullable Project project) {
        ProjectFileIndex index = ScopeViewTreeModel.getProjectFileIndex(project);
        return index == null ? null : index.getModuleForFile(file2);
    }

    private static boolean hasModuleGroups(@Nullable Project project) {
        if (Registry.is((String)"project.qualified.module.names")) {
            return true;
        }
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        return manager != null && manager.hasModuleGroups();
    }

    @NotNull
    private static List<String> getModuleNameAsList(@NotNull Module module, boolean split) {
        String name = module.getName();
        Project project = module.isDisposed() ? null : module.getProject();
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        if (manager != null) {
            if (manager.hasModuleGroups()) {
                Object[] path = manager.getModuleGroupPath(module);
                if (path != null && path.length != 0) {
                    SmartList list2 = new SmartList(path);
                    list2.add(name);
                    return list2;
                }
            } else if (split) {
                return StringUtil.split((String)name, (String)".");
            }
        }
        return new SmartList((Object)name);
    }

    @Nullable
    private static List<VirtualFile> getCompactedFolders(@Nullable VirtualFile ancestor, @NotNull VirtualFile file2) {
        if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            return null;
        }
        ArrayDeque<VirtualFile> deque = new ArrayDeque<VirtualFile>();
        while ((file2 = file2.getParent()) != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            deque.addFirst(file2);
        }
        return deque.isEmpty() ? null : new SmartList(deque);
    }

    private static boolean isFolder(@Nullable Icon icon) {
        return ScopeViewTreeModel.is(icon, AllIcons.Nodes.Folder);
    }

    private static boolean isPackage(@Nullable Icon icon) {
        return ScopeViewTreeModel.is(icon, AllIcons.Nodes.Package);
    }

    private static boolean is(@Nullable Icon icon, @NotNull Icon expected) {
        if (expected.equals(icon)) {
            return true;
        }
        if (icon instanceof RowIcon) {
            RowIcon rowIcon = (RowIcon)icon;
            return expected.equals(rowIcon.getIcon(0));
        }
        return false;
    }

    private static /* synthetic */ void lambda$getChildren$12(AbstractTreeNode parent, List result2, Object child2) {
        if (child2 instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)child2;
            node.setParent(parent);
            node.update();
            result2.add(node);
        }
    }

    private /* synthetic */ void lambda$notifyPresentationChanged$9(List list2, Object found) {
        list2.forEach(node -> this.update((AbstractTreeNode)node, false));
        if (found instanceof AbstractTreeNode) {
            this.update((AbstractTreeNode)found, false);
        }
    }

    private static /* synthetic */ void lambda$getContent$4(FileNode node, ArrayDeque deque, VirtualFile file2) {
        PsiFileSystemItem item = node.findFileSystemItem(file2);
        if (item != null) {
            deque.addFirst(item);
        }
    }

    private static final class Mapper<N extends Node, V> {
        private final Map<Object, N> map;
        private final BiFunction<? super Node, ? super V, ? extends N> creator;

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Map<Object, N> map2) {
            this.creator = creator;
            this.map = map2;
        }

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Class<? extends N> type, @NotNull Collection<? extends AbstractTreeNode> list2) {
            this(creator, new HashMap());
            list2.forEach(node -> {
                Object id = node.getValue();
                if (id != null && type.isInstance(node)) {
                    this.map.put(id, type.cast(node));
                }
            });
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value) {
            return this.apply(parent, value, null);
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value, @Nullable Icon icon) {
            Node node;
            Node node2 = node = this.map.isEmpty() ? null : (Node)((Object)this.map.get(value));
            if (node == null) {
                node = (Node)((Object)this.creator.apply(parent, value));
            }
            node.setIcon(icon);
            node.childrenValid = false;
            return (N)((Object)node);
        }
    }

    private static final class Group {
        private final Object id;
        private final HashMap<Object, Group> groups = new HashMap();
        private final List<RootNode> roots = new SmartList();

        private Group(@NotNull String name) {
            this.id = name;
        }

        private Group(@NotNull Module module) {
            this.id = module;
        }

        Group(@NotNull Collection<RootNode> nodes, boolean flatten) {
            this.id = null;
            if (!nodes.isEmpty()) {
                HashMap<Module, Group> map2 = new HashMap<Module, Group>();
                nodes.forEach(node -> {
                    Object id = node.node.getRootID();
                    if (id instanceof Module) {
                        Module module = (Module)id;
                        Group group = (Group)map2.get(module);
                        if (group == null) {
                            group = new Group(module);
                            map2.put(module, group);
                        }
                        group.roots.add((RootNode)((Object)node));
                    } else {
                        this.roots.add((RootNode)((Object)node));
                    }
                });
                if (flatten) {
                    this.groups.putAll(map2);
                } else {
                    map2.forEach((module, group) -> {
                        List path = ScopeViewTreeModel.getModuleNameAsList(module, Registry.is((String)"project.qualified.module.names"));
                        group.roots.forEach(node -> this.add((RootNode)((Object)((Object)node)), path, 0));
                    });
                }
            }
        }

        private void add(RootNode node, List<String> path, int index) {
            if (index < path.size()) {
                String name = path.get(index);
                Group group = this.groups.get(name);
                if (group == null) {
                    group = new Group(name);
                    this.groups.put(name, group);
                }
                group.add(node, path, index + 1);
            } else {
                this.roots.add(node);
            }
        }

        @NotNull
        Icon getIcon() {
            if (!this.groups.isEmpty() || this.roots.isEmpty()) {
                return AllIcons.Nodes.ModuleGroup;
            }
            Object id = this.roots.get((int)0).node.getRootID();
            if (this.roots.stream().anyMatch(root -> !root.node.getRootID().equals(id))) {
                return AllIcons.Nodes.ModuleGroup;
            }
            if (id instanceof Module) {
                ModuleType type = ModuleType.get((Module)((Module)id));
                Icon icon = type.getIcon();
                if (icon != null) {
                    return icon;
                }
                LOG.warn(type.getName() + " type have no icon for " + id);
            }
            return AllIcons.Nodes.Module;
        }

        @Nullable
        RootNode getFirstRoot() {
            if (!this.roots.isEmpty()) {
                return this.roots.get(0);
            }
            for (Group group : this.groups.values()) {
                RootNode root = group.getFirstRoot();
                if (root == null) continue;
                return root;
            }
            return null;
        }

        @Nullable
        RootNode getSingleRoot() {
            if (!this.groups.isEmpty() || this.roots.size() != 1) {
                return null;
            }
            RootNode node = this.roots.get(0);
            ModuleRootManager manager = ScopeViewTreeModel.getModuleRootManager(ScopeViewTreeModel.getModule(node.getVirtualFile(), node.getProject()));
            if (manager == null) {
                return null;
            }
            for (VirtualFile file2 : manager.getSourceRoots()) {
                if (VfsUtilCore.isAncestor((VirtualFile)node.getVirtualFile(), (VirtualFile)file2, (boolean)true)) continue;
                return null;
            }
            return node;
        }

        @Nullable
        private Group getSingleGroup() {
            if (!this.roots.isEmpty() || this.groups.size() != 1) {
                return null;
            }
            return this.groups.values().stream().findFirst().orElse(null);
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<? extends AbstractTreeNode> old) {
            Mapper<GroupNode, Object> mapper = new Mapper<GroupNode, Object>(GroupNode::new, GroupNode.class, old);
            ModuleManager manager = ScopeViewTreeModel.getModuleManager(parent.getProject());
            char separator = manager != null && manager.hasModuleGroups() ? (char)'/' : '.';
            boolean compactDirectories = parent.getSettings().isCompactDirectories();
            SmartList children2 = new SmartList();
            for (Group group : this.groups.values()) {
                Group single;
                Object id = group.id;
                Group group2 = single = !compactDirectories ? null : group.getSingleGroup();
                if (single != null) {
                    StringBuilder sb = new StringBuilder(id.toString());
                    do {
                        group = single;
                        sb.append(separator).append(group.id);
                    } while ((single = single.getSingleGroup()) != null);
                    id = sb.toString();
                }
                GroupNode node = mapper.apply(parent, id);
                node.setGroup(group);
                children2.add(node);
            }
            children2.addAll(this.roots);
            return children2;
        }

        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            return this.roots.stream().anyMatch(root -> root.canRepresentOrContain(file2, area)) || this.groups.values().stream().anyMatch(group -> group.contains(file2, area));
        }
    }

    private static final class GroupNode
    extends Node
    implements NavigatableWithText {
        private final String prefix;
        private final String name;
        private Group group;

        GroupNode(@NotNull Node parent, @NotNull Object value) {
            super(parent, value);
            if (value instanceof Module) {
                List list2 = ScopeViewTreeModel.getModuleNameAsList((Module)value, false);
                int index = list2.size() - 1;
                if (index > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < index; ++i) {
                        sb.append((String)list2.get(i)).append('/');
                    }
                    this.prefix = sb.toString();
                    this.name = (String)list2.get(index);
                } else {
                    this.prefix = null;
                    this.name = index < 0 ? "UNEXPECTED" : (String)list2.get(index);
                }
            } else {
                this.prefix = null;
                this.name = value.toString();
            }
        }

        void setGroup(@NotNull Group group) {
            this.group = group;
            this.childrenValid = false;
            this.setIcon(group.getIcon());
        }

        @Nullable
        RootNode getSingleRoot() {
            Group group = this.group;
            return group == null ? null : group.getSingleRoot();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getVirtualFile();
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setIcon(this.getIcon());
            if (this.prefix != null) {
                presentation.addText(this.prefix, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            presentation.addText(this.name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getTitle();
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            Group group = this.group;
            if (group == null) {
                return Collections.emptyList();
            }
            RootNode node = group.getSingleRoot();
            if (node == null) {
                return group.createChildren(this, old);
            }
            node.setParent((AbstractTreeNode)this);
            return node.getChildren();
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            Group group = this.group;
            return group != null && group.contains(file2, area);
        }

        public boolean canNavigate() {
            Group group = this.group;
            RootNode node = group == null ? null : group.getFirstRoot();
            return node != null && node.canNavigate();
        }

        public void navigate(boolean requestFocus) {
            RootNode node;
            Group group = this.group;
            RootNode rootNode = node = group == null ? null : group.getFirstRoot();
            if (node != null) {
                node.navigate(requestFocus);
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 2;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public String toString() {
            return this.prefix != null ? this.prefix + this.name : this.name;
        }
    }

    private static final class RootNode
    extends FileNode
    implements NavigatableWithText {
        RootNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            super(parent, node);
        }

        boolean canRepresentOrContain(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            return this.node.contains(file2, area, false);
        }

        @Override
        public int getWeight() {
            return this.node.getRootID() instanceof Project ? 0 : super.getWeight();
        }

        @Override
        public int getTypeSortWeight(boolean sortByType) {
            return this.node.getRootID() instanceof Project ? 1 : super.getTypeSortWeight(sortByType);
        }

        @NotNull
        public String getTitle() {
            return this.getLocation(false);
        }

        @Override
        @NotNull
        protected String getNodeName() {
            return this.getLocation(true);
        }

        @NotNull
        private String getLocation(boolean allowEmpty) {
            String location;
            VirtualFile dir = ProjectFileNode.findBaseDir(this.getProject());
            String string = location = dir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)this.getVirtualFile(), (VirtualFile)dir);
            if (location != null && (allowEmpty || !location.isEmpty())) {
                return location;
            }
            return FileUtil.getLocationRelativeToUserHome((String)this.getVirtualFile().getPresentableUrl());
        }

        public boolean canNavigate() {
            return null != ScopeViewTreeModel.getProjectSettingsService(this.getProject());
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService service2 = ScopeViewTreeModel.getProjectSettingsService(this.getProject());
            if (service2 != null) {
                Module module = ScopeViewTreeModel.getModule(this.getVirtualFile(), this.getProject());
                if (module != null && service2.canOpenModuleSettings()) {
                    service2.openModuleSettings(module);
                } else {
                    service2.openProjectSettings();
                }
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }
    }

    private static class FileNode
    extends Node {
        final List<VirtualFile> compacted;
        final ProjectFileNode node;

        FileNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            super(parent, node);
            this.node = node;
            this.compacted = ScopeViewTreeModel.getCompactedFolders(parent.getVirtualFile(), node.getVirtualFile());
            this.myName = node.getVirtualFile().getName();
        }

        protected void update(@NotNull PresentationData presentation) {
            ProjectFileIndex index;
            this.myName = this.getNodeName();
            VirtualFile file2 = this.getVirtualFile();
            String title = this.getTitle();
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (this.node.getRootID() instanceof VirtualFile && (index = ScopeViewTreeModel.getProjectFileIndex(this.getProject())) != null && file2.equals(index.getContentRootForFile(file2))) {
                attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            String text = title != null ? title : this.toString();
            presentation.setPresentableText(text);
            presentation.addText(text, attributes);
            Icon icon = this.getIcon();
            if (icon == null && file2.isValid()) {
                icon = file2.isDirectory() ? FileNode.getFolderIcon((PsiElement)this.findFileSystemItem(file2)) : file2.getFileType().getIcon();
            }
            presentation.setIcon(icon);
            this.decorate(presentation);
        }

        protected boolean valueIsCut() {
            return CopyPasteManager.getInstance().isCutElement((Object)this.findFileSystemItem(this.getVirtualFile()));
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            ProjectNode parent = this.findParent(ProjectNode.class);
            if (parent == null) {
                return Collections.emptyList();
            }
            return parent.createChildren(this, old);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean canRepresent(@NotNull VirtualFile file2) {
            if (super.canRepresent(file2)) return true;
            if (this.compacted == null) return false;
            if (!this.compacted.stream().anyMatch(file2::equals)) return false;
            return true;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            return this.node.contains(file2, area, true);
        }

        public FileStatus getFileStatus() {
            FileStatusManager manager = ScopeViewTreeModel.getFileStatusManager(this.getProject());
            return manager == null ? FileStatus.NOT_CHANGED : manager.getRecursiveStatus(this.getVirtualFile());
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            return this.node.getVirtualFile();
        }

        @Override
        public int getWeight() {
            ViewSettings settings;
            if (this.getVirtualFile().isDirectory() && ((settings = this.getSettings()) == null || settings.isFoldersAlwaysOnTop())) {
                return 0;
            }
            return 20;
        }

        public int getTypeSortWeight(boolean sortByType) {
            return this.getVirtualFile().isDirectory() ? 3 : 5;
        }

        @NotNull
        protected String getNodeName() {
            return this.getNodeName(this.getPackageName());
        }

        @NotNull
        private String getNodeName(@Nullable String name) {
            if (name != null) {
                String prefix;
                AbstractTreeNode parent = this.getParent();
                FileNode node = parent instanceof FileNode ? (FileNode)parent : null;
                String string = prefix = node == null ? null : node.getPackageName();
                if (prefix == null) {
                    return name;
                }
                int length = prefix.length();
                if (length > 0 && name.startsWith(prefix)) {
                    if (length < name.length() && '.' == name.charAt(length)) {
                        ++length;
                    }
                    if (length < name.length()) {
                        return name.substring(length);
                    }
                }
                LOG.info("unexpected prefix: " + prefix + " for package: " + name);
            }
            if (this.compacted != null) {
                StringBuilder sb = new StringBuilder();
                char separator = ScopeViewTreeModel.isPackage(this.getIcon()) ? (char)'.' : '/';
                this.compacted.forEach(file2 -> sb.append(file2.getName()).append(separator));
                return sb.append(this.getVirtualFile().getName()).toString();
            }
            return this.getVirtualFile().getName();
        }

        @Nullable
        private String getPackageName() {
            String name;
            PsiDirectoryFactory factory;
            PsiFileSystemItem element;
            PsiFileSystemItem psiFileSystemItem = element = !ScopeViewTreeModel.isPackage(this.getIcon()) ? null : this.findFileSystemItem(this.getVirtualFile());
            if (element instanceof PsiDirectory && element.isValid() && (factory = PsiDirectoryFactory.getInstance(element.getProject())) != null && factory.isPackage((PsiDirectory)element) && factory.isValidPackageName(name = factory.getQualifiedName((PsiDirectory)element, false))) {
                return name;
            }
            return null;
        }
    }

    private final class ProjectNode
    extends Node {
        private volatile HashMap<Object, RootNode> roots;
        volatile TreeStructureProvider provider;
        volatile ProjectViewNodeDecorator decorator;

        ProjectNode(@NotNull Project project, ViewSettings settings) {
            super(project, project, settings);
            this.roots = new HashMap();
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Project);
            presentation.setPresentableText(this.toString());
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            Project project = this.getProject();
            return project == null || project.isDisposed() ? null : FileUtil.getLocationRelativeToUserHome((String)project.getPresentableUrl());
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            HashMap<Object, RootNode> oldRoots = this.roots;
            HashMap newRoots = new HashMap();
            Mapper<RootNode, ProjectFileNode> mapper = new Mapper<RootNode, ProjectFileNode>(RootNode::new, oldRoots);
            ScopeViewTreeModel.this.model.getChildren(ScopeViewTreeModel.this.model.getRoot()).forEach(child2 -> {
                RootNode cfr_ignored_0 = (RootNode)((Object)((Object)newRoots.put(child2, mapper.apply(this, (ProjectFileNode)child2))));
            });
            this.roots = newRoots;
            if (newRoots.isEmpty()) {
                return Collections.emptyList();
            }
            return new Group(newRoots.values(), this.getSettings().isFlattenModules() || !ScopeViewTreeModel.hasModuleGroups(this.getProject())).createChildren(this, old);
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<? extends AbstractTreeNode> old) {
            boolean flattenPackages = this.getSettings().isFlattenPackages();
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            boolean compactDirectories = this.getSettings().isCompactDirectories();
            Mapper<FileNode, ProjectFileNode> mapper = new Mapper<FileNode, ProjectFileNode>(FileNode::new, FileNode.class, old);
            SmartList children2 = new SmartList();
            SmartList files2 = new SmartList();
            TreeStructureProvider provider = this.provider;
            ScopeViewTreeModel.this.model.getChildren(parent.getValue()).forEach(arg_0 -> this.lambda$createChildren$2(flattenPackages, compactDirectories, (List)children2, mapper, parent, hideEmptyMiddlePackages, provider, (List)files2, arg_0));
            if (provider == null) {
                return children2;
            }
            List nodes = ContainerUtil.map((Collection)files2, file2 -> new PsiFileNode(this.getProject(), (PsiFile)file2, this.getSettings()));
            children2.addAll(provider.modify((AbstractTreeNode)parent, (Collection)nodes, this.getSettings()));
            return children2;
        }

        private void visitPackages(@NotNull ProjectFileNode parent, boolean hideEmptyMiddle, @NotNull Consumer<? super ProjectFileNode> consumer) {
            AtomicBoolean empty = new AtomicBoolean(hideEmptyMiddle);
            AtomicBoolean middle = new AtomicBoolean();
            ScopeViewTreeModel.this.model.getChildren(parent).forEach(child2 -> {
                PsiFileSystemItem element = this.findFileSystemItem(child2.getVirtualFile());
                if (element instanceof PsiDirectory) {
                    Icon icon = ProjectNode.getFolderIcon((PsiElement)element);
                    if (ScopeViewTreeModel.isPackage(icon)) {
                        if (hideEmptyMiddle) {
                            middle.set(true);
                        }
                        this.visitPackages((ProjectFileNode)child2, hideEmptyMiddle, consumer);
                    } else if (hideEmptyMiddle) {
                        empty.set(false);
                    }
                } else if (element instanceof PsiFile && hideEmptyMiddle) {
                    empty.set(false);
                }
            });
            if (!empty.get() || !middle.get()) {
                consumer.consume((Object)parent);
            }
        }

        @Nullable
        private ProjectFileNode getSingleDirectory(ProjectFileNode parent) {
            List<ProjectFileNode> children2 = ScopeViewTreeModel.this.model.getChildren(parent);
            ProjectFileNode child2 = children2.size() != 1 ? null : children2.get(0);
            return child2 != null && child2.getVirtualFile().isDirectory() ? child2 : null;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            return this.roots.values().stream().anyMatch(root -> root.canRepresentOrContain(file2, area));
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 1;
        }

        @NotNull
        public String toString() {
            Project project = this.getProject();
            return project == null || project.isDisposed() ? "DISPOSED PROJECT" : project.getName();
        }

        private /* synthetic */ void lambda$createChildren$2(boolean flattenPackages, boolean compactDirectories, List children2, Mapper mapper, Node parent, boolean hideEmptyMiddlePackages, TreeStructureProvider provider, List files2, ProjectFileNode child2) {
            PsiFileSystemItem element = this.findFileSystemItem(child2.getVirtualFile());
            if (element instanceof PsiDirectory) {
                Icon icon = ProjectNode.getFolderIcon((PsiElement)element);
                if (!ScopeViewTreeModel.isPackage(icon) || !flattenPackages) {
                    ProjectFileNode childNext2;
                    ProjectFileNode projectFileNode = childNext2 = !compactDirectories ? null : this.getSingleDirectory(child2);
                    while (childNext2 != null) {
                        Icon iconNext = ProjectNode.getFolderIcon((PsiElement)this.findFileSystemItem(childNext2.getVirtualFile()));
                        if (icon.equals(iconNext)) {
                            child2 = childNext2;
                            childNext2 = this.getSingleDirectory(child2);
                            continue;
                        }
                        if (ScopeViewTreeModel.isFolder(icon) && !ScopeViewTreeModel.isPackage(iconNext)) {
                            icon = iconNext;
                            child2 = childNext2;
                            childNext2 = null;
                            continue;
                        }
                        childNext2 = null;
                    }
                    children2.add(mapper.apply(parent, child2, icon));
                } else if (!ScopeViewTreeModel.isPackage(parent.getIcon())) {
                    this.visitPackages(child2, hideEmptyMiddlePackages, (Consumer<? super ProjectFileNode>)((Consumer)childNext -> children2.add(mapper.apply(parent, childNext, AllIcons.Nodes.Package))));
                }
            } else if (element instanceof PsiFile) {
                if (provider == null) {
                    children2.add(mapper.apply(parent, child2));
                } else {
                    files2.add((PsiFile)element);
                }
            }
        }
    }

    private static abstract class Node
    extends ProjectViewNode<Object> {
        volatile NamedScopeFilter filter;
        volatile Collection<AbstractTreeNode> children = Collections.emptyList();
        volatile boolean childrenValid;

        Node(@NotNull Project project, @NotNull Object value, @NotNull ViewSettings settings) {
            super(project, value, settings);
        }

        Node(@NotNull Node parent, @NotNull Object value) {
            super(parent.getProject(), value, parent.getSettings());
            this.setParent((AbstractTreeNode)parent);
        }

        public int getWeight() {
            return 0;
        }

        public final boolean canRepresent(Object element) {
            if (element instanceof PsiFileSystemItem) {
                PsiFileSystemItem item = (PsiFileSystemItem)element;
                element = item.getVirtualFile();
            }
            return element instanceof VirtualFile && this.canRepresent((VirtualFile)element);
        }

        boolean canRepresent(@NotNull VirtualFile file2) {
            return file2.equals(this.getVirtualFile());
        }

        public final boolean contains(@NotNull VirtualFile file2) {
            AreaInstance area = ProjectFileNode.findArea(file2, this.getProject());
            return area != null && this.contains(file2, area);
        }

        protected boolean hasProblemFileBeneath() {
            WolfTheProblemSolver solver = ScopeViewTreeModel.getWolfTheProblemSolver(this.getProject());
            return solver == null || solver.hasProblemFilesBeneath(this::contains);
        }

        abstract boolean contains(@NotNull VirtualFile var1, @NotNull AreaInstance var2);

        public Color getFileStatusColor(@NotNull FileStatus status) {
            return status.getColor();
        }

        @NotNull
        abstract Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> var1);

        @NotNull
        public final Collection<AbstractTreeNode> getChildren() {
            if (this.childrenValid) {
                return this.children;
            }
            Collection<AbstractTreeNode> oldChildren = this.children;
            Collection<AbstractTreeNode> newChildren = this.createChildren(oldChildren);
            oldChildren.forEach(node -> node.setParent(null));
            newChildren.forEach(node -> node.setParent((AbstractTreeNode)this));
            this.children = newChildren;
            this.childrenValid = true;
            return newChildren;
        }

        @Nullable
        String getLocation() {
            return null;
        }

        final void decorate(@NotNull PresentationData presentation) {
            ProjectNode parent;
            ProjectViewNodeDecorator decorator;
            String location = this.getLocation();
            if (location != null) {
                if (this.getSettings().isShowURL()) {
                    presentation.setLocationString(location);
                } else {
                    presentation.setTooltip(location);
                }
            }
            ProjectViewNodeDecorator projectViewNodeDecorator = decorator = (parent = this.findParent(ProjectNode.class)) == null ? null : parent.decorator;
            if (decorator != null) {
                decorator.decorate(this, presentation);
            }
        }

        @NotNull
        static Icon getFolderIcon(@Nullable PsiElement element) {
            Icon icon = CompoundIconProvider.findIcon(element, 0);
            return icon != null ? icon : AllIcons.Nodes.Folder;
        }

        @Nullable
        final PsiFileSystemItem findFileSystemItem(@NotNull VirtualFile file2) {
            return PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)file2);
        }

        final <N> N findParent(Class<N> type) {
            for (Node node = this; node != null; node = node.getParent()) {
                if (!type.isInstance((Object)node)) continue;
                return type.cast((Object)node);
            }
            return null;
        }
    }
}

