/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull AnActionEvent e, @NotNull Project project) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file2 == null && editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        ScratchFileCreationHelper.Context context = new ScratchFileCreationHelper.Context();
        context.text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
        if (!context.text.isEmpty()) {
            context.language = ScratchFileActions.getLanguageFromCaret(project, editor, file2);
            ScratchFileActions.checkLanguageAndTryToFixText(project, context, e.getDataContext());
        } else {
            context.text = StringUtil.notNullize((String)((String)e.getData(PlatformDataKeys.PREDEFINED_TEXT)));
        }
        context.ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        return context;
    }

    static void doCreateNewScratch(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        Language language = (Language)ObjectUtils.notNull((Object)context.language);
        if (context.fileExtension == null) {
            LanguageFileType fileType = language.getAssociatedFileType();
            context.fileExtension = fileType == null ? "" : fileType.getDefaultExtension();
        }
        ((ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(language)).beforeCreate(project, context);
        VirtualFile dir = context.ideView != null ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ArrayUtil.getFirstElement((Object[])context.ideView.getDirectories()))) : null;
        RootType rootType = dir == null ? null : ScratchFileService.getInstance().getRootType(dir);
        String relativePath = rootType != ScratchRootType.getInstance() ? "" : FileUtil.getRelativePath((String)ScratchFileService.getInstance().getRootPath(rootType), (String)dir.getPath(), (char)'/');
        String fileName2 = (StringUtil.isEmpty((String)relativePath) ? "" : relativePath + "/") + PathUtil.makeFileName((String)((String)ObjectUtils.notNull((Object)context.filePrefix, (Object)"scratch") + (context.fileCounter != null ? (Serializable)context.fileCounter.create() : "")), (String)context.fileExtension);
        VirtualFile file2 = ScratchRootType.getInstance().createScratchFile(project, fileName2, language, context.text, context.createOption);
        if (file2 == null) {
            return;
        }
        PsiNavigationSupport.getInstance().createNavigatable(project, file2, context.caretOffset).navigate(true);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (context.ideView != null && psiFile != null) {
            context.ideView.selectElement((PsiElement)psiFile);
        }
    }

    private static void checkLanguageAndTryToFixText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        if (context.language == null) {
            return;
        }
        ScratchFileCreationHelper handler2 = (ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context.language);
        if (handler2.prepareText(project, context, dataContext)) {
            return;
        }
        PsiFile psiFile = ScratchFileCreationHelper.parseHeader(project, context.language, context.text);
        PsiErrorElement firstError = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)psiFile).traverse().filter(PsiErrorElement.class).first();
        if (firstError != null && firstError.getParent() == psiFile) {
            context.language = null;
        }
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element != null ? element.getContainingFile() : psiFile;
        Language language = file2.getLanguage();
        if (language == StdLanguages.TEXT && file2.getFileType() instanceof InternalFileType) {
            return StdLanguages.XML;
        }
        return language;
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            JBIterable files2 = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project == null || files2.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project);
            if (!files2.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set languages = (Set)files2.filter(isScratch).map(this.fileLanguage(project)).filter(Conditions.notNull()).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
            String langName = languages.size() == 1 ? ((Language)languages.iterator().next()).getDisplayName() : languages.size() + " different";
            e.getPresentation().setText(String.format("Change %s (%s)...", this.getLanguageTerm(), langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        protected String getLanguageTerm() {
            return "Language";
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            JBIterable files2 = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(this.fileFilter(project));
            if (project == null || files2.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project, "Change " + this.getLanguageTerm(), (JBIterable<? extends VirtualFile>)files2);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(Project project) {
            return file2 -> !file2.isDirectory() && ScratchRootType.getInstance().containsFile((VirtualFile)file2);
        }

        @NotNull
        protected Function<VirtualFile, Language> fileLanguage(final @NotNull Project project) {
            return new Function<VirtualFile, Language>(){
                final ScratchFileService fileService = ScratchFileService.getInstance();

                public Language fun(VirtualFile file2) {
                    Language lang = (Language)this.fileService.getScratchesMapping().getMapping(file2);
                    return lang != null ? lang : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
                }
            };
        }

        protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project, @NotNull String title, @NotNull JBIterable<? extends VirtualFile> files2) {
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings mapping = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project, title, files2, (PerFileMappings<Language>)mapping).showInBestPositionFor(e.getDataContext());
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            boolean enabled = e.getProject() != null && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(e, project);
            context.filePrefix = "buffer";
            context.createOption = ScratchFileService.Option.create_if_missing;
            context.fileCounter = () -> ScratchFileActions.nextBufferIndex();
            if (context.language == null) {
                context.language = StdLanguages.TEXT;
            }
            ScratchFileActions.doCreateNewScratch(project, context);
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        private static final Icon ICON = LayeredIcon.create((Icon)AllIcons.FileTypes.Text, (Icon)AllIcons.Actions.Scratch);
        private static final String ACTION_ID = "NewScratchFile";
        private final NotNullLazyValue<String> myActionText = NotNullLazyValue.createValue(() -> NewActionGroup.isActionInNewPopupMenu((AnAction)this) ? ActionsBundle.actionText((String)ACTION_ID) : ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]));

        public NewFileAction() {
            this.getTemplatePresentation().setIcon(ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            this.getTemplatePresentation().setText((String)this.myActionText.getValue());
            Project project = e.getProject();
            String place = e.getPlace();
            boolean enabled = project != null && (e.isFromActionToolbar() || ActionPlaces.isMainMenuOrActionSearch((String)place) || ActionPlaces.isPopupPlace((String)place) && e.getData(LangDataKeys.IDE_VIEW) != null);
            e.getPresentation().setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e, e.getPresentation());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(e, project);
            Consumer consumer = l -> {
                context.language = l;
                ((ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context.language)).prepareText(project, context, DataContext.EMPTY_CONTEXT);
                ScratchFileActions.doCreateNewScratch(project, context);
            };
            if (context.language != null) {
                consumer.consume((Object)context.language);
            } else {
                LRUPopupBuilder.forFileLanguages(project, ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]), null, (Consumer<? super Language>)consumer).showCenteredInCurrentWindow(project);
            }
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e, @NotNull Presentation presentation) {
            presentation.setText((String)this.myActionText.getValue());
            presentation.setIcon(ICON);
            if ("MainMenu".equals(e.getPlace()) && !NewActionGroup.isActionInNewPopupMenu((AnAction)this)) {
                presentation.setIcon(null);
            }
        }
    }
}

