/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return Registry.is((String)"ide.scratch.in.project.view") && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(final Project project) {
        super(project);
        ScratchProjectViewPane.registerUpdaters(project, this, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (this.updateTarget == null) {
                    AbstractProjectViewPane abstractProjectViewPane = this.updateTarget = !ScratchProjectViewPane.isScratchesMergedIntoProjectTab() ? ScratchProjectViewPane.this : ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        return ID;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return AllIcons.Scope.Scratches;
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    private static void registerUpdaters(@NotNull Project project, @NotNull Disposable disposable, final @NotNull Runnable onUpdate) {
        final String scratchPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)PathManager.getScratchPath()));
        project.getMessageBus().connect(disposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean update;
                boolean bl = update = JBIterable.from(events).find(e -> {
                    VirtualFile parent;
                    VirtualFile file2 = e.getFile();
                    VirtualFile virtualFile = parent = file2 == null ? null : file2.getParent();
                    if (parent == null) {
                        return false;
                    }
                    return ScratchUtil.isScratch(parent) || file2.isDirectory() && parent.getPath().startsWith(scratchPath);
                }) != null;
                if (update) {
                    onUpdate.run();
                }
            }
        });
        for (RootType rootType : RootType.getAllRootTypes()) {
            if (rootType.isHidden()) continue;
            rootType.registerTreeUpdater(project, disposable, onUpdate);
        }
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                if (!vFile.isInLocalFileSystem()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootType) {
        VirtualFile virtualFile = ScratchProjectViewPane.getVirtualFile(rootType);
        return virtualFile == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull RootType rootType) {
        String path = ScratchFileService.getInstance().getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull ViewSettings settings) {
        return new MyProjectNode(project, settings);
    }

    @Nullable
    private static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull RootType rootType, @NotNull ViewSettings settings) {
        if (rootType.isHidden()) {
            return null;
        }
        MyRootNode node = new MyRootNode(project, rootType, settings);
        return node.isEmpty() ? null : node;
    }

    private static void customizePresentation(@NotNull BasePsiNode node, @NotNull PresentationData data) {
        Icon icon;
        MyRootNode rootNode;
        VirtualFile file2 = (VirtualFile)ObjectUtils.notNull((Object)node.getVirtualFile());
        Project project = (Project)ObjectUtils.notNull((Object)node.getProject());
        AbstractTreeNode parent = node.getParent();
        MyRootNode myRootNode = parent instanceof MyRootNode ? (MyRootNode)parent : (rootNode = parent instanceof PsiDirectoryNode ? (MyRootNode)((PsiDirectoryNode)parent).getFilter() : null);
        if (rootNode == null) {
            return;
        }
        RootType rootType = rootNode.getRootType();
        String name = rootType.substituteName(project, file2);
        if (name != null) {
            data.setPresentableText(name);
        }
        if ((icon = rootType.substituteIcon(project, file2)) != null) {
            data.setIcon(icon);
        }
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project, @NotNull RootType type, ViewSettings settings) {
            super(project, (Object)type, settings);
        }

        @NotNull
        public RootType getRootType() {
            return (RootType)ObjectUtils.notNull((Object)this.getValue());
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return ScratchFileService.getInstance().getRootType(file2) == this.getValue();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchProjectViewPane.getVirtualFile(this.getRootType());
        }

        @NotNull
        public Collection<VirtualFile> getRoots() {
            return MyRootNode.getDefaultRootsFor((VirtualFile)this.getVirtualFile());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            return MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project = (Project)ObjectUtils.notNull((Object)this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode> getDirectoryChildrenImpl(final @NotNull Project project, @Nullable PsiDirectory directory, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter) {
            final ArrayList result2 = ContainerUtil.newArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (filter.shouldShow(element)) {
                        if (element instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project, (PsiDirectory)element, settings, filter){

                                @Override
                                public Collection<AbstractTreeNode> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        } else if (element instanceof PsiFile) {
                            result2.add(new PsiFileNode(project, (PsiFile)element, settings){

                                @Override
                                public Comparable getTypeSortKey() {
                                    PsiFile value = (PsiFile)this.getValue();
                                    Language language = value == null ? null : value.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        }
                    }
                    return true;
                }
            };
            return (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> MyRootNode.lambda$getDirectoryChildrenImpl$0(directory, (PsiElementProcessor)processor2, result2));
        }

        private static /* synthetic */ List lambda$getDirectoryChildrenImpl$0(PsiDirectory directory, PsiElementProcessor processor2, List result2) {
            if (directory == null || !directory.isValid()) {
                return Collections.emptyList();
            }
            directory.processChildren(processor2);
            return result2;
        }
    }

    private static class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)"Scratches and Consoles", settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list2 = ContainerUtil.newArrayList();
            for (RootType rootType : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull((Collection)list2, (Object)ScratchProjectViewPane.createRootNode(this.getProject(), rootType, this.getSettings()));
            }
            return list2;
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.Scope.Scratches);
        }

        public boolean canRepresent(Object element) {
            VirtualFile virtualFile;
            PsiElement item = element instanceof PsiElement ? (PsiElement)element : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Comparing.equal((String)virtualFile.getPath(), (String)FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(@NotNull Project project) {
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            return ScratchProjectViewPane.createRootNode(project, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }

    public static class MyStructureProvider
    implements TreeStructureProvider,
    DumbAware {
        @NotNull
        public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
            Project project;
            Project project2 = project = parent instanceof ProjectViewProjectNode ? parent.getProject() : null;
            if (project == null || !ScratchProjectViewPane.isScratchesMergedIntoProjectTab()) {
                return children2;
            }
            if (children2.isEmpty() && JBIterable.from((Iterable)RootType.getAllRootTypes()).filterMap(o -> ScratchProjectViewPane.createRootNode(project, o, settings)).isEmpty()) {
                return children2;
            }
            ArrayList<AbstractTreeNode> list2 = new ArrayList<AbstractTreeNode>(children2.size() + 1);
            list2.addAll(children2);
            list2.add(ScratchProjectViewPane.createRootNode(project, settings));
            return list2;
        }

        @Nullable
        public Object getData(@NotNull Collection<AbstractTreeNode> selected, @NotNull String dataId) {
            AbstractTreeNode single;
            if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (single = (AbstractTreeNode)JBIterable.from(selected).single()) instanceof MyRootNode) {
                VirtualFile file2 = ((MyRootNode)single).getVirtualFile();
                Project project = single.getProject();
                return file2 == null || project == null ? null : PsiManager.getInstance((Project)project).findDirectory(file2);
            }
            return null;
        }
    }
}

