/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ScratchesSearchScope
extends GlobalSearchScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> SCRATCHES_SCOPE_KEY = NotNullLazyKey.create((String)"SCRATCHES_SCOPE_KEY", project -> new ScratchesSearchScope((Project)project, ScratchFileService.getInstance()));
    private final ScratchFileService myService;

    @NotNull
    public static GlobalSearchScope getScratchesScope(@NotNull Project project) {
        return (GlobalSearchScope)SCRATCHES_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    private ScratchesSearchScope(@NotNull Project project, @NotNull ScratchFileService service2) {
        super(project);
        this.myService = service2;
    }

    @NotNull
    public String getDisplayName() {
        return "Scratches and Consoles";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        RootType rootType = this.myService.getRootType(file2);
        return rootType != null && !rootType.isHidden();
    }

    public boolean isSearchOutsideRootModel() {
        return true;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

