/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class IdeStartupScripts
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";

    IdeStartupScripts() {
    }

    public void componentsInitialized() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final MessageBusConnection connection = application.getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            Future<List<Pair<File, IdeScriptEngine>>> future;

            public void projectOpened(@NotNull Project project) {
                if (this.future == null) {
                    this.future = PooledThreadExecutor.INSTANCE.submit(() -> IdeStartupScripts.prepareScriptsAndEngines());
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (!project.isOpen()) {
                        return;
                    }
                    connection.disconnect();
                    IdeStartupScripts.runAllScriptsImpl(project, this.future);
                });
            }
        });
    }

    @NotNull
    private static List<Pair<File, IdeScriptEngine>> prepareScriptsAndEngines() {
        List<File> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (scripts.isEmpty()) {
            return Collections.emptyList();
        }
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList result2 = ContainerUtil.newArrayList();
        for (File script : scripts) {
            String extension = FileUtilRt.getExtension((String)script.getName());
            IdeScriptEngine engine = extension.isEmpty() ? null : scriptEngineManager.getEngineForFileExtension(extension, null);
            result2.add(Pair.create((Object)script, (Object)engine));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runImpl(@NotNull Project project, @NotNull File script, @NotNull IdeScriptEngine engine) throws IOException, IdeScriptException {
        String scriptText = FileUtil.loadFile((File)script);
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        LOG.info(script.getPath());
        long start2 = System.currentTimeMillis();
        try {
            engine.eval(scriptText);
        }
        finally {
            LOG.info("... completed in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start2)));
        }
    }

    @NotNull
    private static List<File> getScripts() {
        File directory = IdeStartupScripts.getScriptsRootDirectory();
        List scripts = JBIterable.of((Object[])(directory == null ? null : directory.listFiles())).filter(ExtensionsRootType.regularFileFilter()).toList();
        ContainerUtil.sort((List)scripts, (f1, f2) -> {
            String f1Name = f1 != null ? f1.getName() : null;
            String f2Name = f2 != null ? f2.getName() : null;
            return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
        });
        return scripts;
    }

    @Nullable
    private static File getScriptsRootDirectory() {
        PluginId corePlugin = (PluginId)ObjectUtils.assertNotNull((Object)PluginId.findId((String[])new String[]{"com.intellij"}));
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(corePlugin, SCRIPT_DIR, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void runAllScriptsImpl(@NotNull Project project, @NotNull Future<? extends List<Pair<File, IdeScriptEngine>>> future2) {
        try {
            for (Pair<File, IdeScriptEngine> pair : future2.get()) {
                try {
                    if (pair.second == null) {
                        LOG.warn(((File)pair.first).getPath() + " not supported (no script engine)");
                        continue;
                    }
                    IdeStartupScripts.runImpl(project, (File)pair.first, (IdeScriptEngine)pair.second);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        catch (ProcessCanceledException e) {
            LOG.warn("... cancelled");
        }
        catch (InterruptedException e) {
            LOG.warn("... interrupted");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

