/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.internal.statistic.collectors.fus.project.ProjectFsStatsCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private final List<Runnable> myPreStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myNotDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private boolean myPostStartupActivitiesPassed;
    private volatile boolean myPreStartupActivitiesPassed;
    private volatile boolean myStartupActivitiesRunning;
    private volatile boolean myStartupActivitiesPassed;
    private final Project myProject;
    private boolean myInitialRefreshScheduled;

    public StartupManagerImpl(Project project) {
        this.myProject = project;
    }

    private void checkNonDefaultProject() {
        LOG.assertTrue(!this.myProject.isDefault(), (Object)"Please don't register startup activities for the default project: they won't ever be run");
    }

    @Override
    public void registerPreStartupActivity(@NotNull Runnable runnable2) {
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        this.myPreStartupActivities.add(runnable2);
    }

    public void registerStartupActivity(@NotNull Runnable runnable2) {
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        this.myStartupActivities.add(runnable2);
    }

    public synchronized void registerPostStartupActivity(@NotNull Runnable runnable2) {
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myPostStartupActivitiesPassed, (Object)("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed));
        (DumbService.isDumbAware((Object)runnable2) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities).add(runnable2);
    }

    @Override
    public boolean startupActivityRunning() {
        return this.myStartupActivitiesRunning;
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public synchronized boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(() -> {
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Running Startup Activities");
            try {
                StartupManagerImpl.runActivities(this.myPreStartupActivities);
                StartupManagerImpl startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myPreStartupActivitiesPassed = true;
                    this.myStartupActivitiesRunning = true;
                }
                StartupManagerImpl.runActivities(this.myStartupActivities);
                startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myStartupActivitiesRunning = false;
                    this.myStartupActivitiesPassed = true;
                }
            }
            finally {
                token.finish();
            }
        });
    }

    public void runPostStartupActivitiesFromExtensions() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean uiFreezeWarned = new AtomicBoolean();
        for (StartupActivity extension : StartupActivity.POST_STARTUP_ACTIVITY.getExtensionList()) {
            Runnable runnable2 = () -> this.logActivityDuration(uiFreezeWarned, extension);
            if (DumbService.isDumbAware((Object)extension)) {
                StartupManagerImpl.runActivity(runnable2);
                continue;
            }
            this.queueSmartModeActivity(runnable2);
        }
        snapshot.logResponsivenessSinceCreation("Post-startup activities under progress");
    }

    private void logActivityDuration(AtomicBoolean uiFreezeWarned, StartupActivity extension) {
        long duration = TimeoutUtil.measureExecutionTime(() -> extension.runActivity(this.myProject));
        Application app = ApplicationManager.getApplication();
        if (duration > 100L && !app.isUnitTestMode()) {
            boolean edt = app.isDispatchThread();
            if (edt && uiFreezeWarned.compareAndSet(false, true)) {
                LOG.info("Some post-startup activities freeze UI for noticeable time. Please consider making them DumbAware to do them in background under modal progress, or just making them faster to speed up project opening.");
            }
            LOG.info(extension.getClass().getSimpleName() + " run in " + duration + "ms " + (edt ? "on UI thread" : "under project opening modal progress"));
        }
    }

    private void queueSmartModeActivity(Runnable activity) {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> StartupManagerImpl.runActivity(activity));
    }

    public void runPostStartupActivities() {
        if (this.postStartupActivityPassed()) {
            return;
        }
        final Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment()) {
            this.checkFsSanity();
            this.checkProjectRoots();
        }
        StartupManagerImpl.runActivities(this.myDumbAwarePostStartupActivities);
        final DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        dumbService.runWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List dumbUnaware;
                app.assertIsDispatchThread();
                StartupManagerImpl.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities);
                while (!(dumbUnaware = StartupManagerImpl.this.takeDumbUnawareStartupActivities()).isEmpty()) {
                    dumbUnaware.forEach(x$0 -> StartupManagerImpl.this.queueSmartModeActivity(x$0));
                }
                if (dumbService.isDumb()) {
                    dumbService.runWhenSmart((Runnable)this);
                } else {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                    }
                }
            }
        });
    }

    private synchronized List<Runnable> takeDumbUnawareStartupActivities() {
        ArrayList<Runnable> result2 = new ArrayList<Runnable>(this.myNotDumbAwarePostStartupActivities);
        this.myNotDumbAwarePostStartupActivities.clear();
        return result2;
    }

    public void scheduleInitialVfsRefresh() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || this.myInitialRefreshScheduled) {
                return;
            }
            this.myInitialRefreshScheduled = true;
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
            Application app = ApplicationManager.getApplication();
            if (!app.isCommandLine()) {
                final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
                final MessageBusConnection connection = app.getMessageBus().connect();
                connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

                    public void afterProjectClosed(@NotNull Project project) {
                        if (project != StartupManagerImpl.this.myProject) {
                            return;
                        }
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                });
            } else {
                VirtualFileManager.getInstance().syncRefresh();
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void checkFsSanity() {
        try {
            String path = this.myProject.getProjectFilePath();
            if (path == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path, (boolean)true)) {
                return;
            }
            if (ProjectKt.isDirectoryBased(this.myProject)) {
                path = PathUtil.getParentPath((String)path);
            }
            boolean expected = SystemInfo.isFileSystemCaseSensitive;
            boolean actual = FileUtil.isFileSystemCaseSensitive((String)path);
            LOG.info(path + " case-sensitivity: expected=" + expected + " actual=" + actual);
            if (actual != expected) {
                int prefix = expected ? 1 : 0;
                String title = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.title", (Object[])new Object[0]);
                String text = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.message", (Object[])new Object[]{prefix});
                Notifications.Bus.notify((Notification)new Notification("System Messages", title, text, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER), (Project)this.myProject);
            }
            ProjectFsStatsCollector.caseSensitivity(this.myProject, actual);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkProjectRoots() {
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            return;
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational()) {
            ProjectFsStatsCollector.watchedRoots(this.myProject, -1);
            return;
        }
        PooledThreadExecutor.INSTANCE.submit(() -> {
            LOG.debug("FW/roots waiting started");
            while (true) {
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (!watcher.isSettingRoots()) break;
                TimeoutUtil.sleep((long)10L);
            }
            LOG.debug("FW/roots waiting finished");
            Collection<String> manualWatchRoots = watcher.getManualWatchRoots();
            int pctNonWatched = 0;
            if (!manualWatchRoots.isEmpty()) {
                SmartList nonWatched = new SmartList();
                for (VirtualFile root : roots) {
                    if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
                    String rootPath = root.getPath();
                    for (String manualWatchRoot : manualWatchRoots) {
                        if (!FileUtil.isAncestor((String)manualWatchRoot, (String)rootPath, (boolean)false)) continue;
                        nonWatched.add(rootPath);
                    }
                }
                if (!nonWatched.isEmpty()) {
                    String message = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
                    watcher.notifyOnFailure(message, null);
                    LOG.info("unwatched roots: " + nonWatched);
                    LOG.info("manual watches: " + manualWatchRoots);
                    pctNonWatched = (int)(100.0 * (double)nonWatched.size() / (double)roots.length);
                }
            }
            ProjectFsStatsCollector.watchedRoots(this.myProject, pctNonWatched);
        });
    }

    public void startCacheUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        try {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dumbService.queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        StartupManagerImpl.this.scheduleInitialVfsRefresh();
                    }

                    public String toString() {
                        return "initial refresh";
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static void runActivities(@NotNull List<? extends Runnable> activities) {
        while (!activities.isEmpty()) {
            StartupManagerImpl.runActivity(activities.remove(0));
        }
    }

    public static void runActivity(Runnable runnable2) {
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ServiceNotReadyException e) {
            LOG.error((Throwable)new Exception((Throwable)((Object)e)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.error(ex);
        }
    }

    public void runWhenProjectIsInitialized(@NotNull Runnable action) {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        Runnable runnable2 = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            StartupManagerImpl startupManagerImpl = this;
            synchronized (startupManagerImpl) {
                boolean initialized;
                boolean bl = initialized = this.myProject.isInitialized() || this.myProject.isDefault() || application.isUnitTestMode() && this.myPostStartupActivitiesPassed;
                if (!initialized) {
                    this.registerPostStartupActivity(action);
                    return;
                }
            }
            action.run();
        };
        GuiUtils.invokeLaterIfNeeded((Runnable)runnable2, (ModalityState)ModalityState.defaultModalityState());
    }

    public synchronized void prepareForNextTest() {
        this.myPreStartupActivities.clear();
        this.myStartupActivities.clear();
        this.myDumbAwarePostStartupActivities.clear();
        this.myNotDumbAwarePostStartupActivities.clear();
    }

    public synchronized void checkCleared() {
        try {
            assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
            assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
            assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
            assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
        }
        finally {
            this.prepareForNextTest();
        }
    }
}

