/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewComposite
implements StructureView {
    private final StructureViewDescriptor[] myStructureViews;

    public StructureViewComposite(StructureViewDescriptor ... views) {
        this.myStructureViews = views;
        for (StructureViewDescriptor descriptor : views) {
            Disposer.register((Disposable)this, (Disposable)descriptor.structureView);
        }
    }

    public boolean isOutdated() {
        return false;
    }

    @Nullable
    public StructureView getSelectedStructureView() {
        StructureViewDescriptor descriptor = (StructureViewDescriptor)ArrayUtil.getFirstElement((Object[])this.myStructureViews);
        return descriptor == null ? null : descriptor.structureView;
    }

    public FileEditor getFileEditor() {
        StructureView view = this.getSelectedStructureView();
        return view == null ? null : view.getFileEditor();
    }

    public boolean navigateToSelectedElement(boolean requestFocus) {
        StructureView view = this.getSelectedStructureView();
        return view != null && view.navigateToSelectedElement(requestFocus);
    }

    public JComponent getComponent() {
        StructureView view = this.getSelectedStructureView();
        return view == null ? null : view.getComponent();
    }

    public void dispose() {
    }

    public void centerSelectedRow() {
        StructureView view = this.getSelectedStructureView();
        if (view != null) {
            view.centerSelectedRow();
        }
    }

    public void restoreState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.restoreState();
        }
    }

    public void storeState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.storeState();
        }
    }

    @NotNull
    public StructureViewDescriptor[] getStructureViews() {
        return this.myStructureViews;
    }

    @NotNull
    public StructureViewModel getTreeModel() {
        StructureView view = this.getSelectedStructureView();
        if (view != null) {
            return view.getTreeModel();
        }
        class M
        extends TextEditorBasedStructureViewModel
        implements StructureViewTreeElement,
        ItemPresentation {
            M() {
                super(null, null);
            }

            @NotNull
            public StructureViewTreeElement getRoot() {
                return this;
            }

            public Object getValue() {
                return null;
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return this;
            }

            @NotNull
            public TreeElement[] getChildren() {
                return EMPTY_ARRAY;
            }

            @Nullable
            public String getPresentableText() {
                return null;
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }

            public void navigate(boolean requestFocus) {
            }

            public boolean canNavigate() {
                return false;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        }
        return new M();
    }

    public static class StructureViewDescriptor {
        public final String title;
        public final StructureViewModel structureModel;
        public final StructureView structureView;
        public final Icon icon;

        public StructureViewDescriptor(String title, @NotNull StructureView structureView, Icon icon) {
            this.title = title;
            this.structureModel = structureView.getTreeModel();
            this.structureView = structureView;
            this.icon = icon;
        }

        public StructureViewDescriptor(String title, @NotNull StructureViewModel structureModel, Icon icon) {
            this.title = title;
            this.structureModel = structureModel;
            this.structureView = null;
            this.icon = icon;
        }
    }
}

