/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public Object getKey() {
        return String.valueOf(this.getElement());
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    public Icon getIcon(boolean open2) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        return (StructureViewTreeElement[])AbstractTreeUi.calculateYieldingToWriteAction(this::doGetChildren);
    }

    @NotNull
    private StructureViewTreeElement[] doGetChildren() {
        T element = this.getElement();
        if (element == null) {
            return EMPTY_ARRAY;
        }
        return PsiTreeElementBase.mergeWithExtensions(element, this.getChildrenBase());
    }

    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        T value = this.getValue();
        return value == null ? that.getValue() == null : value.equals(that.getValue());
    }

    public int hashCode() {
        T value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    @NotNull
    public static StructureViewTreeElement[] mergeWithExtensions(@NotNull PsiElement element, @NotNull Collection<StructureViewTreeElement> baseChildren) {
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren));
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class<?> aClass = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            Object[] children2 = extension.getChildren(element);
            if (children2 != null) {
                ContainerUtil.addAll(result2, (Object[])children2);
            }
            extension.filterChildren(result2, (StructureViewTreeElement[])children2);
        }
        return result2.toArray(StructureViewTreeElement.EMPTY_ARRAY);
    }
}

