/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class TreeActionWrapper
extends ToggleAction
implements DumbAware,
ActionWithDelegate<TreeAction> {
    private final TreeAction myAction;
    private final TreeActionsOwner myStructureView;

    public TreeActionWrapper(@NotNull TreeAction action, @NotNull TreeActionsOwner structureView) {
        this.myAction = action;
        this.myStructureView = structureView;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        ActionPresentation actionPresentation = this.myAction.getPresentation();
        if (presentation.getClientProperty("HIDE_ICON") == null) {
            presentation.setIcon(actionPresentation.getIcon());
        }
        presentation.setText(actionPresentation.getText());
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return TreeModelWrapper.isActive(this.myAction, this.myStructureView);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        this.myStructureView.setActionActive(this.myAction.getName(), TreeModelWrapper.shouldRevert(this.myAction) != state);
    }

    @NotNull
    public TreeAction getDelegate() {
        return this.myAction;
    }

    public String getPresentableName() {
        return this.myAction.getName();
    }
}

